/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Windgeschwindigkeit (Mittel).
<p>
Geschwindigkeit des Windes in horizontaler Ebene
					(Komponente) in Meter pro Sekunde.
					Windgeschwindigkeit (Mittel) wird als vektorieller
					Mittelwert über ein gleitendes Zeitintervall von 10
					Minuten ermittelt. Bei gleichzeitiger Messung der
					Windrichtung sind die Sensoren an der gleichen
					Stelle zu platzieren.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 65535L,
	skalierung = 0.1,
	einheit = "m/s"
)
public class AttTlsUfdWindgeschwindigkeitMittel extends Zahl<		Double
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MIN_VALUE =
					Double
			.valueOf("0") * 		Double
			.valueOf("0.1");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MAX_VALUE =
					Double
			.valueOf("65535") * 		Double
			.valueOf("0.1");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "m/s";
	
	
	/**
	 * Erzeugte eine neues Attribut TLSUfdWindgeschwindigkeitMittel.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsUfdWindgeschwindigkeitMittel(final 		Double
	 value) {
		super(value);
	}
	
	private AttTlsUfdWindgeschwindigkeitMittel(final String zustand, final 		Double
	 value) {
		super(zustand, value);
	}
	
}
