/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Betriebsart in der FG 4 der TLS.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 7L,
	maximum = 255L,
	einheit = ""
)
public class AttTlsWzgBetriebsArt extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("7");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("255");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgBetriebsArt ZUSTAND_0_FREI = new AttTlsWzgBetriebsArt("frei", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgBetriebsArt ZUSTAND_1_NORMALBETRIEB = new AttTlsWzgBetriebsArt("Normalbetrieb", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgBetriebsArt ZUSTAND_2_BLINDBETRIEB = new AttTlsWzgBetriebsArt("Blindbetrieb", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgBetriebsArt ZUSTAND_3_HANDBETRIEB = new AttTlsWzgBetriebsArt("Handbetrieb", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgBetriebsArt ZUSTAND_4_AUTARKER_BETRIEB = new AttTlsWzgBetriebsArt("Autarker Betrieb", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgBetriebsArt ZUSTAND_5_TESTBETRIEB = new AttTlsWzgBetriebsArt("Testbetrieb", 		Short
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgBetriebsArt ZUSTAND_6_NOTBETRIEB = new AttTlsWzgBetriebsArt("Notbetrieb", 		Short
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsWzgBetriebsArt getZustand(final 		Short
	 value) {
		for (AttTlsWzgBetriebsArt e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsWzgBetriebsArt getZustand(final String value) {
		for (AttTlsWzgBetriebsArt e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsWzgBetriebsArt> getZustaende() {
		List<AttTlsWzgBetriebsArt> list = new ArrayList<AttTlsWzgBetriebsArt>();
		list.add(ZUSTAND_0_FREI);
		list.add(ZUSTAND_1_NORMALBETRIEB);
		list.add(ZUSTAND_2_BLINDBETRIEB);
		list.add(ZUSTAND_3_HANDBETRIEB);
		list.add(ZUSTAND_4_AUTARKER_BETRIEB);
		list.add(ZUSTAND_5_TESTBETRIEB);
		list.add(ZUSTAND_6_NOTBETRIEB);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSWzgBetriebsArt.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsWzgBetriebsArt(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsWzgBetriebsArt(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
