/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anschlusspunkt an einem Gerät, welches über ein oder
					mehrere Anschlusspunkte an Kommunikationspartnern
					mit diesen kommuniziert.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface AnschlussPunkt extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt,de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.objekte.IlseAnschlussPunkt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.anschlussPunkt"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Anschlusspunkte an einem Kommunikationspartner.
						Es könne aber auch mehrere Anschlusspunkte (an
						unterschiedlichen Kommunikationspartnern
						(Geräten) vorhanden sein (BUS).
<p>

</p>

@return die Menge AnschlussPunkteKommunikationsPartner oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.AnschlussPunktKommunikationsPartner> getAnschlussPunkteKommunikationsPartner();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zum Mitschneiden von OSI 3 und 7 Protokollen.
	<p>
	
	</p>
	@return der Datensatz Osi37Mitschnitt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.onlinedaten.OdOsi37Mitschnitt getOdOsi37Mitschnitt();
	
	/**
	Attributgruppe zum Mitschneiden von OSI 2 Protokollen.
	<p>
	
	</p>
	@return der Datensatz Osi2Mitschnitt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.onlinedaten.OdOsi2Mitschnitt getOdOsi2Mitschnitt();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AnschlussPunkt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdAnschlussPunkt getKdAnschlussPunkt();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Parametersatz mit Mithören-Einstellungen für OSI-2 und OSI-3&#47;7-Protokolle (Primary und Secondary), die über den zugeordneten Anschlusspunkt kommunizieren.
	<p>
	&lt;absatz&gt;
							Beim TLS-OSI-Primary Protokoll werden folgende Einstellungen unterstützt:
						&lt;&#47;absatz&gt;
						&lt;tabelle ausrichtung="m" rahmen="1" transponiert="n"&gt;
							&lt;titel&gt;TLS-OSI-2-Primary Einstellungen&lt;&#47;titel&gt;
							&lt;kopf&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;Name&lt;&#47;zelle&gt;
									&lt;zelle&gt;Default-Wert&lt;&#47;zelle&gt;
									&lt;zelle&gt;Bedeutung&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
							&lt;&#47;kopf&gt;
							&lt;rumpf&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.port&lt;&#47;zelle&gt;
									&lt;zelle&gt;&#47;dev&#47;ttyS0&lt;&#47;zelle&gt;
									&lt;zelle&gt;Name der seriellen Schnittstelle&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.bps&lt;&#47;zelle&gt;
									&lt;zelle&gt;9600&lt;&#47;zelle&gt;
									&lt;zelle&gt;Übertragungsgeschwindigkeit in Bit pro Sekunde&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.bits&lt;&#47;zelle&gt;
									&lt;zelle&gt;8&lt;&#47;zelle&gt;
									&lt;zelle&gt;Bits pro übertragenem Byte&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.stopbits&lt;&#47;zelle&gt;
									&lt;zelle&gt;1&lt;&#47;zelle&gt;
									&lt;zelle&gt;Anzahl Stopbits&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.parität&lt;&#47;zelle&gt;
									&lt;zelle&gt;gerade&lt;&#47;zelle&gt;
									&lt;zelle&gt;Parität (gerade|ungerade|gesetzt|gelöscht|keine)&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.paritätPrüfen&lt;&#47;zelle&gt;
									&lt;zelle&gt;ja&lt;&#47;zelle&gt;
									&lt;zelle&gt;Parität prüfen (ja|nein)&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.rts&lt;&#47;zelle&gt;
									&lt;zelle&gt;immer&lt;&#47;zelle&gt;
									&lt;zelle&gt;Soll RTS Signal gesetzt werden (immer|senden|nie)&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.rtsVorlauf&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
									&lt;zelle&gt;Sendevorlaufzeit in Millisekunden zwischen Setzen von RTS und Versand&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.rtsNachlauf&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
									&lt;zelle&gt;Sendenachlaufzeit in Millisekunden zwischen Versand und Rücksetzen von RTS&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.cts&lt;&#47;zelle&gt;
									&lt;zelle&gt;nein&lt;&#47;zelle&gt;
									&lt;zelle&gt;Soll vor dem Senden auf CTS gewartet werden (ja|nein)&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.dsr&lt;&#47;zelle&gt;
									&lt;zelle&gt;ja&lt;&#47;zelle&gt;
									&lt;zelle&gt;Soll mit dem DSR Signal der Anschluß von Kabel bzw. Modem geprüft werden (ja|nein)&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.empfangsTimeout&lt;&#47;zelle&gt;
									&lt;zelle&gt;40&lt;&#47;zelle&gt;
									&lt;zelle&gt;Zeitlücke zum Erkennen des Telegrammendes in Millisekunden&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.empfangsPufferNachVersandLöschen&lt;&#47;zelle&gt;
									&lt;zelle&gt;nein&lt;&#47;zelle&gt;
									&lt;zelle&gt;Nach dem Versand einschließlich rtsNachlauf wird der Eingangspuffer zusätzlich gelöscht (ja|nein). Dies ist sinnvoll, wenn Echo-Zeichen oder Schmierzeichen beim Umschalten der Senderichtung erkannt werden. Das Timing (rtsNachlauf) muss dann sehr genau eingestellt werden, weil sonst Teile des Antworttelegramms gelöscht werden können.&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;tc57.Tw&lt;&#47;zelle&gt;
									&lt;zelle&gt;40&lt;&#47;zelle&gt;
									&lt;zelle&gt;Wartezeit zwischen Empfang und Senden in Millisekunden (40 bis 200)&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;primary.Tap&lt;&#47;zelle&gt;
									&lt;zelle&gt;1000&lt;&#47;zelle&gt;
									&lt;zelle&gt;Antwortüberwachungszeit der Primary in Millisekunden (150 bis 400)&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;primary.wiederholungsAnzahl&lt;&#47;zelle&gt;
									&lt;zelle&gt;2&lt;&#47;zelle&gt;
									&lt;zelle&gt;Mindestanzahl der Telegrammwiederholungen bei Übertragungsfehlern auf einer Verbindung bevor diese neu initialisiert wird.&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;primary.wiederholungsDauer&lt;&#47;zelle&gt;
									&lt;zelle&gt;30000&lt;&#47;zelle&gt;
									&lt;zelle&gt;Mindestdauer in Millisekunden für Telegrammwiederholungen bei Übertragungsfehlern auf einer Verbindung bevor diese neu initialisiert wird.&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
							&lt;&#47;rumpf&gt;
						&lt;&#47;tabelle&gt;
	</p>
	@return der Datensatz ProtokollEinstellungenILSE.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.parameter.PdProtokollEinstellungenILSE getPdProtokollEinstellungenILSE();
	
	/**
	Attributgruppe zum Festlegen, ob mitgehört werden soll oder nicht.
	<p>
	
	</p>
	@return der Datensatz UeberwachungsStatus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmilsetls.parameter.PdUeberwachungsStatus getPdUeberwachungsStatus();
	
	/**
	Parametersatz mit Standard-Einstellungen für
						OSI-2-Protokolle (Primary und Secondary), die über
						den zugeordneten Anschlusspunkt kommunizieren.
	<p>
	&lt;absatz&gt;
							Beim TLS-OSI-Primary Protokoll werden folgende
							Einstellungen unterstützt:
						&lt;&#47;absatz&gt;
						&lt;tabelle ausrichtung="m" rahmen="1" transponiert="n"&gt;
							&lt;titel&gt;TLS-OSI-2-Primary Einstellungen&lt;&#47;titel&gt;
							&lt;kopf&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;Name&lt;&#47;zelle&gt;
									&lt;zelle&gt;Default-Wert&lt;&#47;zelle&gt;
									&lt;zelle&gt;Bedeutung&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
							&lt;&#47;kopf&gt;
							&lt;rumpf&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.port&lt;&#47;zelle&gt;
									&lt;zelle&gt;&#47;dev&#47;ttyS0&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Name der seriellen Schnittstelle
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.bps&lt;&#47;zelle&gt;
									&lt;zelle&gt;9600&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Übertragungsgeschwindigkeit in Bit
										pro Sekunde
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.bits&lt;&#47;zelle&gt;
									&lt;zelle&gt;8&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Bits pro übertragenem Byte
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.stopbits&lt;&#47;zelle&gt;
									&lt;zelle&gt;1&lt;&#47;zelle&gt;
									&lt;zelle&gt;Anzahl Stopbits&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.parität&lt;&#47;zelle&gt;
									&lt;zelle&gt;gerade&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Parität
										(gerade|ungerade|gesetzt|gelöscht|keine)
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.paritätPrüfen&lt;&#47;zelle&gt;
									&lt;zelle&gt;ja&lt;&#47;zelle&gt;
									&lt;zelle&gt;Parität prüfen (ja|nein)&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.rts&lt;&#47;zelle&gt;
									&lt;zelle&gt;immer&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Soll RTS Signal gesetzt werden
										(immer|senden|nie)
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.rtsVorlauf&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Sendevorlaufzeit in Millisekunden
										zwischen Setzen von RTS und Versand
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.rtsNachlauf&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Sendenachlaufzeit in Millisekunden
										zwischen Versand und Rücksetzen von
										RTS
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.cts&lt;&#47;zelle&gt;
									&lt;zelle&gt;nein&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Soll vor dem Senden auf CTS gewartet
										werden (ja|nein)
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.dsr&lt;&#47;zelle&gt;
									&lt;zelle&gt;ja&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Soll mit dem DSR Signal der Anschluß
										von Kabel bzw. Modem geprüft werden
										(ja|nein)
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;seriell.empfangsTimeout&lt;&#47;zelle&gt;
									&lt;zelle&gt;40&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Zeitlücke zum Erkennen des
										Telegrammendes in Millisekunden
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;
										seriell.empfangsPufferNachVersandLöschen
									&lt;&#47;zelle&gt;
									&lt;zelle&gt;nein&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Nach dem Versand einschließlich
										rtsNachlauf wird der Eingangspuffer
										zusätzlich gelöscht (ja|nein). Dies
										ist sinnvoll, wenn Echo-Zeichen oder
										Schmierzeichen beim Umschalten der
										Senderichtung erkannt werden. Das
										Timing (rtsNachlauf) muss dann sehr
										genau eingestellt werden, weil sonst
										Teile des Antworttelegramms gelöscht
										werden können.
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;tc57.Tw&lt;&#47;zelle&gt;
									&lt;zelle&gt;40&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Wartezeit zwischen Empfang und
										Senden in Millisekunden (40 bis 200)
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;primary.Tap&lt;&#47;zelle&gt;
									&lt;zelle&gt;1000&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Antwortüberwachungszeit der Primary
										in Millisekunden (150 bis 400)
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;
										primary.wiederholungsAnzahl
									&lt;&#47;zelle&gt;
									&lt;zelle&gt;2&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Mindestanzahl der
										Telegrammwiederholungen bei
										Übertragungsfehlern auf einer
										Verbindung bevor diese neu
										initialisiert wird.
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;
										primary.wiederholungsDauer
									&lt;&#47;zelle&gt;
									&lt;zelle&gt;30000&lt;&#47;zelle&gt;
									&lt;zelle&gt;
										Mindestdauer in Millisekunden für
										Telegrammwiederholungen bei
										Übertragungsfehlern auf einer
										Verbindung bevor diese neu
										initialisiert wird.
									&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
							&lt;&#47;rumpf&gt;
						&lt;&#47;tabelle&gt;
	</p>
	@return der Datensatz ProtokollEinstellungenStandard.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdProtokollEinstellungenStandard getPdProtokollEinstellungenStandard();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
