/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelergebnismeldung Achslasten und
					Kfz-Gesamtgewichte Version 1 udn 2 (FG 2 &#47; Typ
					60-62).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 2: DE-Block-Struktur im Typ
							60-61"Einzelergebnismeldung Achslasten und
							Kfz-Gesamtgewicht (Version 1-2)"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) und ID
							36 (ErgebnisMeldung aus Puffer) in
							Antwortrichtung
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Übertragung geschieht spontan (d.h. beim
							nächsten Polling-Abruf) nach der Verwiegung
							eines Fahrzeugs. Die Daten können nicht
							abgerufen werden.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 14
 */
public class OdTlsAxlEinzelErgebnisMeldungAchsLastenUndKfzGesamtGewichteVersion1Bis2 extends AbstractOnlineDatensatz<OdTlsAxlEinzelErgebnisMeldungAchsLastenUndKfzGesamtGewichteVersion1Bis2.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
				 _fzTyp
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
				 _fzLaenge
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vFz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
				 _fzAbstand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 _fzGesamtGewicht
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlUeberladung
				 _fzUeberladung
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlUeberlastungAchse
				> _ueberlastungAchse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlUeberlastungAchse
				>(0, true);
		
			/**
			Fahrzeugtyp.
			<p>
			
			</p>
			
			@return der Wert von FzTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
				 getFzTyp() {
				return _fzTyp;
			}
		
			/**
			Fahrzeugtyp.
			<p>
			
			</p>
			
			@param _fzTyp der neue Wert von FzTyp.
			*/
			public void setFzTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
			 _fzTyp) {
				this._fzTyp = _fzTyp;
			}
		
			/**
			Fahrzeuglänge.
			<p>
			
			</p>
			
			@return der Wert von FzLaenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
				 getFzLaenge() {
				return _fzLaenge;
			}
		
			/**
			Fahrzeuglänge.
			<p>
			
			</p>
			
			@param _fzLaenge der neue Wert von FzLaenge.
			*/
			public void setFzLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
			 _fzLaenge) {
				this._fzLaenge = _fzLaenge;
			}
		
			/**
			Geschwindigkeit des Fahrzeugs.
			<p>
			
			</p>
			
			@return der Wert von VFz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVFz() {
				return _vFz;
			}
		
			/**
			Geschwindigkeit des Fahrzeugs.
			<p>
			
			</p>
			
			@param _vFz der neue Wert von VFz.
			*/
			public void setVFz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vFz) {
				this._vFz = _vFz;
			}
		
			/**
			Fahrzeugabstand.
			<p>
			In diesem Attribut wird der Abstand zwischen dem
									Ende des vorherfahrenden Fahrzeugs und dem
									Beginn dieses Fahrzeugs abgespeichert. Als
									Abstand wird das Produkt aus der gemessener
									Nettozeitlücke zum vorausfahrenden Fahrzeug und
									Geschwindigkeit des aktuellen Fahrzeugs
									gespeichert. Bei dem ersten Messwert wird "Wert
									nicht ermittelbar" eingetragen.
			</p>
			
			@return der Wert von FzAbstand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
				 getFzAbstand() {
				return _fzAbstand;
			}
		
			/**
			Fahrzeugabstand.
			<p>
			In diesem Attribut wird der Abstand zwischen dem
									Ende des vorherfahrenden Fahrzeugs und dem
									Beginn dieses Fahrzeugs abgespeichert. Als
									Abstand wird das Produkt aus der gemessener
									Nettozeitlücke zum vorausfahrenden Fahrzeug und
									Geschwindigkeit des aktuellen Fahrzeugs
									gespeichert. Bei dem ersten Messwert wird "Wert
									nicht ermittelbar" eingetragen.
			</p>
			
			@param _fzAbstand der neue Wert von FzAbstand.
			*/
			public void setFzAbstand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
			 _fzAbstand) {
				this._fzAbstand = _fzAbstand;
			}
		
			/**
			tatsächliches Gesamtgewicht.
			<p>
			
			</p>
			
			@return der Wert von FzGesamtGewicht.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 getFzGesamtGewicht() {
				return _fzGesamtGewicht;
			}
		
			/**
			tatsächliches Gesamtgewicht.
			<p>
			
			</p>
			
			@param _fzGesamtGewicht der neue Wert von FzGesamtGewicht.
			*/
			public void setFzGesamtGewicht(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _fzGesamtGewicht) {
				this._fzGesamtGewicht = _fzGesamtGewicht;
			}
		
			/**
			Überschreitung des zulässigen Gesamtgewichts.
			<p>
			
			</p>
			
			@return der Wert von FzUeberladung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlUeberladung
				 getFzUeberladung() {
				return _fzUeberladung;
			}
		
			/**
			Überschreitung des zulässigen Gesamtgewichts.
			<p>
			
			</p>
			
			@param _fzUeberladung der neue Wert von FzUeberladung.
			*/
			public void setFzUeberladung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlUeberladung
			 _fzUeberladung) {
				this._fzUeberladung = _fzUeberladung;
			}
		
			/**
			Einzelinformationen zu überladen Fahrzeugen.
			<p>
			
			</p>
			
			@return der Wert von UeberlastungAchse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlUeberlastungAchse
				> getUeberlastungAchse() {
				return _ueberlastungAchse;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getFzTyp() != null) {
		                if (getFzTyp().isZustand()) {
		                    datum.getUnscaledValue("FzTyp").setText(getFzTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FzTyp").set(getFzTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFzLaenge() != null) {
		                if (getFzLaenge().isZustand()) {
		                    datum.getUnscaledValue("FzLänge").setText(getFzLaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FzLänge").set(getFzLaenge().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVFz() != null) {
		                if (getVFz().isZustand()) {
		                    datum.getUnscaledValue("vFz").setText(getVFz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vFz").set(getVFz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFzAbstand() != null) {
		                if (getFzAbstand().isZustand()) {
		                    datum.getUnscaledValue("FzAbstand").setText(getFzAbstand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FzAbstand").set(getFzAbstand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFzGesamtGewicht() != null) {
		                if (getFzGesamtGewicht().isZustand()) {
		                    datum.getUnscaledValue("FzGesamtGewicht").setText(getFzGesamtGewicht().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FzGesamtGewicht").set(getFzGesamtGewicht().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFzUeberladung() != null) {
		                if (getFzUeberladung().isZustand()) {
		                    datum.getUnscaledValue("FzÜberladung").setText(getFzUeberladung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FzÜberladung").set(getFzUeberladung().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayUeberlastungAchse = datum.getArray("ÜberlastungAchse");
						arrayUeberlastungAchse.setLength(getUeberlastungAchse().size());
						for (int i = 0; i < arrayUeberlastungAchse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlUeberlastungAchse
							 atl = getUeberlastungAchse().get(i);
							atl.bean2Atl(arrayUeberlastungAchse.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FzTyp").isState()) {
								setFzTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
								.getZustand(daten.getScaledValue("FzTyp").getText()));
							} else {
							setFzTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
							(daten.
								getUnscaledValue
							("FzTyp").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FzLänge").isState()) {
								setFzLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
								.getZustand(daten.getScaledValue("FzLänge").getText()));
							} else {
							setFzLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
							(daten.
								getUnscaledValue
							("FzLänge").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vFz").isState()) {
								setVFz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vFz").getText()));
							} else {
							setVFz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vFz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FzAbstand").isState()) {
								setFzAbstand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
								.getZustand(daten.getScaledValue("FzAbstand").getText()));
							} else {
							setFzAbstand(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge4
							(daten.
								getUnscaledValue
							("FzAbstand").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FzGesamtGewicht").isState()) {
								setFzGesamtGewicht(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
								.getZustand(daten.getScaledValue("FzGesamtGewicht").getText()));
							} else {
							setFzGesamtGewicht(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							(daten.
								getUnscaledValue
							("FzGesamtGewicht").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FzÜberladung").isState()) {
								setFzUeberladung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlUeberladung
								.getZustand(daten.getScaledValue("FzÜberladung").getText()));
							} else {
							setFzUeberladung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlUeberladung
							(daten.
								getUnscaledValue
							("FzÜberladung").
									byteValue
							()));
							}
					// AttributListenDefinition
						final Data.Array arrayUeberlastungAchse = daten.getArray("ÜberlastungAchse");
						for (int i = 0; i < arrayUeberlastungAchse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlUeberlastungAchse
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlUeberlastungAchse
							 ();
							atl.atl2Bean(arrayUeberlastungAchse.getItem(i), factory);
							getUeberlastungAchse().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setFzTyp(getFzTyp());
							klon.setFzLaenge(getFzLaenge());
							klon.setVFz(getVFz());
							klon.setFzAbstand(getFzAbstand());
							klon.setFzGesamtGewicht(getFzGesamtGewicht());
							klon.setFzUeberladung(getFzUeberladung());
						klon._ueberlastungAchse = getUeberlastungAchse().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsAxlEinzelErgebnisMeldungAchsLastenUndKfzGesamtGewichteVersion1Bis2";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsAxlEinzelErgebnisMeldungAchsLastenUndKfzGesamtGewichteVersion1Bis2(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
