/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Ermittlung der Fehlerursache in der TLS
					Kommunikation, die aufgrund von Messwertausfällen
					ermittelt wurden.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsFehlerAnalyse extends AbstractOnlineDatensatz<OdTlsFehlerAnalyse.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Analyse,
				};
			}
	
			/**
			 * Analysewerte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Analyse = new Aspekte("Analyse", "asp.analyse");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFehlerAnalyse
				 _tlsFehlerAnalyse
				;
		
			/**
			Fehlermeldung und Handlungsanweisung der TLS
									Fehleranalyse.
			<p>
			
			</p>
			
			@return der Wert von TlsFehlerAnalyse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFehlerAnalyse
				 getTlsFehlerAnalyse() {
				return _tlsFehlerAnalyse;
			}
		
			/**
			Fehlermeldung und Handlungsanweisung der TLS
									Fehleranalyse.
			<p>
			
			</p>
			
			@param _tlsFehlerAnalyse der neue Wert von TlsFehlerAnalyse.
			*/
			public void setTlsFehlerAnalyse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFehlerAnalyse
			 _tlsFehlerAnalyse) {
				this._tlsFehlerAnalyse = _tlsFehlerAnalyse;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getTlsFehlerAnalyse() != null) {
		                if (getTlsFehlerAnalyse().isZustand()) {
		                    datum.getUnscaledValue("TlsFehlerAnalyse").setText(getTlsFehlerAnalyse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TlsFehlerAnalyse").set(getTlsFehlerAnalyse().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TlsFehlerAnalyse").isState()) {
								setTlsFehlerAnalyse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFehlerAnalyse
								.getZustand(daten.getScaledValue("TlsFehlerAnalyse").getText()));
							} else {
							setTlsFehlerAnalyse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFehlerAnalyse
							(daten.
								getUnscaledValue
							("TlsFehlerAnalyse").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setTlsFehlerAnalyse(getTlsFehlerAnalyse());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsFehlerAnalyse";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsFehlerAnalyse(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
