/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
DE-Fehler (FG alle &#47; Typ 1).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG alle (ausser FG 254): DE-Block-Struktur
							im Typ 1"DE-Fehlermeldung"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 1 (Fehler) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die DE-Fehlermeldung informiert die Zentrale
							über den Betriebszustand eines DE. Die
							Nachricht wird vom E&#47;AKonzentrator oder vom
							SM erzeugt. Es sind folgende zwei Fälle
							unterscheidbar:
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							1.) Es sind ein oder mehrere Kanäle des
							E&#47;A-Konzentrators defekt, die Kommunikation
							des E&#47;A-Konzentrators ist jedoch noch
							funktionsfähig.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Folge: Bei Eintritt der Störung sendet der
							E&#47;A-Konzentrator eine Nachricht mit je einem
							DE-Block pro gestörtem Kanal und Fehlercode
							Bit 0 = 1. Auf Abfrage antworten
							betriebsbereite Kanäle mit Fehlercode Bit 0
							= 0, defekte Kanäle antworten mit Fehlercode
							Bit 0 = 1.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							2.) Der E&#47;A-Konzentrator ist so defekt, dass
							die Kommunikation zum SM nicht mehr
							funktioniert.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Folge: Der SM generiert bei Eintritt der
							Störung anhand seiner Konfigurationsliste je
							eine Nachricht pro FG des E&#47;AKonzentrators
							mit je einem DE-Block pro vorhandenem DE und
							Fehlercode Bit 1 = 1. Auf Abfrage antworten
							betriebsbereite Kanäle mit Fehlercode Bit
							0..2 = 0, defekte Kanäle antworten mit
							Fehlercode Bit 1 = 1.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Ist ein Fehler aufgetreten, der weiterhin
							einen eingeschränkten Betrieb der DE
							zulässt, so ist dieser Teilausfall nicht
							durch ein gesetztes Fehlercode-Bit 0 oder 1
							auszudrücken.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Vielmehr ist dieser Ausfall durch die
							ergänzende DE-Fehlermeldung Typ 14 der
							Zentrale mitzuteilen. Abrufe der
							Fehlermeldung reicht der SM an den
							E&#47;A-Konzentrator weiter, wenn dieser mit dem
							SM kommunizieren kann, andernfalls
							beantwortet sie der SM selbst.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Eine Kopie des Passiv-Bits, welches für
							jeden Kanal mit dem Kanalsteuerbefehl
							eingestellt werden kann, wird in der
							DE-Fehlermeldung mit übertragen. Dies
							erspart eine zusätzliche Abfrage bzw.
							Antwortnachricht des Kanalsteuerbytes, um
							den vollständigen Kanalzustand zu erfahren
							(Siehe auch Kapitel 3.2.5 Kanalsteuerung).
							Dieses Bit ist jedoch nur gültig, wenn die
							Fehlernachricht vom E&#47;A-Konzentrator erzeugt
							wird, jedoch nicht, wenn das Stö&#47;SM = 1 ist.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
					&lt;sektion&gt;
						&lt;titel&gt;
							FG 254: DE-Block-Struktur im Typ
							1"DE-Fehlermeldung"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 1 (Fehler) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die DE-Fehlermeldung informiert die Zentrale
							über den Betriebszustand eines DE. Sie wird
							sowohl für die anwendungsbezogenen DEs als
							auch für die hardwarezugeordneten DEs (DE
							entspricht E&#47;A-Konzentrator unter FG 254)
							verwendet. Das Störungsereignis wird der
							Zentrale primär über die anwendungsbezogenen
							DE-Fehlermeldungen (FG 1..253) mitgeteilt.
							Die Nachricht wird vom E&#47;A-Konzentrator oder
							vom SM erzeugt. Es sind folgende zwei Fälle
							unterscheidbar:
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							1.) Es sind Teile des E&#47;A-Konzentrators
							defekt, die Kommunikation zum SM ist jedoch
							noch funktionsfähig. Folge: Die
							Systemsteuerung des E&#47;A-Konzentrators sendet
							eine Nachricht mit ihrer DE-Nummer und
							Fehlercode Bit 0 = 1.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							2.) Der E&#47;A-Konzentrator ist so defekt, dass
							die Kommunikation zum SM nicht mehr
							funktioniert.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Folge: Der SM generiert eine Nachricht mit
							der DE des E&#47;A-Konzentrators und Fehlercode
							Bit 1 = 1. Abrufe der Fehlermeldung reicht
							der SM an den E&#47;A-Konzentrator weiter, wenn
							dieser mit dem SM kommunizieren kann,
							andernfalls beantwortet sie der SM selbst.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Weitergehende Informationen siehe [TLS2002].
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsGloDeFehler extends AbstractOnlineDatensatz<OdTlsGloDeFehler.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEFehlerStatus
				 _dEFehlerStatus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
				 _dEKanalStatus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEProjektierungsStatus
				 _dEProjektierungsStatus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHerstellerDefinierterCode
				 _herstellerDefinierterCode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 _hersteller
				;
		
			/**
			TLS-DE-Fehler.
			<p>
			
			</p>
			
			@return der Wert von DEFehlerStatus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEFehlerStatus
				 getDEFehlerStatus() {
				return _dEFehlerStatus;
			}
		
			/**
			TLS-DE-Fehler.
			<p>
			
			</p>
			
			@param _dEFehlerStatus der neue Wert von DEFehlerStatus.
			*/
			public void setDEFehlerStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEFehlerStatus
			 _dEFehlerStatus) {
				this._dEFehlerStatus = _dEFehlerStatus;
			}
		
			/**
			TLS-Kanalstatus.
			<p>
			
			</p>
			
			@return der Wert von DEKanalStatus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
				 getDEKanalStatus() {
				return _dEKanalStatus;
			}
		
			/**
			TLS-Kanalstatus.
			<p>
			
			</p>
			
			@param _dEKanalStatus der neue Wert von DEKanalStatus.
			*/
			public void setDEKanalStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
			 _dEKanalStatus) {
				this._dEKanalStatus = _dEKanalStatus;
			}
		
			/**
			TLS-Projektierungstatus.
			<p>
			
			</p>
			
			@return der Wert von DEProjektierungsStatus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEProjektierungsStatus
				 getDEProjektierungsStatus() {
				return _dEProjektierungsStatus;
			}
		
			/**
			TLS-Projektierungstatus.
			<p>
			
			</p>
			
			@param _dEProjektierungsStatus der neue Wert von DEProjektierungsStatus.
			*/
			public void setDEProjektierungsStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEProjektierungsStatus
			 _dEProjektierungsStatus) {
				this._dEProjektierungsStatus = _dEProjektierungsStatus;
			}
		
			/**
			Reserviertes Nibble im DE-Fehlercode.
			<p>
			Gemäss aktueller TLS muss dieser Wert immer auf
									0 stehen und ist lediglich für Erweiterungen
									vorgesehen. Da in bestehenden Anlagen hier aber
									herstellerspezifische zusätzliche
									Fehlerkennungen übertragen wurden, kann der Wert
									auch von 0 abweichen. Die Interpretation ist
									allerdings herstellerspezifisch. Der Wert dient
									damit lediglich zur Ausgabe und wird ansonsten
									inhaltlich nicht interpretiert.
			</p>
			
			@return der Wert von HerstellerDefinierterCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHerstellerDefinierterCode
				 getHerstellerDefinierterCode() {
				return _herstellerDefinierterCode;
			}
		
			/**
			Reserviertes Nibble im DE-Fehlercode.
			<p>
			Gemäss aktueller TLS muss dieser Wert immer auf
									0 stehen und ist lediglich für Erweiterungen
									vorgesehen. Da in bestehenden Anlagen hier aber
									herstellerspezifische zusätzliche
									Fehlerkennungen übertragen wurden, kann der Wert
									auch von 0 abweichen. Die Interpretation ist
									allerdings herstellerspezifisch. Der Wert dient
									damit lediglich zur Ausgabe und wird ansonsten
									inhaltlich nicht interpretiert.
			</p>
			
			@param _herstellerDefinierterCode der neue Wert von HerstellerDefinierterCode.
			*/
			public void setHerstellerDefinierterCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHerstellerDefinierterCode
			 _herstellerDefinierterCode) {
				this._herstellerDefinierterCode = _herstellerDefinierterCode;
			}
		
			/**
			Hersteller gemäss TLS.
			<p>
			In der Regel wird bei Fehlermeldungen der Hersteller
								angegeben, der den Fehler erkannt hat, nicht
								derjenige, der für den Fehler verantwortlich ist
			</p>
			
			@return der Wert von Hersteller.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 getHersteller() {
				return _hersteller;
			}
		
			/**
			Hersteller gemäss TLS.
			<p>
			In der Regel wird bei Fehlermeldungen der Hersteller
								angegeben, der den Fehler erkannt hat, nicht
								derjenige, der für den Fehler verantwortlich ist
			</p>
			
			@param _hersteller der neue Wert von Hersteller.
			*/
			public void setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
			 _hersteller) {
				this._hersteller = _hersteller;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getDEFehlerStatus() != null) {
		                if (getDEFehlerStatus().isZustand()) {
		                    datum.getUnscaledValue("DEFehlerStatus").setText(getDEFehlerStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DEFehlerStatus").set(getDEFehlerStatus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDEKanalStatus() != null) {
		                if (getDEKanalStatus().isZustand()) {
		                    datum.getUnscaledValue("DEKanalStatus").setText(getDEKanalStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DEKanalStatus").set(getDEKanalStatus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDEProjektierungsStatus() != null) {
		                if (getDEProjektierungsStatus().isZustand()) {
		                    datum.getUnscaledValue("DEProjektierungsStatus").setText(getDEProjektierungsStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DEProjektierungsStatus").set(getDEProjektierungsStatus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getHerstellerDefinierterCode() != null) {
		                if (getHerstellerDefinierterCode().isZustand()) {
		                    datum.getUnscaledValue("HerstellerDefinierterCode").setText(getHerstellerDefinierterCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("HerstellerDefinierterCode").set(getHerstellerDefinierterCode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getHersteller() != null) {
		                if (getHersteller().isZustand()) {
		                    datum.getUnscaledValue("Hersteller").setText(getHersteller().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Hersteller").set(getHersteller().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DEFehlerStatus").isState()) {
								setDEFehlerStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEFehlerStatus
								.getZustand(daten.getScaledValue("DEFehlerStatus").getText()));
							} else {
							setDEFehlerStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEFehlerStatus
							(daten.
								getUnscaledValue
							("DEFehlerStatus").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DEKanalStatus").isState()) {
								setDEKanalStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
								.getZustand(daten.getScaledValue("DEKanalStatus").getText()));
							} else {
							setDEKanalStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
							(daten.
								getUnscaledValue
							("DEKanalStatus").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DEProjektierungsStatus").isState()) {
								setDEProjektierungsStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEProjektierungsStatus
								.getZustand(daten.getScaledValue("DEProjektierungsStatus").getText()));
							} else {
							setDEProjektierungsStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEProjektierungsStatus
							(daten.
								getUnscaledValue
							("DEProjektierungsStatus").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setHerstellerDefinierterCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHerstellerDefinierterCode
							(daten.
								getUnscaledValue
							("HerstellerDefinierterCode").
									byteValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Hersteller").isState()) {
								setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
								.getZustand(daten.getScaledValue("Hersteller").getText()));
							} else {
							setHersteller(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
							(daten.
								getUnscaledValue
							("Hersteller").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setDEFehlerStatus(getDEFehlerStatus());
							klon.setDEKanalStatus(getDEKanalStatus());
							klon.setDEProjektierungsStatus(getDEProjektierungsStatus());
							klon.setHerstellerDefinierterCode(getHerstellerDefinierterCode());
							klon.setHersteller(getHersteller());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsGloDeFehler";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsGloDeFehler(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
