/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Lve-ErgebnisMeldung Version 0-4 (FG 1 &#47; Typ
					49-53&#47;113-117).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 1: TLS-DE-Block-Struktur im Typ
							49-53&#47;113-117"Lve-ErgebnisMeldung Version
							0-4"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsLveErgebnisMeldungVersion0Bis4 extends AbstractOnlineDatensatz<OdTlsLveErgebnisMeldungVersion0Bis4.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vPkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
				 _tNetto
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsProzent
				 _b
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKfz
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qPkwAeGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qLkwAeGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
		
			/**
			Intervalldauer eines Erfassungszyklus.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer eines Erfassungszyklus.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Verkehrsstärke TLS gemessen.
			<p>
			
			</p>
			
			@return der Wert von QKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQKfz() {
				return _qKfz;
			}
		
			/**
			Verkehrsstärke TLS gemessen.
			<p>
			
			</p>
			
			@param _qKfz der neue Wert von QKfz.
			*/
			public void setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qKfz) {
				this._qKfz = _qKfz;
			}
		
			/**
			Verkehrsstärke TLS gemessen.
			<p>
			
			</p>
			
			@return der Wert von QLkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLkwAe() {
				return _qLkwAe;
			}
		
			/**
			Verkehrsstärke TLS gemessen.
			<p>
			
			</p>
			
			@param _qLkwAe der neue Wert von QLkwAe.
			*/
			public void setQLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLkwAe) {
				this._qLkwAe = _qLkwAe;
			}
		
			/**
			Geschwindigkeit TLS gemessen.
			<p>
			
			</p>
			
			@return der Wert von VPkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVPkwAe() {
				return _vPkwAe;
			}
		
			/**
			Geschwindigkeit TLS gemessen.
			<p>
			
			</p>
			
			@param _vPkwAe der neue Wert von VPkwAe.
			*/
			public void setVPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vPkwAe) {
				this._vPkwAe = _vPkwAe;
			}
		
			/**
			Geschwindigkeit TLS gemessen.
			<p>
			
			</p>
			
			@return der Wert von VLkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLkwAe() {
				return _vLkwAe;
			}
		
			/**
			Geschwindigkeit TLS gemessen.
			<p>
			
			</p>
			
			@param _vLkwAe der neue Wert von VLkwAe.
			*/
			public void setVLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLkwAe) {
				this._vLkwAe = _vLkwAe;
			}
		
			/**
			Zeitdauer gemäß TLS (0-25,4 s).
			<p>
			
			</p>
			
			@return der Wert von TNetto.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
				 getTNetto() {
				return _tNetto;
			}
		
			/**
			Zeitdauer gemäß TLS (0-25,4 s).
			<p>
			
			</p>
			
			@param _tNetto der neue Wert von TNetto.
			*/
			public void setTNetto(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
			 _tNetto) {
				this._tNetto = _tNetto;
			}
		
			/**
			Belegungsgrad des Detektors.
			<p>
			
			</p>
			
			@return der Wert von B.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsProzent
				 getB() {
				return _b;
			}
		
			/**
			Belegungsgrad des Detektors.
			<p>
			
			</p>
			
			@param _b der neue Wert von B.
			*/
			public void setB(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsProzent
			 _b) {
				this._b = _b;
			}
		
			/**
			Standardabweichung der Geschwindigkeit.
			<p>
			
			</p>
			
			@return der Wert von SKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSKfz() {
				return _sKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit.
			<p>
			
			</p>
			
			@param _sKfz der neue Wert von SKfz.
			*/
			public void setSKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sKfz) {
				this._sKfz = _sKfz;
			}
		
			/**
			Geglättete mittlere Geschwindigkeit.
			<p>
			
			</p>
			
			@return der Wert von VKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKfz() {
				return _vKfz;
			}
		
			/**
			Geglättete mittlere Geschwindigkeit.
			<p>
			
			</p>
			
			@param _vKfz der neue Wert von VKfz.
			*/
			public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKfz) {
				this._vKfz = _vKfz;
			}
		
			/**
			Anzahl der Pkw-ähnlichen Fahrzeige in der
									jeweiligen Geschwindigkeitsklasse im
									Erfassungsintervall.
			<p>
			
			</p>
			
			@return der Wert von QPkwAeGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQPkwAeGeschwKlasse() {
				return _qPkwAeGeschwKlasse;
			}
		
		
			/**
			Anzahl der Pkw-ähnlichen Fahrzeige in der
									jeweiligen Geschwindigkeitsklasse im
									Erfassungsintervall.
			<p>
			
			</p>
			
			@return der Wert von QLkwAeGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQLkwAeGeschwKlasse() {
				return _qLkwAeGeschwKlasse;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// GanzzahlAttributTyp
					if (getQKfz() != null) {
		                if (getQKfz().isZustand()) {
		                    datum.getUnscaledValue("qKfz").setText(getQKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qKfz").set(getQKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwAe() != null) {
		                if (getQLkwAe().isZustand()) {
		                    datum.getUnscaledValue("qLkwÄ").setText(getQLkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkwÄ").set(getQLkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkwAe() != null) {
		                if (getVPkwAe().isZustand()) {
		                    datum.getUnscaledValue("vPkwÄ").setText(getVPkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vPkwÄ").set(getVPkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkwAe() != null) {
		                if (getVLkwAe().isZustand()) {
		                    datum.getUnscaledValue("vLkwÄ").setText(getVLkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLkwÄ").set(getVLkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTNetto() != null) {
		                if (getTNetto().isZustand()) {
		                    datum.getUnscaledValue("tNetto").setText(getTNetto().toString());
		                } else {
							datum.
							getScaledValue
		                	("tNetto").set(getTNetto().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getB() != null) {
		                if (getB().isZustand()) {
		                    datum.getUnscaledValue("b").setText(getB().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("b").set(getB().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSKfz() != null) {
		                if (getSKfz().isZustand()) {
		                    datum.getUnscaledValue("sKfz").setText(getSKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sKfz").set(getSKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfz() != null) {
		                if (getVKfz().isZustand()) {
		                    datum.getUnscaledValue("vKfz").setText(getVKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKfz").set(getVKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkwAeGeschwKlasse() != null) {
						final Data.NumberArray arrayQPkwAeGeschwKlasse = datum.
							getUnscaledArray
							("qPkwÄGeschwKlasse");
						arrayQPkwAeGeschwKlasse.setLength(getQPkwAeGeschwKlasse().size());
						for (int i = 0; i < arrayQPkwAeGeschwKlasse.getLength(); ++i) {
							arrayQPkwAeGeschwKlasse.getValue(i).set(getQPkwAeGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQLkwAeGeschwKlasse() != null) {
						final Data.NumberArray arrayQLkwAeGeschwKlasse = datum.
							getUnscaledArray
							("qLkwÄGeschwKlasse");
						arrayQLkwAeGeschwKlasse.setLength(getQLkwAeGeschwKlasse().size());
						for (int i = 0; i < arrayQLkwAeGeschwKlasse.getLength(); ++i) {
							arrayQLkwAeGeschwKlasse.getValue(i).set(getQLkwAeGeschwKlasse().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qKfz").isState()) {
								setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qKfz").getText()));
							} else {
							setQKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkwÄ").isState()) {
								setQLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qLkwÄ").getText()));
							} else {
							setQLkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qLkwÄ").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vPkwÄ").isState()) {
								setVPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vPkwÄ").getText()));
							} else {
							setVPkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vPkwÄ").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLkwÄ").isState()) {
								setVLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vLkwÄ").getText()));
							} else {
							setVLkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLkwÄ").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("tNetto").isState()) {
								setTNetto(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
								.getZustand(daten.getScaledValue("tNetto").getText()));
							} else {
							setTNetto(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer1
							(daten.
								getScaledValue
							("tNetto").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("b").isState()) {
								setB(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsProzent
								.getZustand(daten.getScaledValue("b").getText()));
							} else {
							setB(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsProzent
							(daten.
								getUnscaledValue
							("b").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sKfz").isState()) {
								setSKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sKfz").getText()));
							} else {
							setSKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKfz").isState()) {
								setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vKfz").getText()));
							} else {
							setVKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQPkwAeGeschwKlasse = daten.
							getUnscaledArray
						("qPkwÄGeschwKlasse");
		
						for (int i = 0; i < arrayQPkwAeGeschwKlasse.getLength(); ++i) {
		                    if (arrayQPkwAeGeschwKlasse.getValue(i).isState()) {
		                        getQPkwAeGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQPkwAeGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQPkwAeGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQPkwAeGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQLkwAeGeschwKlasse = daten.
							getUnscaledArray
						("qLkwÄGeschwKlasse");
		
						for (int i = 0; i < arrayQLkwAeGeschwKlasse.getLength(); ++i) {
		                    if (arrayQLkwAeGeschwKlasse.getValue(i).isState()) {
		                        getQLkwAeGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQLkwAeGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQLkwAeGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQLkwAeGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon.setQKfz(getQKfz());
							klon.setQLkwAe(getQLkwAe());
							klon.setVPkwAe(getVPkwAe());
							klon.setVLkwAe(getVLkwAe());
							klon.setTNetto(getTNetto());
							klon.setB(getB());
							klon.setSKfz(getSKfz());
							klon.setVKfz(getVKfz());
						klon._qPkwAeGeschwKlasse = getQPkwAeGeschwKlasse().clone();
						klon._qLkwAeGeschwKlasse = getQLkwAeGeschwKlasse().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsLveErgebnisMeldungVersion0Bis4";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsLveErgebnisMeldungVersion0Bis4(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
