/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Lve-ErgebnisMeldung Version 24 (FG 1 &#47; Typ 79).
<p>
&lt;sektion&gt;
						&lt;titel&gt;FG 1: DE-Block-Struktur im Typ 79 "Lve-ErgebnisMeldung Version 24"&lt;&#47;titel&gt;
						&lt;absatz&gt;Wird verwendet mit ID 4 (Ergebnisse) und ID 36 (ErgebnisMeldung aus Puffer) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;Dieser DE-Block ist nur für Langzeitdaten mit BASt Geschwindigkeitsdaten vorgesehen.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class OdTlsLveErgebnisMeldungVersion24 extends AbstractOnlineDatensatz<OdTlsLveErgebnisMeldungVersion24.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qKfzNk
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qKrad
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLfw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qPkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qSattelKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qBus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 _vLVo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 _vSGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 _vBPA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 _sLVo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 _sSGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 _sBPA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85LVo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85SGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85BPA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v15LVo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v15SGV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v15BPA
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qLVoGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qSGVGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qBPAGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
		
			/**
			Intervalldauer.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von QKfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQKfzNk() {
				return _qKfzNk;
			}
		
			/**
			Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _qKfzNk der neue Wert von QKfzNk.
			*/
			public void setQKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qKfzNk) {
				this._qKfzNk = _qKfzNk;
			}
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@return der Wert von QKrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQKrad() {
				return _qKrad;
			}
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@param _qKrad der neue Wert von QKrad.
			*/
			public void setQKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qKrad) {
				this._qKrad = _qKrad;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von QLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLfw() {
				return _qLfw;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@param _qLfw der neue Wert von QLfw.
			*/
			public void setQLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLfw) {
				this._qLfw = _qLfw;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QPkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQPkwA() {
				return _qPkwA;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qPkwA der neue Wert von QPkwA.
			*/
			public void setQPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qPkwA) {
				this._qPkwA = _qPkwA;
			}
		
			/**
			Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@return der Wert von QLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLkw() {
				return _qLkw;
			}
		
			/**
			Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@param _qLkw der neue Wert von QLkw.
			*/
			public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLkw) {
				this._qLkw = _qLkw;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLkwA() {
				return _qLkwA;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qLkwA der neue Wert von QLkwA.
			*/
			public void setQLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLkwA) {
				this._qLkwA = _qLkwA;
			}
		
			/**
			Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QSattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQSattelKfz() {
				return _qSattelKfz;
			}
		
			/**
			Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qSattelKfz der neue Wert von QSattelKfz.
			*/
			public void setQSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qSattelKfz) {
				this._qSattelKfz = _qSattelKfz;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@return der Wert von QBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQBus() {
				return _qBus;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@param _qBus der neue Wert von QBus.
			*/
			public void setQBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qBus) {
				this._qBus = _qBus;
			}
		
			/**
			Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VLVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 getVLVo() {
				return _vLVo;
			}
		
			/**
			Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@param _vLVo der neue Wert von VLVo.
			*/
			public void setVLVo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
			 _vLVo) {
				this._vLVo = _vLVo;
			}
		
			/**
			Geschwindigkeit Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von VSGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 getVSGV() {
				return _vSGV;
			}
		
			/**
			Geschwindigkeit Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@param _vSGV der neue Wert von VSGV.
			*/
			public void setVSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
			 _vSGV) {
				this._vSGV = _vSGV;
			}
		
			/**
			Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VBPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 getVBPA() {
				return _vBPA;
			}
		
			/**
			Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _vBPA der neue Wert von VBPA.
			*/
			public void setVBPA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
			 _vBPA) {
				this._vBPA = _vBPA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SLVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 getSLVo() {
				return _sLVo;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@param _sLVo der neue Wert von SLVo.
			*/
			public void setSLVo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
			 _sLVo) {
				this._sLVo = _sLVo;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von SSGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 getSSGV() {
				return _sSGV;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@param _sSGV der neue Wert von SSGV.
			*/
			public void setSSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
			 _sSGV) {
				this._sSGV = _sSGV;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SBPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
				 getSBPA() {
				return _sBPA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _sBPA der neue Wert von SBPA.
			*/
			public void setSBPA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
			 _sBPA) {
				this._sBPA = _sBPA;
			}
		
			/**
			v85-Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85LVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85LVo() {
				return _v85LVo;
			}
		
			/**
			v85-Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@param _v85LVo der neue Wert von V85LVo.
			*/
			public void setV85LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85LVo) {
				this._v85LVo = _v85LVo;
			}
		
			/**
			v85-Geschwindigkeit Pkw Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von V85SGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85SGV() {
				return _v85SGV;
			}
		
			/**
			v85-Geschwindigkeit Pkw Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@param _v85SGV der neue Wert von V85SGV.
			*/
			public void setV85SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85SGV) {
				this._v85SGV = _v85SGV;
			}
		
			/**
			v85-Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85BPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85BPA() {
				return _v85BPA;
			}
		
			/**
			v85-Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v85BPA der neue Wert von V85BPA.
			*/
			public void setV85BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85BPA) {
				this._v85BPA = _v85BPA;
			}
		
			/**
			v15-Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V15LVo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV15LVo() {
				return _v15LVo;
			}
		
			/**
			v15-Geschwindigkeit Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@param _v15LVo der neue Wert von V15LVo.
			*/
			public void setV15LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v15LVo) {
				this._v15LVo = _v15LVo;
			}
		
			/**
			v15-Geschwindigkeit Pkw Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von V15SGV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV15SGV() {
				return _v15SGV;
			}
		
			/**
			v15-Geschwindigkeit Pkw Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@param _v15SGV der neue Wert von V15SGV.
			*/
			public void setV15SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v15SGV) {
				this._v15SGV = _v15SGV;
			}
		
			/**
			v15-Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V15BPA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV15BPA() {
				return _v15BPA;
			}
		
			/**
			v15-Geschwindigkeit Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v15BPA der neue Wert von V15BPA.
			*/
			public void setV15BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v15BPA) {
				this._v15BPA = _v15BPA;
			}
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Leichtverkehr ohne Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLVoGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQLVoGeschwKlasse() {
				return _qLVoGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Schwerer Güterverkehr.
			<p>
			
			</p>
			
			@return der Wert von QSGVGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQSGVGeschwKlasse() {
				return _qSGVGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Busse und Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QBPAGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQBPAGeschwKlasse() {
				return _qBPAGeschwKlasse;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// GanzzahlAttributTyp
					if (getQKfzNk() != null) {
		                if (getQKfzNk().isZustand()) {
		                    datum.getUnscaledValue("qKfzNk").setText(getQKfzNk().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qKfzNk").set(getQKfzNk().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQKrad() != null) {
		                if (getQKrad().isZustand()) {
		                    datum.getUnscaledValue("qKrad").setText(getQKrad().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qKrad").set(getQKrad().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkw() != null) {
		                if (getQPkw().isZustand()) {
		                    datum.getUnscaledValue("qPkw").setText(getQPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qPkw").set(getQPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLfw() != null) {
		                if (getQLfw().isZustand()) {
		                    datum.getUnscaledValue("qLfw").setText(getQLfw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLfw").set(getQLfw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkwA() != null) {
		                if (getQPkwA().isZustand()) {
		                    datum.getUnscaledValue("qPkwA").setText(getQPkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qPkwA").set(getQPkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkw() != null) {
		                if (getQLkw().isZustand()) {
		                    datum.getUnscaledValue("qLkw").setText(getQLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkw").set(getQLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwA() != null) {
		                if (getQLkwA().isZustand()) {
		                    datum.getUnscaledValue("qLkwA").setText(getQLkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkwA").set(getQLkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQSattelKfz() != null) {
		                if (getQSattelKfz().isZustand()) {
		                    datum.getUnscaledValue("qSattelKfz").setText(getQSattelKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qSattelKfz").set(getQSattelKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQBus() != null) {
		                if (getQBus().isZustand()) {
		                    datum.getUnscaledValue("qBus").setText(getQBus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qBus").set(getQBus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLVo() != null) {
		                if (getVLVo().isZustand()) {
		                    datum.getUnscaledValue("vLVo").setText(getVLVo().toString());
		                } else {
							datum.
							getScaledValue
		                	("vLVo").set(getVLVo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVSGV() != null) {
		                if (getVSGV().isZustand()) {
		                    datum.getUnscaledValue("vSGV").setText(getVSGV().toString());
		                } else {
							datum.
							getScaledValue
		                	("vSGV").set(getVSGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVBPA() != null) {
		                if (getVBPA().isZustand()) {
		                    datum.getUnscaledValue("vBPA").setText(getVBPA().toString());
		                } else {
							datum.
							getScaledValue
		                	("vBPA").set(getVBPA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSLVo() != null) {
		                if (getSLVo().isZustand()) {
		                    datum.getUnscaledValue("sLVo").setText(getSLVo().toString());
		                } else {
							datum.
							getScaledValue
		                	("sLVo").set(getSLVo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSSGV() != null) {
		                if (getSSGV().isZustand()) {
		                    datum.getUnscaledValue("sSGV").setText(getSSGV().toString());
		                } else {
							datum.
							getScaledValue
		                	("sSGV").set(getSSGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSBPA() != null) {
		                if (getSBPA().isZustand()) {
		                    datum.getUnscaledValue("sBPA").setText(getSBPA().toString());
		                } else {
							datum.
							getScaledValue
		                	("sBPA").set(getSBPA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85LVo() != null) {
		                if (getV85LVo().isZustand()) {
		                    datum.getUnscaledValue("v85LVo").setText(getV85LVo().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85LVo").set(getV85LVo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85SGV() != null) {
		                if (getV85SGV().isZustand()) {
		                    datum.getUnscaledValue("v85SGV").setText(getV85SGV().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85SGV").set(getV85SGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85BPA() != null) {
		                if (getV85BPA().isZustand()) {
		                    datum.getUnscaledValue("v85BPA").setText(getV85BPA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85BPA").set(getV85BPA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV15LVo() != null) {
		                if (getV15LVo().isZustand()) {
		                    datum.getUnscaledValue("v15LVo").setText(getV15LVo().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v15LVo").set(getV15LVo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV15SGV() != null) {
		                if (getV15SGV().isZustand()) {
		                    datum.getUnscaledValue("v15SGV").setText(getV15SGV().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v15SGV").set(getV15SGV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV15BPA() != null) {
		                if (getV15BPA().isZustand()) {
		                    datum.getUnscaledValue("v15BPA").setText(getV15BPA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v15BPA").set(getV15BPA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLVoGeschwKlasse() != null) {
						final Data.NumberArray arrayQLVoGeschwKlasse = datum.
							getUnscaledArray
							("qLVoGeschwKlasse");
						arrayQLVoGeschwKlasse.setLength(getQLVoGeschwKlasse().size());
						for (int i = 0; i < arrayQLVoGeschwKlasse.getLength(); ++i) {
							arrayQLVoGeschwKlasse.getValue(i).set(getQLVoGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQSGVGeschwKlasse() != null) {
						final Data.NumberArray arrayQSGVGeschwKlasse = datum.
							getUnscaledArray
							("qSGVGeschwKlasse");
						arrayQSGVGeschwKlasse.setLength(getQSGVGeschwKlasse().size());
						for (int i = 0; i < arrayQSGVGeschwKlasse.getLength(); ++i) {
							arrayQSGVGeschwKlasse.getValue(i).set(getQSGVGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQBPAGeschwKlasse() != null) {
						final Data.NumberArray arrayQBPAGeschwKlasse = datum.
							getUnscaledArray
							("qBPAGeschwKlasse");
						arrayQBPAGeschwKlasse.setLength(getQBPAGeschwKlasse().size());
						for (int i = 0; i < arrayQBPAGeschwKlasse.getLength(); ++i) {
							arrayQBPAGeschwKlasse.getValue(i).set(getQBPAGeschwKlasse().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qKfzNk").isState()) {
								setQKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qKfzNk").getText()));
							} else {
							setQKfzNk(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qKfzNk").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qKrad").isState()) {
								setQKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qKrad").getText()));
							} else {
							setQKrad(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qKrad").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qPkw").isState()) {
								setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qPkw").getText()));
							} else {
							setQPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qPkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLfw").isState()) {
								setQLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qLfw").getText()));
							} else {
							setQLfw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qLfw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qPkwA").isState()) {
								setQPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qPkwA").getText()));
							} else {
							setQPkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qPkwA").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkw").isState()) {
								setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qLkw").getText()));
							} else {
							setQLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qLkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkwA").isState()) {
								setQLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qLkwA").getText()));
							} else {
							setQLkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qLkwA").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qSattelKfz").isState()) {
								setQSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qSattelKfz").getText()));
							} else {
							setQSattelKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qSattelKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qBus").isState()) {
								setQBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qBus").getText()));
							} else {
							setQBus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qBus").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLVo").isState()) {
								setVLVo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
								.getZustand(daten.getScaledValue("vLVo").getText()));
							} else {
							setVLVo(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
							(daten.
								getScaledValue
							("vLVo").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vSGV").isState()) {
								setVSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
								.getZustand(daten.getScaledValue("vSGV").getText()));
							} else {
							setVSGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
							(daten.
								getScaledValue
							("vSGV").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vBPA").isState()) {
								setVBPA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
								.getZustand(daten.getScaledValue("vBPA").getText()));
							} else {
							setVBPA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
							(daten.
								getScaledValue
							("vBPA").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sLVo").isState()) {
								setSLVo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
								.getZustand(daten.getScaledValue("sLVo").getText()));
							} else {
							setSLVo(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
							(daten.
								getScaledValue
							("sLVo").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sSGV").isState()) {
								setSSGV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
								.getZustand(daten.getScaledValue("sSGV").getText()));
							} else {
							setSSGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
							(daten.
								getScaledValue
							("sSGV").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sBPA").isState()) {
								setSBPA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
								.getZustand(daten.getScaledValue("sBPA").getText()));
							} else {
							setSBPA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeitVersion24
							(daten.
								getScaledValue
							("sBPA").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85LVo").isState()) {
								setV85LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85LVo").getText()));
							} else {
							setV85LVo(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85LVo").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85SGV").isState()) {
								setV85SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85SGV").getText()));
							} else {
							setV85SGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85SGV").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85BPA").isState()) {
								setV85BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85BPA").getText()));
							} else {
							setV85BPA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85BPA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v15LVo").isState()) {
								setV15LVo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v15LVo").getText()));
							} else {
							setV15LVo(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v15LVo").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v15SGV").isState()) {
								setV15SGV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v15SGV").getText()));
							} else {
							setV15SGV(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v15SGV").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v15BPA").isState()) {
								setV15BPA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v15BPA").getText()));
							} else {
							setV15BPA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v15BPA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQLVoGeschwKlasse = daten.
							getUnscaledArray
						("qLVoGeschwKlasse");
		
						for (int i = 0; i < arrayQLVoGeschwKlasse.getLength(); ++i) {
		                    if (arrayQLVoGeschwKlasse.getValue(i).isState()) {
		                        getQLVoGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQLVoGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQLVoGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQLVoGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQSGVGeschwKlasse = daten.
							getUnscaledArray
						("qSGVGeschwKlasse");
		
						for (int i = 0; i < arrayQSGVGeschwKlasse.getLength(); ++i) {
		                    if (arrayQSGVGeschwKlasse.getValue(i).isState()) {
		                        getQSGVGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQSGVGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQSGVGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQSGVGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQBPAGeschwKlasse = daten.
							getUnscaledArray
						("qBPAGeschwKlasse");
		
						for (int i = 0; i < arrayQBPAGeschwKlasse.getLength(); ++i) {
		                    if (arrayQBPAGeschwKlasse.getValue(i).isState()) {
		                        getQBPAGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQBPAGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQBPAGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQBPAGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon.setQKfzNk(getQKfzNk());
							klon.setQKrad(getQKrad());
							klon.setQPkw(getQPkw());
							klon.setQLfw(getQLfw());
							klon.setQPkwA(getQPkwA());
							klon.setQLkw(getQLkw());
							klon.setQLkwA(getQLkwA());
							klon.setQSattelKfz(getQSattelKfz());
							klon.setQBus(getQBus());
							klon.setVLVo(getVLVo());
							klon.setVSGV(getVSGV());
							klon.setVBPA(getVBPA());
							klon.setSLVo(getSLVo());
							klon.setSSGV(getSSGV());
							klon.setSBPA(getSBPA());
							klon.setV85LVo(getV85LVo());
							klon.setV85SGV(getV85SGV());
							klon.setV85BPA(getV85BPA());
							klon.setV15LVo(getV15LVo());
							klon.setV15SGV(getV15SGV());
							klon.setV15BPA(getV15BPA());
						klon._qLVoGeschwKlasse = getQLVoGeschwKlasse().clone();
						klon._qSGVGeschwKlasse = getQSGVGeschwKlasse().clone();
						klon._qBPAGeschwKlasse = getQBPAGeschwKlasse().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsLveErgebnisMeldungVersion24";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsLveErgebnisMeldungVersion24(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
