/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Abruf einer Datei (FG 254 &#47; Typ 40).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 254: DE-Block-Struktur im Typ 40 "Abruf einer Datei"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet auf dem Lokal-, Insel- und KRI-Bus mit ID 3 (Parameter) in Abrufrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mit dieser Nachricht kann die Zentrale größere
							gekapselte Datenobjekte, z.B. Dateien oder dateiähnliche
							Datenströme, welche für einen evtl. Download freigegeben sind,
							von dem SM bzw. den EAKs herunterladen. Sollte das
							Datenobjekt nicht vorhanden sein, wird mit einer
							negativen Quittung (Code=21) geantwortet, anderenfalls
							wird mit DE-Block Typ 41 die Datei zur Zentrale übertragen.
							Das Datenobjekt wird durch einen eindeutigen Bezeichner
							gekennzeichnet. Ein Bezeichner kann bei Dateien z.B.
							ein Dateiname einschließlich einer Pfadangabe sein.
							Bezeichner und Datenobjekt bilden zusammen ein
							Schlüssel-Wert-Paar. Ein Abruf mit DE-Adresse = 255
							ist nicht zugelassen!
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Der Transfer gekapselter Daten mittels der DE-Block-Strukturen
							40 und 41 ist nur dann zulässig, wenn keine explizite
							DE-Block-Struktur für diese Art von Daten festgelegt wurde.
							Ein mögliches Anwendungsfeld sind binäre Bilddaten für
							frei programmierbare Wechselverkehrszeichen oder Wechselwegweiser.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- mehrere gleichzeitige Abrufe auf ein EAK bzw. SM sind nicht zulässig,
							ein erneuter Abruf ist erst nach vollständigen Dateitransfer wieder möglich
							(evtl. laufenden Dateitransfer mit Länge des Bezeichners = 0 abbrechen)
							- Dateien, welche im Moment des Abrufes von einem anderen Prozess
							benutzt&#47;bearbeitet werden, führen zu einer negativen Quittung (Code=22)
							- alle DE-Blöcke des folgenden Dateitransfers werden mit der abfragenden
							Jobnummer beantwortet
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class OdTlsSysDateiAbruf extends AbstractOnlineDatensatz<OdTlsSysDateiAbruf.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAbruf,
				};
			}
	
			/**
			 * Aspekt zum Abruf von TLS-Daten eines DE-Blocks.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAbruf = new Aspekte("TlsAbruf", "asp.tlsAbruf");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
				 _laengeBezeichner
				;
				private String
				 _bezeichner
				= new String
				()
				;
		
			/**
			Länge des folgenden Bezeichners (z.B. Dateiname).
			<p>
			
			</p>
			
			@return der Wert von LaengeBezeichner.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
				 getLaengeBezeichner() {
				return _laengeBezeichner;
			}
		
			/**
			Länge des folgenden Bezeichners (z.B. Dateiname).
			<p>
			
			</p>
			
			@param _laengeBezeichner der neue Wert von LaengeBezeichner.
			*/
			public void setLaengeBezeichner(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
			 _laengeBezeichner) {
				this._laengeBezeichner = _laengeBezeichner;
			}
		
			/**
			Eindeutige Bezeichnung des zu übertragenden Datenobjekts.
			<p>
			Die Syntax der Bezeichner für die Datenobjekte werden vom Hersteller
									des Ausgabegerätes bzw. Hersteller des EAK projekt- bzw. gerätespezifisch festlegt.
			</p>
			
			@return der Wert von Bezeichner.
			*/
				public String
				 getBezeichner() {
				return _bezeichner;
			}
		
			/**
			Eindeutige Bezeichnung des zu übertragenden Datenobjekts.
			<p>
			Die Syntax der Bezeichner für die Datenobjekte werden vom Hersteller
									des Ausgabegerätes bzw. Hersteller des EAK projekt- bzw. gerätespezifisch festlegt.
			</p>
			
			@param _bezeichner der neue Wert von Bezeichner.
			*/
			public void setBezeichner(String
			 _bezeichner) {
				if (_bezeichner.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bezeichner = _bezeichner;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getLaengeBezeichner() != null) {
		                if (getLaengeBezeichner().isZustand()) {
		                    datum.getUnscaledValue("LängeBezeichner").setText(getLaengeBezeichner().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LängeBezeichner").set(getLaengeBezeichner().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getBezeichner() != null) {
						datum.getTextValue("Bezeichner").setText(getBezeichner());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LängeBezeichner").isState()) {
								setLaengeBezeichner(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
								.getZustand(daten.getScaledValue("LängeBezeichner").getText()));
							} else {
							setLaengeBezeichner(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
							(daten.
								getUnscaledValue
							("LängeBezeichner").
									shortValue
							()));
							}
					// ZeichenkettenAttributTyp
						setBezeichner(daten.getTextValue("Bezeichner").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setLaengeBezeichner(getLaengeBezeichner());
							klon.setBezeichner(getBezeichner());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsSysDateiAbruf";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsSysDateiAbruf(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
