/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
FG 3: ErgebnisMeldung Temperatur in Tiefe 2 TT2 (FG
					3 &#47; Typ 68).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							TLS-DE-Block-Struktur im Typ
							68"ErgebnisMeldung Temperatur in Tiefe 2
							TT2"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 19
 */
public class OdTlsUfdErgebnisMeldungTemperaturInTiefe2TT2 extends AbstractOnlineDatensatz<OdTlsUfdErgebnisMeldungTemperaturInTiefe2TT2.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdBodentemperatur
				 _bodentemperaturInTiefe2
				;
		
			/**
			Bodentemperatur.
			<p>
			Temperatur gemessen in der Tiefe 1, 2 oder 3 unter
								der Fahrbahn. Ist eine Fahrbahnsonde in die
								Oberfläche eingelassen, so befindet sich die
								Messstelle direkt unter der Fahrbahnsonde in der
								betreffenden Tiefe Es wird der IST-Wert übertragen.
			</p>
			
			@return der Wert von BodentemperaturInTiefe2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdBodentemperatur
				 getBodentemperaturInTiefe2() {
				return _bodentemperaturInTiefe2;
			}
		
			/**
			Bodentemperatur.
			<p>
			Temperatur gemessen in der Tiefe 1, 2 oder 3 unter
								der Fahrbahn. Ist eine Fahrbahnsonde in die
								Oberfläche eingelassen, so befindet sich die
								Messstelle direkt unter der Fahrbahnsonde in der
								betreffenden Tiefe Es wird der IST-Wert übertragen.
			</p>
			
			@param _bodentemperaturInTiefe2 der neue Wert von BodentemperaturInTiefe2.
			*/
			public void setBodentemperaturInTiefe2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdBodentemperatur
			 _bodentemperaturInTiefe2) {
				this._bodentemperaturInTiefe2 = _bodentemperaturInTiefe2;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getBodentemperaturInTiefe2() != null) {
		                if (getBodentemperaturInTiefe2().isZustand()) {
		                    datum.getUnscaledValue("BodentemperaturInTiefe2").setText(getBodentemperaturInTiefe2().toString());
		                } else {
							datum.
							getScaledValue
		                	("BodentemperaturInTiefe2").set(getBodentemperaturInTiefe2().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BodentemperaturInTiefe2").isState()) {
								setBodentemperaturInTiefe2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdBodentemperatur
								.getZustand(daten.getScaledValue("BodentemperaturInTiefe2").getText()));
							} else {
							setBodentemperaturInTiefe2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdBodentemperatur
							(daten.
								getScaledValue
							("BodentemperaturInTiefe2").
								doubleValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setBodentemperaturInTiefe2(getBodentemperaturInTiefe2());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsUfdErgebnisMeldungTemperaturInTiefe2TT2";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsUfdErgebnisMeldungTemperaturInTiefe2TT2(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
