/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fernüberwachung von Solaranlagen (FG 6 &#47; Typ 56).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 6: DE-Block-Struktur im Typ
							56"Fernüberwachung von Solaranlagen"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) in
							Antwortrichtung. Lässt sich die Ladespannung
							oder der Ladestrom nicht ermitteln, wird das
							betroffene Byte auf 255 gesetzt.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Eine spontane Übertragung erfolgt nur nach
							Änderung der Zustände Überladeschutz,
							Tiefenladeschutz. In diesen Fällen wird der
							aktuelle Wert der Ladespannung und des
							Ladestromes übertragen.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsVltFernUeberwachungSolarAnlagen extends AbstractOnlineDatensatz<OdTlsVltFernUeberwachungSolarAnlagen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarUeberladeSchutz
				 _solarUeberladeSchutz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarTiefentladeSchutz
				 _solarTiefentladeSchutz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeSpannung
				 _solarLadeSpannung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeStrom
				 _solarLadeStrom
				;
		
			/**
			Überladeschutz bei Solaranlagen.
			<p>
			
			</p>
			
			@return der Wert von SolarUeberladeSchutz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarUeberladeSchutz
				 getSolarUeberladeSchutz() {
				return _solarUeberladeSchutz;
			}
		
			/**
			Überladeschutz bei Solaranlagen.
			<p>
			
			</p>
			
			@param _solarUeberladeSchutz der neue Wert von SolarUeberladeSchutz.
			*/
			public void setSolarUeberladeSchutz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarUeberladeSchutz
			 _solarUeberladeSchutz) {
				this._solarUeberladeSchutz = _solarUeberladeSchutz;
			}
		
			/**
			Tiefentladeschutz bei Solaranlagen.
			<p>
			
			</p>
			
			@return der Wert von SolarTiefentladeSchutz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarTiefentladeSchutz
				 getSolarTiefentladeSchutz() {
				return _solarTiefentladeSchutz;
			}
		
			/**
			Tiefentladeschutz bei Solaranlagen.
			<p>
			
			</p>
			
			@param _solarTiefentladeSchutz der neue Wert von SolarTiefentladeSchutz.
			*/
			public void setSolarTiefentladeSchutz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarTiefentladeSchutz
			 _solarTiefentladeSchutz) {
				this._solarTiefentladeSchutz = _solarTiefentladeSchutz;
			}
		
			/**
			Ladespannung der Solaranlage.
			<p>
			
			</p>
			
			@return der Wert von SolarLadeSpannung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeSpannung
				 getSolarLadeSpannung() {
				return _solarLadeSpannung;
			}
		
			/**
			Ladespannung der Solaranlage.
			<p>
			
			</p>
			
			@param _solarLadeSpannung der neue Wert von SolarLadeSpannung.
			*/
			public void setSolarLadeSpannung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeSpannung
			 _solarLadeSpannung) {
				this._solarLadeSpannung = _solarLadeSpannung;
			}
		
			/**
			Ladestrom der Solaranlage.
			<p>
			
			</p>
			
			@return der Wert von SolarLadeStrom.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeStrom
				 getSolarLadeStrom() {
				return _solarLadeStrom;
			}
		
			/**
			Ladestrom der Solaranlage.
			<p>
			
			</p>
			
			@param _solarLadeStrom der neue Wert von SolarLadeStrom.
			*/
			public void setSolarLadeStrom(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeStrom
			 _solarLadeStrom) {
				this._solarLadeStrom = _solarLadeStrom;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getSolarUeberladeSchutz() != null) {
		                if (getSolarUeberladeSchutz().isZustand()) {
		                    datum.getUnscaledValue("SolarÜberladeSchutz").setText(getSolarUeberladeSchutz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SolarÜberladeSchutz").set(getSolarUeberladeSchutz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSolarTiefentladeSchutz() != null) {
		                if (getSolarTiefentladeSchutz().isZustand()) {
		                    datum.getUnscaledValue("SolarTiefentladeSchutz").setText(getSolarTiefentladeSchutz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SolarTiefentladeSchutz").set(getSolarTiefentladeSchutz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSolarLadeSpannung() != null) {
		                if (getSolarLadeSpannung().isZustand()) {
		                    datum.getUnscaledValue("SolarLadeSpannung").setText(getSolarLadeSpannung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SolarLadeSpannung").set(getSolarLadeSpannung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSolarLadeStrom() != null) {
		                if (getSolarLadeStrom().isZustand()) {
		                    datum.getUnscaledValue("SolarLadeStrom").setText(getSolarLadeStrom().toString());
		                } else {
							datum.
							getScaledValue
		                	("SolarLadeStrom").set(getSolarLadeStrom().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SolarÜberladeSchutz").isState()) {
								setSolarUeberladeSchutz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarUeberladeSchutz
								.getZustand(daten.getScaledValue("SolarÜberladeSchutz").getText()));
							} else {
							setSolarUeberladeSchutz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarUeberladeSchutz
							(daten.
								getUnscaledValue
							("SolarÜberladeSchutz").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SolarTiefentladeSchutz").isState()) {
								setSolarTiefentladeSchutz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarTiefentladeSchutz
								.getZustand(daten.getScaledValue("SolarTiefentladeSchutz").getText()));
							} else {
							setSolarTiefentladeSchutz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarTiefentladeSchutz
							(daten.
								getUnscaledValue
							("SolarTiefentladeSchutz").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SolarLadeSpannung").isState()) {
								setSolarLadeSpannung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeSpannung
								.getZustand(daten.getScaledValue("SolarLadeSpannung").getText()));
							} else {
							setSolarLadeSpannung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeSpannung
							(daten.
								getUnscaledValue
							("SolarLadeSpannung").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SolarLadeStrom").isState()) {
								setSolarLadeStrom(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeStrom
								.getZustand(daten.getScaledValue("SolarLadeStrom").getText()));
							} else {
							setSolarLadeStrom(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltSolarLadeStrom
							(daten.
								getScaledValue
							("SolarLadeStrom").
								doubleValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setSolarUeberladeSchutz(getSolarUeberladeSchutz());
							klon.setSolarTiefentladeSchutz(getSolarTiefentladeSchutz());
							klon.setSolarLadeSpannung(getSolarLadeSpannung());
							klon.setSolarLadeStrom(getSolarLadeStrom());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsVltFernÜberwachungSolarAnlagen";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsVltFernUeberwachungSolarAnlagen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
