/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Stromversorung (FG 6 &#47; Typ 51).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 6: TLS-DE-Block-Struktur im Typ
							51"Stromversorung"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsVltStromVersorung extends AbstractOnlineDatensatz<OdTlsVltStromVersorung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltNetzspannung
				 _netzspannung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltUSV
				 _uSV
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuentladung
				 _akkuentladung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuueberladung
				 _akkuueberladung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltFISchutzschalter
				 _fISchutzschalter
				;
		
			/**
			Status Stromversorgung.
			<p>
			
			</p>
			
			@return der Wert von Netzspannung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltNetzspannung
				 getNetzspannung() {
				return _netzspannung;
			}
		
			/**
			Status Stromversorgung.
			<p>
			
			</p>
			
			@param _netzspannung der neue Wert von Netzspannung.
			*/
			public void setNetzspannung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltNetzspannung
			 _netzspannung) {
				this._netzspannung = _netzspannung;
			}
		
			/**
			Status Unterberechungsfreie Stromversorgung.
			<p>
			
			</p>
			
			@return der Wert von USV.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltUSV
				 getUSV() {
				return _uSV;
			}
		
			/**
			Status Unterberechungsfreie Stromversorgung.
			<p>
			
			</p>
			
			@param _uSV der neue Wert von USV.
			*/
			public void setUSV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltUSV
			 _uSV) {
				this._uSV = _uSV;
			}
		
			/**
			Status Akkuentladung.
			<p>
			
			</p>
			
			@return der Wert von Akkuentladung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuentladung
				 getAkkuentladung() {
				return _akkuentladung;
			}
		
			/**
			Status Akkuentladung.
			<p>
			
			</p>
			
			@param _akkuentladung der neue Wert von Akkuentladung.
			*/
			public void setAkkuentladung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuentladung
			 _akkuentladung) {
				this._akkuentladung = _akkuentladung;
			}
		
			/**
			Status Akkuüberladung.
			<p>
			
			</p>
			
			@return der Wert von Akkuueberladung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuueberladung
				 getAkkuueberladung() {
				return _akkuueberladung;
			}
		
			/**
			Status Akkuüberladung.
			<p>
			
			</p>
			
			@param _akkuueberladung der neue Wert von Akkuueberladung.
			*/
			public void setAkkuueberladung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuueberladung
			 _akkuueberladung) {
				this._akkuueberladung = _akkuueberladung;
			}
		
			/**
			Status FI-Schutzschalter.
			<p>
			
			</p>
			
			@return der Wert von FISchutzschalter.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltFISchutzschalter
				 getFISchutzschalter() {
				return _fISchutzschalter;
			}
		
			/**
			Status FI-Schutzschalter.
			<p>
			
			</p>
			
			@param _fISchutzschalter der neue Wert von FISchutzschalter.
			*/
			public void setFISchutzschalter(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltFISchutzschalter
			 _fISchutzschalter) {
				this._fISchutzschalter = _fISchutzschalter;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getNetzspannung() != null) {
		                if (getNetzspannung().isZustand()) {
		                    datum.getUnscaledValue("Netzspannung").setText(getNetzspannung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Netzspannung").set(getNetzspannung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getUSV() != null) {
		                if (getUSV().isZustand()) {
		                    datum.getUnscaledValue("USV").setText(getUSV().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("USV").set(getUSV().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAkkuentladung() != null) {
		                if (getAkkuentladung().isZustand()) {
		                    datum.getUnscaledValue("Akkuentladung").setText(getAkkuentladung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Akkuentladung").set(getAkkuentladung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAkkuueberladung() != null) {
		                if (getAkkuueberladung().isZustand()) {
		                    datum.getUnscaledValue("Akkuüberladung").setText(getAkkuueberladung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Akkuüberladung").set(getAkkuueberladung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFISchutzschalter() != null) {
		                if (getFISchutzschalter().isZustand()) {
		                    datum.getUnscaledValue("FISchutzschalter").setText(getFISchutzschalter().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FISchutzschalter").set(getFISchutzschalter().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Netzspannung").isState()) {
								setNetzspannung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltNetzspannung
								.getZustand(daten.getScaledValue("Netzspannung").getText()));
							} else {
							setNetzspannung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltNetzspannung
							(daten.
								getUnscaledValue
							("Netzspannung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("USV").isState()) {
								setUSV(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltUSV
								.getZustand(daten.getScaledValue("USV").getText()));
							} else {
							setUSV(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltUSV
							(daten.
								getUnscaledValue
							("USV").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Akkuentladung").isState()) {
								setAkkuentladung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuentladung
								.getZustand(daten.getScaledValue("Akkuentladung").getText()));
							} else {
							setAkkuentladung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuentladung
							(daten.
								getUnscaledValue
							("Akkuentladung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Akkuüberladung").isState()) {
								setAkkuueberladung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuueberladung
								.getZustand(daten.getScaledValue("Akkuüberladung").getText()));
							} else {
							setAkkuueberladung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltAkkuueberladung
							(daten.
								getUnscaledValue
							("Akkuüberladung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FISchutzschalter").isState()) {
								setFISchutzschalter(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltFISchutzschalter
								.getZustand(daten.getScaledValue("FISchutzschalter").getText()));
							} else {
							setFISchutzschalter(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltFISchutzschalter
							(daten.
								getUnscaledValue
							("FISchutzschalter").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setNetzspannung(getNetzspannung());
							klon.setUSV(getUSV());
							klon.setAkkuentladung(getAkkuentladung());
							klon.setAkkuueberladung(getAkkuueberladung());
							klon.setFISchutzschalter(getFISchutzschalter());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsVltStromVersorung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsVltStromVersorung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
