/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Abruf Bilddefinition (FG 4 &#47; Typ 22).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ 22 "Abruf Bilddefinition&#47;Grafiktextkonserve"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Diese DE-Block-Struktur ist optional und wird verwendet
							mit ID 3 (Parameter) in Abrufrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mit dieser Nachricht kann die Zentrale die BMP-Grafikdateien
							(s&#47;w bzw. c-24 Format) der vor Ort abgelegten Bilddefinitionen
							(Anzeigeprinzip b, frei Programmierbare LED-Pixel-Anzeigen),
							Upload-fähige LED-Pixelrasteranzeigen) bzw. die
							Grafiktextkonserven (Anzeigeprinzip d, Wechseltextanzeigen
							mit Grafiktextkonserven) abfragen. DEs, welche diesen Typ
							nicht unterstützten, antworten mit einer negativen Quittung
							Code 2 "unbekannter oder nicht auswertbarer Typ".
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Wenn ein nicht definierter Stellcode bzw. Grafiktextkonservennummer
							abgefragt wird, antwortet das DE mit einer negativen Quittung Code 22
							"unbekannter Stellcode&#47;Grafiktextkonservennummer". Ansonsten
							antwortet das DE mit einem DE-Block Typ 45.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Weitere Einzelheiten bzgl. Bilddefinition&#47;Grafiktextkonserve
							&lt;verweis pid="atg.tlsWzgBildDefinition"&gt;&lt;&#47;verweis&gt;.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class OdTlsWzgAbrufBildDefinition extends AbstractOnlineDatensatz<OdTlsWzgAbrufBildDefinition.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAbruf,
				};
			}
	
			/**
			 * Aspekt zum Abruf von TLS-Daten eines DE-Blocks.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAbruf = new Aspekte("TlsAbruf", "asp.tlsAbruf");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeGrafikTextKonservenNummer
				 _stellCodeGrafikTextKonservenNummer
				;
		
			/**
			Enthält den Stellcode, der einer Bilddefinition zugewiesen wird
									(Anzeigeprinzip b, frei Programmierbare LED-Pixel-Anzeigen) bzw.
									die Grafiktextkonservennummer welche einer Grafiktextkonserve
									zugewiesen wird (Anzeige­prinzip d,
									Wechseltextanzeigen mit Grafiktextkonserven).
			<p>
			
			</p>
			
			@return der Wert von StellCodeGrafikTextKonservenNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeGrafikTextKonservenNummer
				 getStellCodeGrafikTextKonservenNummer() {
				return _stellCodeGrafikTextKonservenNummer;
			}
		
			/**
			Enthält den Stellcode, der einer Bilddefinition zugewiesen wird
									(Anzeigeprinzip b, frei Programmierbare LED-Pixel-Anzeigen) bzw.
									die Grafiktextkonservennummer welche einer Grafiktextkonserve
									zugewiesen wird (Anzeige­prinzip d,
									Wechseltextanzeigen mit Grafiktextkonserven).
			<p>
			
			</p>
			
			@param _stellCodeGrafikTextKonservenNummer der neue Wert von StellCodeGrafikTextKonservenNummer.
			*/
			public void setStellCodeGrafikTextKonservenNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeGrafikTextKonservenNummer
			 _stellCodeGrafikTextKonservenNummer) {
				this._stellCodeGrafikTextKonservenNummer = _stellCodeGrafikTextKonservenNummer;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getStellCodeGrafikTextKonservenNummer() != null) {
		                if (getStellCodeGrafikTextKonservenNummer().isZustand()) {
		                    datum.getUnscaledValue("StellCodeGrafikTextKonservenNummer").setText(getStellCodeGrafikTextKonservenNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StellCodeGrafikTextKonservenNummer").set(getStellCodeGrafikTextKonservenNummer().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setStellCodeGrafikTextKonservenNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeGrafikTextKonservenNummer
							(daten.
								getUnscaledValue
							("StellCodeGrafikTextKonservenNummer").
									shortValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStellCodeGrafikTextKonservenNummer(getStellCodeGrafikTextKonservenNummer());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgAbrufBildDefinition";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgAbrufBildDefinition(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
