/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Abruf Codedefinitionen (FG 4 &#47; Typ 21).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ 21"Abruf
							Codedefinition"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 3 (Parameter) in
							Abrufrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mit dieser Nachricht kann die Zentrale die
							Definitionen der vor Ort abgelegten
							Stellcodes für die Gruppen- Stellzustände
							(Anzeigeprinzip e), Wechseltextanzeigen
							(Anzeigeprinzip c und d) oder Programme
							(Cluster) anfordern. Für Wzg nach
							Anzeigeprinzip b) kann optional die Liste
							der an der Darstellung eines WVZ-Codes
							beteiligten Lampen abgefragt werden. Ist
							diese Eigenschaft nicht implementiert,
							antwortet das DE mit der negativen Quittung
							Code 2 ?unbekannter oder nicht auswertbarer
							Typ?.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Arbeitet ein DE oder ein Cluster nach
							Steuerprinzip 1), so beantwortet er die
							Anfrage mit einer negativen Quittung, Code
							4. Das gleiche gilt bei Steuerungsprinzip 2
							und 3, wenn die Definition eines nicht
							definierten Stellcodes abgefragt wird.
							Ansonsten antwortet das DE mit einem
							DE-Block Typ 44.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsWzgAbrufCodeDefinitionen extends AbstractOnlineDatensatz<OdTlsWzgAbrufCodeDefinitionen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAbruf,
				};
			}
	
			/**
			 * Aspekt zum Abruf von TLS-Daten eines DE-Blocks.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAbruf = new Aspekte("TlsAbruf", "asp.tlsAbruf");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
				 _stellCode
				;
		
			/**
			Ist-Zustand des Stellcodes.
			<p>
			
			</p>
			
			@return der Wert von StellCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
				 getStellCode() {
				return _stellCode;
			}
		
			/**
			Ist-Zustand des Stellcodes.
			<p>
			
			</p>
			
			@param _stellCode der neue Wert von StellCode.
			*/
			public void setStellCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
			 _stellCode) {
				this._stellCode = _stellCode;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getStellCode() != null) {
		                if (getStellCode().isZustand()) {
		                    datum.getUnscaledValue("StellCode").setText(getStellCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StellCode").set(getStellCode().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setStellCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
							(daten.
								getUnscaledValue
							("StellCode").
									shortValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStellCode(getStellCode());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgAbrufCodeDefinitionen";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgAbrufCodeDefinitionen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
