/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Bilddefinition (FG 4 &#47; Typ 45).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ 45 "Bilddefinition&#47;Grafiktextkonserve"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Diese DE-Block-Struktur ist optional und wird verwendet
							mit ID 3 (Parameter) in Abruf- und Antwortrichtung oder
							mit ID 35 (Parameter aus Puffer) in Antwortrichtung.
							Die Nachricht wird abweichend von anderen Parameternachrichten
							zusammen mit dem Zeitstempel Typ 31 gesendet. Als
							Abruftelegramm mit ID 19 ist das Telegramm nicht zulässig
							und wird mit Code 1 "unbekannte oder nicht auswertbare ID"
							negativ quittiert, da der zu erfragende Stellcode bzw.
							Grafiktextkonservennummer nicht übermittelt werden kann.
							Die Abfragefunktionalität wird durch den DE-Block Typ 22
							zur Verfügung gestellt.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Bilddefinitionen bzw. Grafiktextkonserven werden in Form
							von BMP-Grafikdateien (s&#47;w bzw. c-24 Format) unter
							Zuhilfenahme der FG254, DE-Block Typ 40&#47;41 an den FG4-EAK
							gesendet und dort als Datei oder dateiähnliches gekapseltes
							Objekt zur Verfügung gestellt. Für farbige Anzeigen muss
							die BMP-Grafikdatei im c-24 Format (24 Bit Farbtiefe &#47; Pixel)
							hinterlegt sein. Für einfarbige Anzeigen muss die
							BMP-Grafikdatei im s&#47;w Format hinterlegt sein. Andere
							Unterformate sind nicht zulässig.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Der Dateiname der BMP-Grafikdatei muss im 8.3 Format angegeben
							werden (8 Zeichen für den Dateinamen und 3 Zeichen für die Extension "BMP").
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mithilfe der DE-Block-Struktur im Typ 45 wird eine Verbindung
							zwischen Bilddefinition und Stellcode (Anzeigeprinzip b,
							upload-fähige LED-PixelrasterAnzeigen) bzw. Grafiktextkonserve
							und Grafik­text­konserven­nummer (Anzeigeprinzip d,
							Wechseltextanzeigen mit Grafiktextkonserven) hergestellt.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Sollte die in der Zuweisung aufgeführte Bilddefinition bzw.
							Grafiktextkonserve (BMP- Grafikdatei) nicht vorhanden sein,
							wird eine negative Quittung Code 23
							"unbekannte Bilddefinition&#47;Grafiktextkonserve" gesendet.
							Anderenfalls wird die Bilddefinition bzw. Grafiktextkonserve
							in das interne Format de DEs gewandelt, inhaltlich geprüft
							und bei Korrektheit mit der DE-Block-Struktur im Typ 45 positiv
							quittiert. Es ist hierbei zulässig, dass vom Gerät definierter
							neuer Bezeichner zurückgemeldet wird. Sollte ein Fehler bei der
							Prüfung bzw. Umwandlung der Bilddefinition bzw. Grafiktextkonserve
							auftreten, wird eine negative Quittung Code 24
							"fehlerhafte Bilddefinition&#47;Grafiktextkonserve" gesendet.
						&lt;&#47;absatz&gt;

						&lt;absatz&gt;
							Nach erfolgreicher Prüfung bzw. Umwandlung der Bilddefinition bzw.
							Grafiktextkonserve in das interne Format, muss die Original BMP-Grafikdatei
							gelöscht werden. Eine Zuweisung dieser Bilddefinition bzw.
							Grafiktextkonserve auf andere DEs (des gleichen Typs ?)
							im gleichen FG4-EAK muss aber weiterhin möglich sein, ohne erneutes
							Senden der BMP-Grafikdatei an die FG254 des FG4-EAKs. Auch ein evtl.
							Abruf mit DE-Block Typ 22, muss mit dem korrekten Namen der
							Original BMP- Grafikdatei beantwortet werden. Sollte im späteren Verlauf
							eine bereits verwendete BMP-Grafikdatei (gleicher Name), erneut an den
							FG4-EAK gesendet werden und anschließend eine Zuweisung erfolgen,
							ist diese nur zu akzeptieren, wenn im DE, bzw. in den anderen DEs
							des FG4-EAKs, kein anderer Stellcode bzw. Grafiktextkonservennummer
							die "alte" Bilddefinition bzw. Grafiktextkonserve noch verwendet.
							Sollte dies doch der Fall sein, so ist die erneute Zuweisung mit einer
							negativen Quittung Code 25
							"bereits verwendete Bilddefinition&#47;Grafiktextkonserve" zu beantworten.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Das Überschreiben bzw. Löschen einer vorhandenen Bilddefinition bzw.
							Grafiktextkonserve ist erlaubt, hierbei ist jedoch darauf zu achten,
							das die betroffene Bilddefinition bzw. Grafiktextkonserve nicht aktuell
							in Verwendung ist, sollte dies der Fall sein, wird eine negative
							Quittung Code 42 "Stellcode-Definition nicht änderbar" gesendet.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Anzeigeprinzip b:
							Bei der Verwendung von upload-fähigen "frei programmierbaren"
							LED-Pixelrasteranzeigen (Mono&#47;Color), werden die Zeicheninhalte in ein
							eigenes Format, zur internen Weiterverarbeitung, umgewandelt
							(z.B. Anpassung der Farbtiefe, ?). Jede Bilddefinition entspricht
							einem Stellcode, welcher wiederum einer BMP-Grafikdatei zugeordnet
							ist. Es ist bei gleicher Auflösung und Farbtiefe zulässig, das eine
							Bilddefinition mehreren DEs (WVZs) zugewiesen werden. Die
							BMP-Grafikdatei muss in ihrer Auflösung (x, y), der Auflösung des
							physikalischen Displays entsprechen.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Anzeigeprinzip d:
							Bei der Verwendung von LED-Pixel-Wechseltextanzeigen mit
							Grafiktextkonserven (Mono), werden die Grafiktextkonserven
							(z. B. Autobahnnummer, Stadium, Fußball, Flugzeug, ?) in ein eigenes
							Format, zur internen Weiterverarbeitung, umgewandelt. Jede
							Grafiktextkonserve bekommt eine Grafiktextkonservennummer von 1..254
							und kann beliebig in einen Text eingebaut werden
							(siehe Anhang 7, Kapitel 3). Eine Grafiktextkonservennummer entspricht
							damit nicht einem Stellcode und kann auch nicht im Steuerungsprinzip 2
							als Stellcode verwendet werden. Es ist bei gleicher Auflösung zulässig,
							dass eine Grafiktextkonserve mehreren DEs (Wechseltextanzeigen) zugewiesen
							werden. Die BMP-Grafikdatei muss in ihrer Auflösung (x, y), kleiner bzw.
							gleich der Auflösung der physikalischen Wechseltextanzeige entsprechen.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class OdTlsWzgBildDefinition extends AbstractOnlineDatensatz<OdTlsWzgBildDefinition.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsVorgabe,
					Aspekte.TlsZustand,
				};
			}
	
			/**
			 * Aspekt für Vorgaben (Daten zum Senden an eine SS),
						die nicht wie die Parametersätze automatisch
						verschickt werden (z.B. goegrafische Kenndaten,
						Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabe = new Aspekte("TlsVorgabe", "asp.tlsVorgabe");
			
			/**
			 * Aspekt für den aktuellen Zustand , die i.d.R.
						ausfallsicher im SM oder EAK abgelegt werden (z.B.
						goegrafische Kenndaten, Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsZustand = new Aspekte("TlsZustand", "asp.tlsZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeGrafikTextKonservenNummer
				 _stellCodeGrafikTextKonservenNummer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLaengeGrafikObjektName
				 _laengeGrafikObjektName
				;
				private String
				 _grafikObjektName
				= new String
				()
				;
		
			/**
			Enthält den Stellcode, der einer Bilddefinition zugewiesen wird
									(Anzeigeprinzip b, frei Programmierbare LED-Pixel-Anzeigen) bzw.
									die Grafiktextkonservennummer welche einer Grafiktextkonserve
									zugewiesen wird (Anzeige­prinzip d,
									Wechseltextanzeigen mit Grafiktextkonserven).
			<p>
			
			</p>
			
			@return der Wert von StellCodeGrafikTextKonservenNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeGrafikTextKonservenNummer
				 getStellCodeGrafikTextKonservenNummer() {
				return _stellCodeGrafikTextKonservenNummer;
			}
		
			/**
			Enthält den Stellcode, der einer Bilddefinition zugewiesen wird
									(Anzeigeprinzip b, frei Programmierbare LED-Pixel-Anzeigen) bzw.
									die Grafiktextkonservennummer welche einer Grafiktextkonserve
									zugewiesen wird (Anzeige­prinzip d,
									Wechseltextanzeigen mit Grafiktextkonserven).
			<p>
			
			</p>
			
			@param _stellCodeGrafikTextKonservenNummer der neue Wert von StellCodeGrafikTextKonservenNummer.
			*/
			public void setStellCodeGrafikTextKonservenNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeGrafikTextKonservenNummer
			 _stellCodeGrafikTextKonservenNummer) {
				this._stellCodeGrafikTextKonservenNummer = _stellCodeGrafikTextKonservenNummer;
			}
		
			/**
			Länge des Grafikobjektnamens.
			<p>
			Länge des folgenden Dateinamens bzw. des dateiähnliche
									Datenstroms der BMP-Grafikdatei. Mit der Länge = 0 wird
									der Stellcode bzw. die Grafiktextkonservennummer gelöscht.
			</p>
			
			@return der Wert von LaengeGrafikObjektName.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLaengeGrafikObjektName
				 getLaengeGrafikObjektName() {
				return _laengeGrafikObjektName;
			}
		
			/**
			Länge des Grafikobjektnamens.
			<p>
			Länge des folgenden Dateinamens bzw. des dateiähnliche
									Datenstroms der BMP-Grafikdatei. Mit der Länge = 0 wird
									der Stellcode bzw. die Grafiktextkonservennummer gelöscht.
			</p>
			
			@param _laengeGrafikObjektName der neue Wert von LaengeGrafikObjektName.
			*/
			public void setLaengeGrafikObjektName(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLaengeGrafikObjektName
			 _laengeGrafikObjektName) {
				this._laengeGrafikObjektName = _laengeGrafikObjektName;
			}
		
			/**
			Name des BMP-Grafik­daten­objektes + evtl. Speicherort.
			<p>
			Eindeutige Bezeichnung des BMP-Grafik­daten­objektes,
									z. B. als Dateiname mit Pfadangabe.
									Die Syntax der Bezeichner für die Datenobjekte werden vom Hersteller
									des Ausgabegerätes bzw. Hersteller des EAK projekt- bzw. gerätespezifisch festlegt.
			</p>
			
			@return der Wert von GrafikObjektName.
			*/
				public String
				 getGrafikObjektName() {
				return _grafikObjektName;
			}
		
			/**
			Name des BMP-Grafik­daten­objektes + evtl. Speicherort.
			<p>
			Eindeutige Bezeichnung des BMP-Grafik­daten­objektes,
									z. B. als Dateiname mit Pfadangabe.
									Die Syntax der Bezeichner für die Datenobjekte werden vom Hersteller
									des Ausgabegerätes bzw. Hersteller des EAK projekt- bzw. gerätespezifisch festlegt.
			</p>
			
			@param _grafikObjektName der neue Wert von GrafikObjektName.
			*/
			public void setGrafikObjektName(String
			 _grafikObjektName) {
				if (_grafikObjektName.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._grafikObjektName = _grafikObjektName;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getStellCodeGrafikTextKonservenNummer() != null) {
		                if (getStellCodeGrafikTextKonservenNummer().isZustand()) {
		                    datum.getUnscaledValue("StellCodeGrafikTextKonservenNummer").setText(getStellCodeGrafikTextKonservenNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StellCodeGrafikTextKonservenNummer").set(getStellCodeGrafikTextKonservenNummer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLaengeGrafikObjektName() != null) {
		                if (getLaengeGrafikObjektName().isZustand()) {
		                    datum.getUnscaledValue("LängeGrafikObjektName").setText(getLaengeGrafikObjektName().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LängeGrafikObjektName").set(getLaengeGrafikObjektName().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getGrafikObjektName() != null) {
						datum.getTextValue("GrafikObjektName").setText(getGrafikObjektName());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setStellCodeGrafikTextKonservenNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeGrafikTextKonservenNummer
							(daten.
								getUnscaledValue
							("StellCodeGrafikTextKonservenNummer").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LängeGrafikObjektName").isState()) {
								setLaengeGrafikObjektName(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLaengeGrafikObjektName
								.getZustand(daten.getScaledValue("LängeGrafikObjektName").getText()));
							} else {
							setLaengeGrafikObjektName(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLaengeGrafikObjektName
							(daten.
								getUnscaledValue
							("LängeGrafikObjektName").
									shortValue
							()));
							}
					// ZeichenkettenAttributTyp
						setGrafikObjektName(daten.getTextValue("GrafikObjektName").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStellCodeGrafikTextKonservenNummer(getStellCodeGrafikTextKonservenNummer());
							klon.setLaengeGrafikObjektName(getLaengeGrafikObjektName());
							klon.setGrafikObjektName(getGrafikObjektName());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgBildDefinition";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgBildDefinition(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
