/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Codeliste (FG 4 &#47; Typ 43).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ 43
							?Codeliste?
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 3 (Parameter) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mit dieser Nachricht teilen DEs und
							Clusterkanäle nach Steuerprinzip 2 und 3 der
							Zentrale ihren derzeit aktuellen Vorrat an
							definierten Stellcodes mit. Für DEs nach
							Steuerungsprinzip 1 ist diese Nachricht
							nicht definiert und wird bei Abfrage mit ID
							19 dementsprechend mit Code 2 negativ
							quittiert. Die Bedeutung der Codes ab Byte 6
							hängt davon ab, ob es sich bei dem DE um
							einen Clusterkanal handelt, andernfalls vom
							Anzeigeprinzip des DEs. Jedes DE liefert
							dafür eine entsprechende Kennung im Feld
							?Anzeigeprinzip?.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsWzgCodeListe extends AbstractOnlineDatensatz<OdTlsWzgCodeListe.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
				 _anzeigePrinzip
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
				> _stellCode = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
				>(224, true);
		
			/**
			Anzeigeprinzip des WZG entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von AnzeigePrinzip.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
				 getAnzeigePrinzip() {
				return _anzeigePrinzip;
			}
		
			/**
			Anzeigeprinzip des WZG entsprechend TLS.
			<p>
			
			</p>
			
			@param _anzeigePrinzip der neue Wert von AnzeigePrinzip.
			*/
			public void setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
			 _anzeigePrinzip) {
				this._anzeigePrinzip = _anzeigePrinzip;
			}
		
			/**
			Ist-Zustand des Stellcodes.
			<p>
			
			</p>
			
			@return der Wert von StellCode.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
				> getStellCode() {
				return _stellCode;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAnzeigePrinzip() != null) {
		                if (getAnzeigePrinzip().isZustand()) {
		                    datum.getUnscaledValue("AnzeigePrinzip").setText(getAnzeigePrinzip().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzeigePrinzip").set(getAnzeigePrinzip().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStellCode() != null) {
						final Data.NumberArray arrayStellCode = datum.
							getUnscaledArray
							("StellCode");
						arrayStellCode.setLength(getStellCode().size());
						for (int i = 0; i < arrayStellCode.getLength(); ++i) {
							arrayStellCode.getValue(i).set(getStellCode().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnzeigePrinzip").isState()) {
								setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
								.getZustand(daten.getScaledValue("AnzeigePrinzip").getText()));
							} else {
							setAnzeigePrinzip(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
							(daten.
								getUnscaledValue
							("AnzeigePrinzip").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayStellCode = daten.
							getUnscaledArray
						("StellCode");
		
						for (int i = 0; i < arrayStellCode.getLength(); ++i) {
		                    getStellCode().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
		                    (arrayStellCode.
		                    		shortValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnzeigePrinzip(getAnzeigePrinzip());
						klon._stellCode = getStellCode().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgCodeListe";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgCodeListe(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
