/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Wechseltext (FG 4 &#47; Typ 50).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ
							50"Wechseltext"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Die Nachricht wird für neue Anlagen nicht
							mehr verwendet. Sie wird ersetzt durch die
							verallgemeinerte Version der Nachricht
							?Stellzustand? Typ 55. In Altanlagen können
							Wzg nach Anzeigeprinzip c) oder d) im
							Steuerungsprinzip 1 und 3 die Nachricht aus
							Kompatibilitätsgründen noch verwenden.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 5 (Befehl) in Abruf-
							und Antwortrichtung oder mit ID 37
							(Befehlsrückmeldung aus Puffer) in
							Antwortrichtung. Die Nachricht wird für
							Wzg&#47;WWW verwendet, die frei steuerbare
							Wechseltexte anzeigen können
							(Wechseltextanzeigen). Die Nachricht
							überträgt einen Text in ASCII-Code, welcher
							auf dem Wzg&#47;WWW dargestellt wird, bzw.
							werden soll. Enthält das Funktionsbyte die
							Anweisung"ausschalten", so ist der
							Textbereich ohne Bedeutung. In diesem Fall
							wird sinnvoller Weise die Anzahl Textzeichen
							= 0 übertragen.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Nach erfolgter Zuweisung oder spontan wird
							die Meldung des Wechseltextzustandes in
							Antwortrichtung mit dem DEBlock"Zeitstempel
							mit Folgenummer" (Typ 31) zusammen gesendet,
							um in der Zentrale die dargestellten Zeichen
							mit genauen Wechselzeitpunkten dokumentieren
							zu können.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Angabe der Textlänge ist unabhängig von
							der Anzahl der tatsächlich vorhandenen
							Textzeichen. Wenn eine geringere Anzahl
							Zeichen übergeben wird, wird der Rest
							ausgeschaltet. Wird eine größere Anzahl
							übergeben, wird der Befehl negativ
							quittiert.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Textzeichen 1..n werden in Leserichtung
							(von links nach rechts und zeilenweise und
							von oben nach unten) im DEBlock übertragen.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsWzgWechselText extends AbstractOnlineDatensatz<OdTlsWzgWechselText.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsVorgabeArchiv,
					Aspekte.TlsVorgabe,
					Aspekte.TlsZustand,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.tlsVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsVorgabeArchiv");
			
			/**
			 * Aspekt für Vorgaben (Daten zum Senden an eine SS),
						die nicht wie die Parametersätze automatisch
						verschickt werden (z.B. goegrafische Kenndaten,
						Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabe = new Aspekte("TlsVorgabe", "asp.tlsVorgabe");
			
			/**
			 * Aspekt für den aktuellen Zustand , die i.d.R.
						ausfallsicher im SM oder EAK abgelegt werden (z.B.
						goegrafische Kenndaten, Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsZustand = new Aspekte("TlsZustand", "asp.tlsZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _wVZTextZeichen
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
				 _blinken
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
				()
				;
		
			/**
			Textzeile. EIne "leere" Textzeile bedeutet
									Anzeige ausgeschaltet.
			<p>
			
			</p>
			
			@return der Wert von WVZTextZeichen.
			*/
				public String
				 getWVZTextZeichen() {
				return _wVZTextZeichen;
			}
		
			/**
			Textzeile. EIne "leere" Textzeile bedeutet
									Anzeige ausgeschaltet.
			<p>
			
			</p>
			
			@param _wVZTextZeichen der neue Wert von WVZTextZeichen.
			*/
			public void setWVZTextZeichen(String
			 _wVZTextZeichen) {
				if (_wVZTextZeichen.length() > 220) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 220 + " Zeichen sein.");
				}
				this._wVZTextZeichen = _wVZTextZeichen;
			}
		
			/**
			Einzelinformationen zum Blinkverhalten bei der
								Anzeige des WVZ.
			<p>
			
			</p>
			
			@return der Wert von Blinken.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
				 getBlinken() {
				return _blinken;
			}
		
			/**
			Einzelinformationen zum Blinkverhalten bei der
								Anzeige des WVZ.
			<p>
			
			</p>
			
			@param _blinken der neue Wert von Blinken.
			*/
			public void setBlinken(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
			 _blinken) {
				this._blinken = _blinken;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getWVZTextZeichen() != null) {
						datum.getTextValue("WVZTextZeichen").setText(getWVZTextZeichen());
					}
					// AttributListenDefinition
						getBlinken().bean2Atl(datum.getItem("Blinken"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setWVZTextZeichen(daten.getTextValue("WVZTextZeichen").getText());
					// AttributListenDefinition
						getBlinken().atl2Bean(daten.getItem("Blinken"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setWVZTextZeichen(getWVZTextZeichen());
							klon._blinken = getBlinken().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgWechselText";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgWechselText(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
