/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
WVZ-Stellzustand (FG 4 &#47; Typ 48).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ
							48"WVZ-Stellzustand"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Die Nachricht wird für neue Anlagen nicht
							mehr verwendet. Sie wird ersetzt durch die
							allgemeine Nachricht ?Stellzustand? Typ 55.
							In Altanlagen kann die Nachricht jedoch von
							Wzgs, die nach Anzeigeprinzip a) oder b) im
							Steuerungsprinzip 2 arbeiten, aus
							Kompatibilitätsgründen weiterhin verwendet
							werden.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 5 (Befehl) in Abruf-
							und Antwortrichtung oder mit ID 37
							(Befehlsrückmeldung aus Puffer) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Bei einem Dirigenten ist ein Stellbefehl mit
							ID 5 in Abrufrichtung nicht möglich.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Bei spontaner Meldung des Stellzustands
							(z.B. bei Ausfall oder Abschaltung wegen
							Verstümmelung des WVZs) wird ebenfalls die
							ID 5 in Antwortrichtung verwendet.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht überträgt den WVZ-Code,
							welcher auf dem Wzg dargestellt wird, bzw.
							werden soll. Enthält das Funktionsbyte die
							Anweisung"ausschalten", so ist der WVZ-Code
							ohne Bedeutung. Nach erfolgter Zuweisung
							oder spontan wird die Meldung des
							Stellzustandes in Antwortrichtung mit dem
							DE-Block"Zeitstempel mit Folgenummer" (Typ
							31) zusammen gesendet, um in der Zentrale
							die dargestellten Zeichen mit genauen
							Wechselzeitpunkten dokumentieren zu können.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsWzgWvzStellZustand extends AbstractOnlineDatensatz<OdTlsWzgWvzStellZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsVorgabeArchiv,
					Aspekte.TlsVorgabe,
					Aspekte.TlsZustand,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.tlsVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsVorgabeArchiv");
			
			/**
			 * Aspekt für Vorgaben (Daten zum Senden an eine SS),
						die nicht wie die Parametersätze automatisch
						verschickt werden (z.B. goegrafische Kenndaten,
						Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabe = new Aspekte("TlsVorgabe", "asp.tlsVorgabe");
			
			/**
			 * Aspekt für den aktuellen Zustand , die i.d.R.
						ausfallsicher im SM oder EAK abgelegt werden (z.B.
						goegrafische Kenndaten, Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsZustand = new Aspekte("TlsZustand", "asp.tlsZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
				 _wvzCode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
				 _blinken
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
				()
				;
		
			/**
			Gültige WVZ-Code entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von WvzCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
				 getWvzCode() {
				return _wvzCode;
			}
		
			/**
			Gültige WVZ-Code entsprechend TLS.
			<p>
			
			</p>
			
			@param _wvzCode der neue Wert von WvzCode.
			*/
			public void setWvzCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
			 _wvzCode) {
				this._wvzCode = _wvzCode;
			}
		
			/**
			Einzelinformationen zum Blinkverhalten bei der
								Anzeige des WVZ.
			<p>
			
			</p>
			
			@return der Wert von Blinken.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
				 getBlinken() {
				return _blinken;
			}
		
			/**
			Einzelinformationen zum Blinkverhalten bei der
								Anzeige des WVZ.
			<p>
			
			</p>
			
			@param _blinken der neue Wert von Blinken.
			*/
			public void setBlinken(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
			 _blinken) {
				this._blinken = _blinken;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getWvzCode() != null) {
		                if (getWvzCode().isZustand()) {
		                    datum.getUnscaledValue("WvzCode").setText(getWvzCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("WvzCode").set(getWvzCode().getValue());
		                }
					}
					// AttributListenDefinition
						getBlinken().bean2Atl(datum.getItem("Blinken"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("WvzCode").isState()) {
								setWvzCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
								.getZustand(daten.getScaledValue("WvzCode").getText()));
							} else {
							setWvzCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
							(daten.
								getUnscaledValue
							("WvzCode").
									shortValue
							()));
							}
					// AttributListenDefinition
						getBlinken().atl2Bean(daten.getItem("Blinken"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setWvzCode(getWvzCode());
							klon._blinken = getBlinken().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgWvzStellZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgWvzStellZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
