/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametersatz mit Standard-Einstellungen für
					OSI-2-Protokolle (Primary und Secondary), die über
					den zugeordneten Anschlusspunkt kommunizieren.
<p>
&lt;absatz&gt;
						Beim TLS-OSI-Primary Protokoll werden folgende
						Einstellungen unterstützt:
					&lt;&#47;absatz&gt;
					&lt;tabelle ausrichtung="m" rahmen="1" transponiert="n"&gt;
						&lt;titel&gt;TLS-OSI-2-Primary Einstellungen&lt;&#47;titel&gt;
						&lt;kopf&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;Name&lt;&#47;zelle&gt;
								&lt;zelle&gt;Default-Wert&lt;&#47;zelle&gt;
								&lt;zelle&gt;Bedeutung&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
						&lt;&#47;kopf&gt;
						&lt;rumpf&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.port&lt;&#47;zelle&gt;
								&lt;zelle&gt;&#47;dev&#47;ttyS0&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Name der seriellen Schnittstelle
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.bps&lt;&#47;zelle&gt;
								&lt;zelle&gt;9600&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Übertragungsgeschwindigkeit in Bit
									pro Sekunde
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.bits&lt;&#47;zelle&gt;
								&lt;zelle&gt;8&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Bits pro übertragenem Byte
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.stopbits&lt;&#47;zelle&gt;
								&lt;zelle&gt;1&lt;&#47;zelle&gt;
								&lt;zelle&gt;Anzahl Stopbits&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.parität&lt;&#47;zelle&gt;
								&lt;zelle&gt;gerade&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Parität
									(gerade|ungerade|gesetzt|gelöscht|keine)
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.paritätPrüfen&lt;&#47;zelle&gt;
								&lt;zelle&gt;ja&lt;&#47;zelle&gt;
								&lt;zelle&gt;Parität prüfen (ja|nein)&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.rts&lt;&#47;zelle&gt;
								&lt;zelle&gt;immer&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Soll RTS Signal gesetzt werden
									(immer|senden|nie)
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.rtsVorlauf&lt;&#47;zelle&gt;
								&lt;zelle&gt;0&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Sendevorlaufzeit in Millisekunden
									zwischen Setzen von RTS und Versand
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.rtsNachlauf&lt;&#47;zelle&gt;
								&lt;zelle&gt;0&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Sendenachlaufzeit in Millisekunden
									zwischen Versand und Rücksetzen von
									RTS
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.cts&lt;&#47;zelle&gt;
								&lt;zelle&gt;nein&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Soll vor dem Senden auf CTS gewartet
									werden (ja|nein)
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.dsr&lt;&#47;zelle&gt;
								&lt;zelle&gt;ja&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Soll mit dem DSR Signal der Anschluß
									von Kabel bzw. Modem geprüft werden
									(ja|nein)
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;seriell.empfangsTimeout&lt;&#47;zelle&gt;
								&lt;zelle&gt;40&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Zeitlücke zum Erkennen des
									Telegrammendes in Millisekunden
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;
									seriell.empfangsPufferNachVersandLöschen
								&lt;&#47;zelle&gt;
								&lt;zelle&gt;nein&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Nach dem Versand einschließlich
									rtsNachlauf wird der Eingangspuffer
									zusätzlich gelöscht (ja|nein). Dies
									ist sinnvoll, wenn Echo-Zeichen oder
									Schmierzeichen beim Umschalten der
									Senderichtung erkannt werden. Das
									Timing (rtsNachlauf) muss dann sehr
									genau eingestellt werden, weil sonst
									Teile des Antworttelegramms gelöscht
									werden können.
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;tc57.Tw&lt;&#47;zelle&gt;
								&lt;zelle&gt;40&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Wartezeit zwischen Empfang und
									Senden in Millisekunden (40 bis 200)
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;primary.Tap&lt;&#47;zelle&gt;
								&lt;zelle&gt;1000&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Antwortüberwachungszeit der Primary
									in Millisekunden (150 bis 400)
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;
									primary.wiederholungsAnzahl
								&lt;&#47;zelle&gt;
								&lt;zelle&gt;2&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Mindestanzahl der
									Telegrammwiederholungen bei
									Übertragungsfehlern auf einer
									Verbindung bevor diese neu
									initialisiert wird.
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
							&lt;zeile&gt;
								&lt;zelle&gt;
									primary.wiederholungsDauer
								&lt;&#47;zelle&gt;
								&lt;zelle&gt;30000&lt;&#47;zelle&gt;
								&lt;zelle&gt;
									Mindestdauer in Millisekunden für
									Telegrammwiederholungen bei
									Übertragungsfehlern auf einer
									Verbindung bevor diese neu
									initialisiert wird.
								&lt;&#47;zelle&gt;
							&lt;&#47;zeile&gt;
						&lt;&#47;rumpf&gt;
					&lt;&#47;tabelle&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class PdProtokollEinstellungenStandard extends AbstractParameterDatensatz<PdProtokollEinstellungenStandard.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlProtokollEinstellung
				> _protokollEinstellung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlProtokollEinstellung
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Textpaar, das jeweils Name und Wert einer
									Eigenschaft definiert (z.B."seriell.rtsVorlauf",
									"20").
			<p>
			
			</p>
			
			@return der Wert von ProtokollEinstellung.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlProtokollEinstellung
				> getProtokollEinstellung() {
				return _protokollEinstellung;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayProtokollEinstellung = datum.getArray("ProtokollEinstellung");
						arrayProtokollEinstellung.setLength(getProtokollEinstellung().size());
						for (int i = 0; i < arrayProtokollEinstellung.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlProtokollEinstellung
							 atl = getProtokollEinstellung().get(i);
							atl.bean2Atl(arrayProtokollEinstellung.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayProtokollEinstellung = daten.getArray("ProtokollEinstellung");
						for (int i = 0; i < arrayProtokollEinstellung.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlProtokollEinstellung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlProtokollEinstellung
							 ();
							atl.atl2Bean(arrayProtokollEinstellung.getItem(i), factory);
							getProtokollEinstellung().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._protokollEinstellung = getProtokollEinstellung().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.protokollEinstellungenStandard";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdProtokollEinstellungenStandard(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
