/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Lve-Betriebsparameter (FG 1 &#47; Typ 32).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 1: DE-Block-Struktur im Typ
							32"Lve-Betriebsparameter"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 3 (Parameter) in
							Abruf- und Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht überträgt Parameter, welcher
							für den Betrieb der Lve benötigt werden. Die
							Betriebsparameter werden i.d.R. für alle
							Kanäle einer Richtungsfahrbahn gemeinsam
							verändert.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class PdTlsLveBetriebsParameter extends AbstractParameterDatensatz<PdTlsLveBetriebsParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionKurzzeitdaten
				 _versionKurzZeitDaten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerKurzzeitdaten
				 _intervallDauerKurzZeitDaten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionLangzeitdaten
				 _versionLangZeitDaten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerLangzeitdaten
				 _intervallDauerLangZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveAlpha1
				 _alpha1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveAlpha2
				 _alpha2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveLaengengrenzwert
				 _laengenGrenzWert
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveArtMittelwertbildung
				 _artMittelWertBildung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveStartMittelwertbildung
				 _startMittelWertBildung
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Datenversion der Kurzzeitdaten.
			<p>
			Mit Hilfe dieser Bytes wird die Datenversion
								ausgewählt, mit der die zyklisch erfassten
								Verkehrsdaten übertragen werden sollen. Bei Geräten,
								die die Version 4 nicht unterstützen, wird eine 4 in
								diesem Byte mit einer negativen Quittung
								(Fehlerursache 3) beantwortet. Wenn auf die
								Versionen 4 umgeschaltet wird, ohne dass zuvor mit
								dem DEBlock Typ 37 eine entsprechende Parametrierung
								der Grenzen der Geschwindigkeitsklassen vorgenommen
								wurde, dann werden die dort beschriebenen
								Defaultwerte für die Grenzen der
								Geschwindigkeitsklassen verwendet.
			</p>
			
			@return der Wert von VersionKurzZeitDaten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionKurzzeitdaten
				 getVersionKurzZeitDaten() {
				return _versionKurzZeitDaten;
			}
		
			/**
			Datenversion der Kurzzeitdaten.
			<p>
			Mit Hilfe dieser Bytes wird die Datenversion
								ausgewählt, mit der die zyklisch erfassten
								Verkehrsdaten übertragen werden sollen. Bei Geräten,
								die die Version 4 nicht unterstützen, wird eine 4 in
								diesem Byte mit einer negativen Quittung
								(Fehlerursache 3) beantwortet. Wenn auf die
								Versionen 4 umgeschaltet wird, ohne dass zuvor mit
								dem DEBlock Typ 37 eine entsprechende Parametrierung
								der Grenzen der Geschwindigkeitsklassen vorgenommen
								wurde, dann werden die dort beschriebenen
								Defaultwerte für die Grenzen der
								Geschwindigkeitsklassen verwendet.
			</p>
			
			@param _versionKurzZeitDaten der neue Wert von VersionKurzZeitDaten.
			*/
			public void setVersionKurzZeitDaten(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionKurzzeitdaten
			 _versionKurzZeitDaten) {
				this._versionKurzZeitDaten = _versionKurzZeitDaten;
			}
		
			/**
			Erfassungsintervalldauer der Kurzzeitdaten.
			<p>
			Enthält den Wert der Erfassungsintervalldauer. Es
								sind nur Werte zugelassen, die ein ganzzahliges
								Vielfaches haben, welches 60 Minuten ergibt (15s,
								30s, 1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30, 60
								Minuten).
			</p>
			
			@return der Wert von IntervallDauerKurzZeitDaten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerKurzzeitdaten
				 getIntervallDauerKurzZeitDaten() {
				return _intervallDauerKurzZeitDaten;
			}
		
			/**
			Erfassungsintervalldauer der Kurzzeitdaten.
			<p>
			Enthält den Wert der Erfassungsintervalldauer. Es
								sind nur Werte zugelassen, die ein ganzzahliges
								Vielfaches haben, welches 60 Minuten ergibt (15s,
								30s, 1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30, 60
								Minuten).
			</p>
			
			@param _intervallDauerKurzZeitDaten der neue Wert von IntervallDauerKurzZeitDaten.
			*/
			public void setIntervallDauerKurzZeitDaten(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerKurzzeitdaten
			 _intervallDauerKurzZeitDaten) {
				this._intervallDauerKurzZeitDaten = _intervallDauerKurzZeitDaten;
			}
		
			/**
			Datenversion der Langzeitdaten.
			<p>
			Mit Hilfe dieser Bytes wird die Datenversion
								ausgewählt, mit der die zyklisch erfassten
								Verkehrsdaten übertragen werden sollen. Geräte, von
								denen eine nicht implementierte Version gefordert
								wird, antworten mit einer negativen Quittung
								(Fehlerursache 3). Wenn auf die Versionen 17, 18, 22
								oder 23 umgeschaltet wird, ohne dass zuvor mit dem
								DE-Block Typ 38 eine entsprechende Parametrierung
								der Grenzen der Geschwindigkeitsklassen vorgenommen
								wurde, dann werden die dort beschriebenen
								Defaultwerte für die Grenzen der
								Geschwindigkeitsklassen verwendet.
			</p>
			
			@return der Wert von VersionLangZeitDaten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionLangzeitdaten
				 getVersionLangZeitDaten() {
				return _versionLangZeitDaten;
			}
		
			/**
			Datenversion der Langzeitdaten.
			<p>
			Mit Hilfe dieser Bytes wird die Datenversion
								ausgewählt, mit der die zyklisch erfassten
								Verkehrsdaten übertragen werden sollen. Geräte, von
								denen eine nicht implementierte Version gefordert
								wird, antworten mit einer negativen Quittung
								(Fehlerursache 3). Wenn auf die Versionen 17, 18, 22
								oder 23 umgeschaltet wird, ohne dass zuvor mit dem
								DE-Block Typ 38 eine entsprechende Parametrierung
								der Grenzen der Geschwindigkeitsklassen vorgenommen
								wurde, dann werden die dort beschriebenen
								Defaultwerte für die Grenzen der
								Geschwindigkeitsklassen verwendet.
			</p>
			
			@param _versionLangZeitDaten der neue Wert von VersionLangZeitDaten.
			*/
			public void setVersionLangZeitDaten(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionLangzeitdaten
			 _versionLangZeitDaten) {
				this._versionLangZeitDaten = _versionLangZeitDaten;
			}
		
			/**
			Erfassungsintervalldauer der Langzeitdaten.
			<p>
			Es sind nur Stundenwerte zugelassen, die ganzzahlige
								Teiler oder ganzzahlige Mehrfache von 24 Stunden
								sind (1, 2, 3, 4, 6, 8, 12, 24 Stunden).
			</p>
			
			@return der Wert von IntervallDauerLangZeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerLangzeitdaten
				 getIntervallDauerLangZeit() {
				return _intervallDauerLangZeit;
			}
		
			/**
			Erfassungsintervalldauer der Langzeitdaten.
			<p>
			Es sind nur Stundenwerte zugelassen, die ganzzahlige
								Teiler oder ganzzahlige Mehrfache von 24 Stunden
								sind (1, 2, 3, 4, 6, 8, 12, 24 Stunden).
			</p>
			
			@param _intervallDauerLangZeit der neue Wert von IntervallDauerLangZeit.
			*/
			public void setIntervallDauerLangZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerLangzeitdaten
			 _intervallDauerLangZeit) {
				this._intervallDauerLangZeit = _intervallDauerLangZeit;
			}
		
			/**
			Glättungsparameter für gleitende Mittelwertbildung.
			<p>
			Bei Auswahl der Version 3 oder 4 müssen immer die
								Glättungsparameter immer angegeben werden, da in
								diesen Telegrammversionen zusätzlich der gleitende
								Mittelwert für Steuerungszwecke unabhängig von der
								Einstellung zur gleitenden oder arithmetischen
								Mittelwertbildung übertragen wird.
			</p>
			
			@return der Wert von Alpha1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveAlpha1
				 getAlpha1() {
				return _alpha1;
			}
		
			/**
			Glättungsparameter für gleitende Mittelwertbildung.
			<p>
			Bei Auswahl der Version 3 oder 4 müssen immer die
								Glättungsparameter immer angegeben werden, da in
								diesen Telegrammversionen zusätzlich der gleitende
								Mittelwert für Steuerungszwecke unabhängig von der
								Einstellung zur gleitenden oder arithmetischen
								Mittelwertbildung übertragen wird.
			</p>
			
			@param _alpha1 der neue Wert von Alpha1.
			*/
			public void setAlpha1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveAlpha1
			 _alpha1) {
				this._alpha1 = _alpha1;
			}
		
			/**
			Glättungsparameter für gleitende Mittelwertbildung.
			<p>
			Bei Auswahl der Version 3 oder 4 müssen immer die
								Glättungsparameter immer angegeben werden, da in
								diesen Telegrammversionen zusätzlich der gleitende
								Mittelwert für Steuerungszwecke unabhängig von der
								Einstellung zur gleitenden oder arithmetischen
								Mittelwertbildung übertragen wird.
			</p>
			
			@return der Wert von Alpha2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveAlpha2
				 getAlpha2() {
				return _alpha2;
			}
		
			/**
			Glättungsparameter für gleitende Mittelwertbildung.
			<p>
			Bei Auswahl der Version 3 oder 4 müssen immer die
								Glättungsparameter immer angegeben werden, da in
								diesen Telegrammversionen zusätzlich der gleitende
								Mittelwert für Steuerungszwecke unabhängig von der
								Einstellung zur gleitenden oder arithmetischen
								Mittelwertbildung übertragen wird.
			</p>
			
			@param _alpha2 der neue Wert von Alpha2.
			*/
			public void setAlpha2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveAlpha2
			 _alpha2) {
				this._alpha2 = _alpha2;
			}
		
			/**
			Längengrenzwert Lkw&#47;Pkw-Unterscheidung (4,0m-6,54m).
			<p>
			Bei E&#47;A-Konzentratoren ohne Längenauswertung wird
								bei der Zuweisung das Byte ignoriert. In der Antwort
								dieses E&#47;A-Konzentrators wird es auf 255 gesetzt.
			</p>
			
			@return der Wert von LaengenGrenzWert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveLaengengrenzwert
				 getLaengenGrenzWert() {
				return _laengenGrenzWert;
			}
		
			/**
			Längengrenzwert Lkw&#47;Pkw-Unterscheidung (4,0m-6,54m).
			<p>
			Bei E&#47;A-Konzentratoren ohne Längenauswertung wird
								bei der Zuweisung das Byte ignoriert. In der Antwort
								dieses E&#47;A-Konzentrators wird es auf 255 gesetzt.
			</p>
			
			@param _laengenGrenzWert der neue Wert von LaengenGrenzWert.
			*/
			public void setLaengenGrenzWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveLaengengrenzwert
			 _laengenGrenzWert) {
				this._laengenGrenzWert = _laengenGrenzWert;
			}
		
			/**
			Art der Mittelwertbildung (arithmetisch oder
								gleitend).
			<p>
			
			</p>
			
			@return der Wert von ArtMittelWertBildung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveArtMittelwertbildung
				 getArtMittelWertBildung() {
				return _artMittelWertBildung;
			}
		
			/**
			Art der Mittelwertbildung (arithmetisch oder
								gleitend).
			<p>
			
			</p>
			
			@param _artMittelWertBildung der neue Wert von ArtMittelWertBildung.
			*/
			public void setArtMittelWertBildung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveArtMittelwertbildung
			 _artMittelWertBildung) {
				this._artMittelWertBildung = _artMittelWertBildung;
			}
		
			/**
			Startwert für gleitende Mittelwertbildung.
			<p>
			
			</p>
			
			@return der Wert von StartMittelWertBildung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveStartMittelwertbildung
				 getStartMittelWertBildung() {
				return _startMittelWertBildung;
			}
		
			/**
			Startwert für gleitende Mittelwertbildung.
			<p>
			
			</p>
			
			@param _startMittelWertBildung der neue Wert von StartMittelWertBildung.
			*/
			public void setStartMittelWertBildung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveStartMittelwertbildung
			 _startMittelWertBildung) {
				this._startMittelWertBildung = _startMittelWertBildung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getVersionKurzZeitDaten() != null) {
		                if (getVersionKurzZeitDaten().isZustand()) {
		                    datum.getUnscaledValue("VersionKurzZeitDaten").setText(getVersionKurzZeitDaten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VersionKurzZeitDaten").set(getVersionKurzZeitDaten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getIntervallDauerKurzZeitDaten() != null) {
		                if (getIntervallDauerKurzZeitDaten().isZustand()) {
		                    datum.getUnscaledValue("IntervallDauerKurzZeitDaten").setText(getIntervallDauerKurzZeitDaten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("IntervallDauerKurzZeitDaten").set(getIntervallDauerKurzZeitDaten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVersionLangZeitDaten() != null) {
		                if (getVersionLangZeitDaten().isZustand()) {
		                    datum.getUnscaledValue("VersionLangZeitDaten").setText(getVersionLangZeitDaten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VersionLangZeitDaten").set(getVersionLangZeitDaten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getIntervallDauerLangZeit() != null) {
		                if (getIntervallDauerLangZeit().isZustand()) {
		                    datum.getUnscaledValue("IntervallDauerLangZeit").setText(getIntervallDauerLangZeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("IntervallDauerLangZeit").set(getIntervallDauerLangZeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlpha1() != null) {
		                if (getAlpha1().isZustand()) {
		                    datum.getUnscaledValue("alpha1").setText(getAlpha1().toString());
		                } else {
							datum.
							getScaledValue
		                	("alpha1").set(getAlpha1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlpha2() != null) {
		                if (getAlpha2().isZustand()) {
		                    datum.getUnscaledValue("alpha2").setText(getAlpha2().toString());
		                } else {
							datum.
							getScaledValue
		                	("alpha2").set(getAlpha2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLaengenGrenzWert() != null) {
		                if (getLaengenGrenzWert().isZustand()) {
		                    datum.getUnscaledValue("LängenGrenzWert").setText(getLaengenGrenzWert().toString());
		                } else {
							datum.
							getScaledValue
		                	("LängenGrenzWert").set(getLaengenGrenzWert().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getArtMittelWertBildung() != null) {
		                if (getArtMittelWertBildung().isZustand()) {
		                    datum.getUnscaledValue("ArtMittelWertBildung").setText(getArtMittelWertBildung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ArtMittelWertBildung").set(getArtMittelWertBildung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStartMittelWertBildung() != null) {
		                if (getStartMittelWertBildung().isZustand()) {
		                    datum.getUnscaledValue("StartMittelWertBildung").setText(getStartMittelWertBildung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StartMittelWertBildung").set(getStartMittelWertBildung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VersionKurzZeitDaten").isState()) {
								setVersionKurzZeitDaten(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionKurzzeitdaten
								.getZustand(daten.getScaledValue("VersionKurzZeitDaten").getText()));
							} else {
							setVersionKurzZeitDaten(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionKurzzeitdaten
							(daten.
								getUnscaledValue
							("VersionKurzZeitDaten").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("IntervallDauerKurzZeitDaten").isState()) {
								setIntervallDauerKurzZeitDaten(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerKurzzeitdaten
								.getZustand(daten.getScaledValue("IntervallDauerKurzZeitDaten").getText()));
							} else {
							setIntervallDauerKurzZeitDaten(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerKurzzeitdaten
							(daten.
								getUnscaledValue
							("IntervallDauerKurzZeitDaten").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VersionLangZeitDaten").isState()) {
								setVersionLangZeitDaten(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionLangzeitdaten
								.getZustand(daten.getScaledValue("VersionLangZeitDaten").getText()));
							} else {
							setVersionLangZeitDaten(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVersionLangzeitdaten
							(daten.
								getUnscaledValue
							("VersionLangZeitDaten").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("IntervallDauerLangZeit").isState()) {
								setIntervallDauerLangZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerLangzeitdaten
								.getZustand(daten.getScaledValue("IntervallDauerLangZeit").getText()));
							} else {
							setIntervallDauerLangZeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveErfassungsIntervalldauerLangzeitdaten
							(daten.
								getUnscaledValue
							("IntervallDauerLangZeit").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							setAlpha1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveAlpha1
							(daten.
								getScaledValue
							("alpha1").
								doubleValue
							()));
					// GanzzahlAttributTyp
							setAlpha2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveAlpha2
							(daten.
								getScaledValue
							("alpha2").
								doubleValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LängenGrenzWert").isState()) {
								setLaengenGrenzWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveLaengengrenzwert
								.getZustand(daten.getScaledValue("LängenGrenzWert").getText()));
							} else {
							setLaengenGrenzWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveLaengengrenzwert
							(daten.
								getScaledValue
							("LängenGrenzWert").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ArtMittelWertBildung").isState()) {
								setArtMittelWertBildung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveArtMittelwertbildung
								.getZustand(daten.getScaledValue("ArtMittelWertBildung").getText()));
							} else {
							setArtMittelWertBildung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveArtMittelwertbildung
							(daten.
								getUnscaledValue
							("ArtMittelWertBildung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setStartMittelWertBildung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveStartMittelwertbildung
							(daten.
								getUnscaledValue
							("StartMittelWertBildung").
									byteValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setVersionKurzZeitDaten(getVersionKurzZeitDaten());
							klon.setIntervallDauerKurzZeitDaten(getIntervallDauerKurzZeitDaten());
							klon.setVersionLangZeitDaten(getVersionLangZeitDaten());
							klon.setIntervallDauerLangZeit(getIntervallDauerLangZeit());
							klon.setAlpha1(getAlpha1());
							klon.setAlpha2(getAlpha2());
							klon.setLaengenGrenzWert(getLaengenGrenzWert());
							klon.setArtMittelWertBildung(getArtMittelWertBildung());
							klon.setStartMittelWertBildung(getStartMittelWertBildung());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsLveBetriebsParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsLveBetriebsParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
