/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Betriebsparameter (FG 3 &#47; Typ 32).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 3: DE-Block-Struktur im Typ
							32"Betriebsparameter"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 3 (Parameter) in
							Abruf- und Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht überträgt Parameter, welche
							für den Betrieb der Umfelddatenerfassung
							benötigt werden.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class PdTlsUfdBetriebsParameter extends AbstractParameterDatensatz<PdTlsUfdBetriebsParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdErfassungsperiodendauer
				 _erfassungsperiodendauer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdUebertragungsverfahren
				 _uebertragungsverfahren
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Zyklus für die zeitlichen Abstände der Übertragung
								von Messwerten.
			<p>
			&lt;absatz&gt;
									Der Wert "Erfassungsperiodendauer" gibt an, in
									welchen zeitlichen Abständen die Übertragung des
									Messergebnisses erfolgen soll. Es sind nur Werte
									zugelassen, die ein ganzzahliges Vielfaches
									haben, welches 24 Stunden ergibt (1, 2, 3, 4, 5,
									6, 10, 12, 15, 20, und 30 Minuten und 1, 1½, 2,
									3, 4, 6, 8 und 12 Stunden). Davon zu
									unterscheiden ist die Dauer der Messperiode.
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Die Messperiode ist sensor- und
									herstellerspezifisch. Beispielsweise liegt dem
									Mittelwert für die Windgeschwindigkeit eine
									bestimmte Messperiode zugrunde. Der Wert
									"Erfassungsperiodendauer" ist nur relevant bei
									der zyklischen Abgabe von Meldungen (Byte
									"Übertragungsverfahren" = 1).
								&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Erfassungsperiodendauer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdErfassungsperiodendauer
				 getErfassungsperiodendauer() {
				return _erfassungsperiodendauer;
			}
		
			/**
			Zyklus für die zeitlichen Abstände der Übertragung
								von Messwerten.
			<p>
			&lt;absatz&gt;
									Der Wert "Erfassungsperiodendauer" gibt an, in
									welchen zeitlichen Abständen die Übertragung des
									Messergebnisses erfolgen soll. Es sind nur Werte
									zugelassen, die ein ganzzahliges Vielfaches
									haben, welches 24 Stunden ergibt (1, 2, 3, 4, 5,
									6, 10, 12, 15, 20, und 30 Minuten und 1, 1½, 2,
									3, 4, 6, 8 und 12 Stunden). Davon zu
									unterscheiden ist die Dauer der Messperiode.
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Die Messperiode ist sensor- und
									herstellerspezifisch. Beispielsweise liegt dem
									Mittelwert für die Windgeschwindigkeit eine
									bestimmte Messperiode zugrunde. Der Wert
									"Erfassungsperiodendauer" ist nur relevant bei
									der zyklischen Abgabe von Meldungen (Byte
									"Übertragungsverfahren" = 1).
								&lt;&#47;absatz&gt;
			</p>
			
			@param _erfassungsperiodendauer der neue Wert von Erfassungsperiodendauer.
			*/
			public void setErfassungsperiodendauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdErfassungsperiodendauer
			 _erfassungsperiodendauer) {
				this._erfassungsperiodendauer = _erfassungsperiodendauer;
			}
		
			/**
			Art der Übertragung (spontan &#47; nach Abruf).
			<p>
			&lt;absatz&gt;
									Gibt an, wann die Daten der Messwertgeber zur
									Zentrale übertragen werden: Entweder auf Abruf
									durch die Zentrale (Ereignisklasse 2), spontan
									nach Ende der o.g. Erfassungsperiode
									(Ereignisklasse 1). Meldung nur nach Abruf durch
									die Zentrale bedeutet, dass der DE ohne
									Aufforderung keine Meldungen mehr abgibt.
								&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Uebertragungsverfahren.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdUebertragungsverfahren
				 getUebertragungsverfahren() {
				return _uebertragungsverfahren;
			}
		
			/**
			Art der Übertragung (spontan &#47; nach Abruf).
			<p>
			&lt;absatz&gt;
									Gibt an, wann die Daten der Messwertgeber zur
									Zentrale übertragen werden: Entweder auf Abruf
									durch die Zentrale (Ereignisklasse 2), spontan
									nach Ende der o.g. Erfassungsperiode
									(Ereignisklasse 1). Meldung nur nach Abruf durch
									die Zentrale bedeutet, dass der DE ohne
									Aufforderung keine Meldungen mehr abgibt.
								&lt;&#47;absatz&gt;
			</p>
			
			@param _uebertragungsverfahren der neue Wert von Uebertragungsverfahren.
			*/
			public void setUebertragungsverfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdUebertragungsverfahren
			 _uebertragungsverfahren) {
				this._uebertragungsverfahren = _uebertragungsverfahren;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getErfassungsperiodendauer() != null) {
		                if (getErfassungsperiodendauer().isZustand()) {
		                    datum.getUnscaledValue("Erfassungsperiodendauer").setText(getErfassungsperiodendauer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Erfassungsperiodendauer").set(getErfassungsperiodendauer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getUebertragungsverfahren() != null) {
		                if (getUebertragungsverfahren().isZustand()) {
		                    datum.getUnscaledValue("Übertragungsverfahren").setText(getUebertragungsverfahren().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Übertragungsverfahren").set(getUebertragungsverfahren().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Erfassungsperiodendauer").isState()) {
								setErfassungsperiodendauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdErfassungsperiodendauer
								.getZustand(daten.getScaledValue("Erfassungsperiodendauer").getText()));
							} else {
							setErfassungsperiodendauer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdErfassungsperiodendauer
							(daten.
								getUnscaledValue
							("Erfassungsperiodendauer").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Übertragungsverfahren").isState()) {
								setUebertragungsverfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdUebertragungsverfahren
								.getZustand(daten.getScaledValue("Übertragungsverfahren").getText()));
							} else {
							setUebertragungsverfahren(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdUebertragungsverfahren
							(daten.
								getUnscaledValue
							("Übertragungsverfahren").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setErfassungsperiodendauer(getErfassungsperiodendauer());
							klon.setUebertragungsverfahren(getUebertragungsverfahren());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsUfdBetriebsParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsUfdBetriebsParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
