/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Landeskennung für BAST-Zählstelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttBundesLandBAST extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_0_UNBEKANNT = new AttBundesLandBAST("unbekannt", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_1_SCHLESWIG_HOLSTEIN = new AttBundesLandBAST("Schleswig-Holstein", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_2_HAMBURG = new AttBundesLandBAST("Hamburg", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_3_NIEDERSACHSEN = new AttBundesLandBAST("Niedersachsen", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_4_BREMEN = new AttBundesLandBAST("Bremen", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_5_NORDRHEIN_WESTFALEN = new AttBundesLandBAST("Nordrhein-Westfalen", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_6_HESSEN = new AttBundesLandBAST("Hessen", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_7_RHEINLAND_PFALZ = new AttBundesLandBAST("Rheinland-Pfalz", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_8_BADEN_WUERTTEMBERG = new AttBundesLandBAST("Baden-Württemberg", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_9_BAYERN = new AttBundesLandBAST("Bayern", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_10_SAARLAND = new AttBundesLandBAST("Saarland", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_11_BERLIN = new AttBundesLandBAST("Berlin", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_12_BRANDENBURG = new AttBundesLandBAST("Brandenburg", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_13_MECKLENBURG_VORPOMMERN = new AttBundesLandBAST("Mecklenburg-Vorpommern", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_14_SACHSEN = new AttBundesLandBAST("Sachsen", 		Byte
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_15_SACHSEN_ANHALT = new AttBundesLandBAST("Sachsen-Anhalt", 		Byte
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBundesLandBAST ZUSTAND_16_THUERINGEN = new AttBundesLandBAST("Thüringen", 		Byte
	.valueOf("16"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttBundesLandBAST getZustand(final 		Byte
	 value) {
		for (AttBundesLandBAST e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttBundesLandBAST getZustand(final String value) {
		for (AttBundesLandBAST e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttBundesLandBAST> getZustaende() {
		List<AttBundesLandBAST> list = new ArrayList<AttBundesLandBAST>();
		list.add(ZUSTAND_0_UNBEKANNT);
		list.add(ZUSTAND_1_SCHLESWIG_HOLSTEIN);
		list.add(ZUSTAND_2_HAMBURG);
		list.add(ZUSTAND_3_NIEDERSACHSEN);
		list.add(ZUSTAND_4_BREMEN);
		list.add(ZUSTAND_5_NORDRHEIN_WESTFALEN);
		list.add(ZUSTAND_6_HESSEN);
		list.add(ZUSTAND_7_RHEINLAND_PFALZ);
		list.add(ZUSTAND_8_BADEN_WUERTTEMBERG);
		list.add(ZUSTAND_9_BAYERN);
		list.add(ZUSTAND_10_SAARLAND);
		list.add(ZUSTAND_11_BERLIN);
		list.add(ZUSTAND_12_BRANDENBURG);
		list.add(ZUSTAND_13_MECKLENBURG_VORPOMMERN);
		list.add(ZUSTAND_14_SACHSEN);
		list.add(ZUSTAND_15_SACHSEN_ANHALT);
		list.add(ZUSTAND_16_THUERINGEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut LandesnummerBAST.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttBundesLandBAST(final 		Byte
	 value) {
		super(value);
	}
	
	private AttBundesLandBAST(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
