/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
entspricht der Fahrzeuggruppierung der TLS gemäß Anhang 2, Punkt 2.4 (maßgeblich für die Generierung des BAST-Bestandsbandsformats).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AttKlassifizierungsGruppeBAST extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Klassifizierungsgruppe 1: {Kfz}.
	<p>
	
	</p>
	*/
	public static final AttKlassifizierungsGruppeBAST ZUSTAND_1__1 = new AttKlassifizierungsGruppeBAST("1", 		Byte
	.valueOf("1"));

	/**
	Klassifizierungsgruppe2: {Pkw-ähnlich, Lkw-ähnlich}.
	<p>
	
	</p>
	*/
	public static final AttKlassifizierungsGruppeBAST ZUSTAND_2__2 = new AttKlassifizierungsGruppeBAST("2", 		Byte
	.valueOf("2"));

	/**
	Klassifizierungsgruppe 5+1: {nk Kfz, PkwG, PkwA, Lkw, LkwK, Bus}.
	<p>
	
	</p>
	*/
	public static final AttKlassifizierungsGruppeBAST ZUSTAND_3__5_PLUS_1 = new AttKlassifizierungsGruppeBAST("5 plus 1", 		Byte
	.valueOf("3"));

	/**
	Klassifizierungsgruppe 8+1: {nk Kfz, Krad, Kfz, Lfw, PkwA, Lkw, LkwA, Sattel-Kfz, Bus}.
	<p>
	
	</p>
	*/
	public static final AttKlassifizierungsGruppeBAST ZUSTAND_4__8_PLUS_1 = new AttKlassifizierungsGruppeBAST("8 plus 1", 		Byte
	.valueOf("4"));

	/**
	Klassifizierungsgruppe 8+1 + Bast-Geschw: {nk Kfz, Krad, Kfz, Lfw, PkwA, Lkw, LkwA, Sattel-Kfz, Bus} und Geschwindigkeitsdaten LVo, SGV, BPA.
	<p>
	
	</p>
	*/
	public static final AttKlassifizierungsGruppeBAST ZUSTAND_5__8_PLUS_1_GESCHW = new AttKlassifizierungsGruppeBAST("8 plus 1 Geschw", 		Byte
	.valueOf("5"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttKlassifizierungsGruppeBAST getZustand(final 		Byte
	 value) {
		for (AttKlassifizierungsGruppeBAST e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttKlassifizierungsGruppeBAST getZustand(final String value) {
		for (AttKlassifizierungsGruppeBAST e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttKlassifizierungsGruppeBAST> getZustaende() {
		List<AttKlassifizierungsGruppeBAST> list = new ArrayList<AttKlassifizierungsGruppeBAST>();
		list.add(ZUSTAND_1__1);
		list.add(ZUSTAND_2__2);
		list.add(ZUSTAND_3__5_PLUS_1);
		list.add(ZUSTAND_4__8_PLUS_1);
		list.add(ZUSTAND_5__8_PLUS_1_GESCHW);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KlassifizierungsgruppeBAST.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttKlassifizierungsGruppeBAST(final 		Byte
	 value) {
		super(value);
	}
	
	private AttKlassifizierungsGruppeBAST(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
