/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Straßenklasse nach Definition der BAST.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttStrassenKlasseBAST extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Straße ist Autobahn.
	<p>
	
	</p>
	*/
	public static final AttStrassenKlasseBAST ZUSTAND_1_AUTOBAHN = new AttStrassenKlasseBAST("Autobahn", 		Byte
	.valueOf("1"));

	/**
	Straße ist Bundesstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenKlasseBAST ZUSTAND_2_BUNDESSTRASSE = new AttStrassenKlasseBAST("Bundesstraße", 		Byte
	.valueOf("2"));

	/**
	Straße ist Landesstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenKlasseBAST ZUSTAND_3_LANDESSTRASSE = new AttStrassenKlasseBAST("Landesstraße", 		Byte
	.valueOf("3"));

	/**
	Straße ist Kreisstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenKlasseBAST ZUSTAND_4_KREISSTRASSE = new AttStrassenKlasseBAST("Kreisstraße", 		Byte
	.valueOf("4"));

	/**
	Straße ist Stadtstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenKlasseBAST ZUSTAND_5_STADTSTRASSE = new AttStrassenKlasseBAST("Stadtstraße", 		Byte
	.valueOf("5"));

	/**
	Straße ist Gemeindestraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenKlasseBAST ZUSTAND_6_GEMEINDESTRASSE = new AttStrassenKlasseBAST("Gemeindestraße", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStrassenKlasseBAST getZustand(final 		Byte
	 value) {
		for (AttStrassenKlasseBAST e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStrassenKlasseBAST getZustand(final String value) {
		for (AttStrassenKlasseBAST e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStrassenKlasseBAST> getZustaende() {
		List<AttStrassenKlasseBAST> list = new ArrayList<AttStrassenKlasseBAST>();
		list.add(ZUSTAND_1_AUTOBAHN);
		list.add(ZUSTAND_2_BUNDESSTRASSE);
		list.add(ZUSTAND_3_LANDESSTRASSE);
		list.add(ZUSTAND_4_KREISSTRASSE);
		list.add(ZUSTAND_5_STADTSTRASSE);
		list.add(ZUSTAND_6_GEMEINDESTRASSE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StraßenKlasseBAST.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStrassenKlasseBAST(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStrassenKlasseBAST(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
