/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Formatangabe für die zugrundeliegende ASCII Datei.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttVerkehrsDatenQuelleASCIIFormat extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	bast Bestandsbandformat.
	<p>
	Die ASCII Daten liegen im Bast-Bestandsbandformat vor (einzelne oder kombinierte Dateien mit G-, K- und V-Sätzen)
	</p>
	*/
	public static final AttVerkehrsDatenQuelleASCIIFormat ZUSTAND_0_BAST = new AttVerkehrsDatenQuelleASCIIFormat("bast", 		Byte
	.valueOf("0"));

	/**
	Biandi ASCII Format.
	<p>
	Die Daten liegen im Biandi Delemited Format vor. Je Messaufgabe gibt es eine ASCII-Datei, die mit der Konvertierungssoftware ADAKO generiert werden.
	</p>
	*/
	public static final AttVerkehrsDatenQuelleASCIIFormat ZUSTAND_1_BIANDI = new AttVerkehrsDatenQuelleASCIIFormat("biandi", 		Byte
	.valueOf("1"));

	/**
	Traffic Data Systems (ehem. Prodata) Datenformat.
	<p>
	Die ASCII Dateien liegen im blockorientierten Datenformat des Herstellers vor. Sie werden mit der Konvertierungssoftware KOFIRM generiert.
	</p>
	*/
	public static final AttVerkehrsDatenQuelleASCIIFormat ZUSTAND_2_TDS = new AttVerkehrsDatenQuelleASCIIFormat("tds", 		Byte
	.valueOf("2"));

	/**
	Dambach ASCII Datenformat.
	<p>
	Die ASCII Dateien liegen im zeilenorientierten Datenformat des Herstellers vor. Sie werden mit der Konvertierungssoftware UMWAND aus der firmeneigenen Datenbank generiert.
	</p>
	*/
	public static final AttVerkehrsDatenQuelleASCIIFormat ZUSTAND_3_DAMBACH = new AttVerkehrsDatenQuelleASCIIFormat("dambach", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttVerkehrsDatenQuelleASCIIFormat getZustand(final 		Byte
	 value) {
		for (AttVerkehrsDatenQuelleASCIIFormat e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttVerkehrsDatenQuelleASCIIFormat getZustand(final String value) {
		for (AttVerkehrsDatenQuelleASCIIFormat e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttVerkehrsDatenQuelleASCIIFormat> getZustaende() {
		List<AttVerkehrsDatenQuelleASCIIFormat> list = new ArrayList<AttVerkehrsDatenQuelleASCIIFormat>();
		list.add(ZUSTAND_0_BAST);
		list.add(ZUSTAND_1_BIANDI);
		list.add(ZUSTAND_2_TDS);
		list.add(ZUSTAND_3_DAMBACH);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut VerkehrsdatenQuelleASCIIFormat.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttVerkehrsDatenQuelleASCIIFormat(final 		Byte
	 value) {
		super(value);
	}
	
	private AttVerkehrsDatenQuelleASCIIFormat(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
