/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Grobklassifikation für die Geschwindigkeitsklassen.
<p>
Entsprechend Vorgaben wird in M-V mit der Einteilung VK160 auf BAB und VK130 auf anderen Straßen gearbeitet. Die Monatlichen und Jährlichen Auswertungen basieren auf jeweils 10 vordefinierten Klassen.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttVerkehrsDatenQuelleASCIIVKRaster extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Das den Daten zugrundeliegende Geschwindigkeitsraster kann nicht ermittelt werden.
	<p>
	
	</p>
	*/
	public static final AttVerkehrsDatenQuelleASCIIVKRaster ZUSTAND_0_UNBEKANNT = new AttVerkehrsDatenQuelleASCIIVKRaster("unbekannt", 		Byte
	.valueOf("0"));

	/**
	Geschwindigkeitsraster für nicht BAB Straßen (Definition M-V).
	<p>
	Es werden folgende 10 Klassen verwendet: 0-50, 50-60, 60-70, 70-80, 80-90, 90-100, 100-110, 110-120, 120-130 für VK130 und &gt;130 (alle Angaben in km&#47;h)
	</p>
	*/
	public static final AttVerkehrsDatenQuelleASCIIVKRaster ZUSTAND_1_VK130 = new AttVerkehrsDatenQuelleASCIIVKRaster("VK130", 		Byte
	.valueOf("1"));

	/**
	Geschwindigkeitsraster für BAB (Definition M-V).
	<p>
	Es werden folgende 10 Klassen verwendet: 0-80, 80-90, 90-100, 100-110, 110-120, 120-130, 130-140, 140-150, 150-160 und &gt;160 (alle Angaben in km&#47;h)
	</p>
	*/
	public static final AttVerkehrsDatenQuelleASCIIVKRaster ZUSTAND_2_VK160 = new AttVerkehrsDatenQuelleASCIIVKRaster("VK160", 		Byte
	.valueOf("2"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttVerkehrsDatenQuelleASCIIVKRaster getZustand(final 		Byte
	 value) {
		for (AttVerkehrsDatenQuelleASCIIVKRaster e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttVerkehrsDatenQuelleASCIIVKRaster getZustand(final String value) {
		for (AttVerkehrsDatenQuelleASCIIVKRaster e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttVerkehrsDatenQuelleASCIIVKRaster> getZustaende() {
		List<AttVerkehrsDatenQuelleASCIIVKRaster> list = new ArrayList<AttVerkehrsDatenQuelleASCIIVKRaster>();
		list.add(ZUSTAND_0_UNBEKANNT);
		list.add(ZUSTAND_1_VK130);
		list.add(ZUSTAND_2_VK160);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut VerkehrsdatenQuelleASCIIVKRaster.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttVerkehrsDatenQuelleASCIIVKRaster(final 		Byte
	 value) {
		super(value);
	}
	
	private AttVerkehrsDatenQuelleASCIIVKRaster(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
