/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Auf einen Fahrstreifen bezogene Quelle von Verkehrsdaten.
<p>
&lt;sektion&gt;
						&lt;titel&gt;Verkehrsdatenquelle ASCII&lt;&#47;titel&gt;
						&lt;absatz&gt;Mit der Verkehrsdatenquelle vom Typ ASCII ist die Möglichkeit gegeben, Daten von Erfassungspositionen in das System zu übernehmen, die nicht über TLS angeschlossen. Die Verkehrsdatenquelle ASCII ist vergleichbar einem DE-Kanal an einer TLS-Streckenstation, nur werden die Fahrstreifenbezogenen Werte hier aus einer ASCII-Datei bezogen.&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdVerkehrsDatenQuelleASCII extends AbstractKonfigurationsDatensatz<KdVerkehrsDatenQuelleASCII.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _url
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIIndex
				 _fahrStreifenIndex
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIFormat
				 _datenFormat
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIVKRaster
				 _vKRaster
				;
		
			/**
			Pfadangabe (URL) zu den ASCII Dateien mit den Zählwerten.
			<p>
			
			</p>
			
			@return der Wert von Url.
			*/
				public String
				 getUrl() {
				return _url;
			}
		
			/**
			Pfadangabe (URL) zu den ASCII Dateien mit den Zählwerten.
			<p>
			
			</p>
			
			@param _url der neue Wert von Url.
			*/
			public void setUrl(String
			 _url) {
				if (_url.length() > 4096) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 4096 + " Zeichen sein.");
				}
				this._url = _url;
			}
		
			/**
			Datensdatzindex mit deren Hilfe aus der Quelldatei die Daten zum erforderlichen Fahrstreifen ermittelt werden können.
			<p>
			
			</p>
			
			@return der Wert von FahrStreifenIndex.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIIndex
				 getFahrStreifenIndex() {
				return _fahrStreifenIndex;
			}
		
			/**
			Datensdatzindex mit deren Hilfe aus der Quelldatei die Daten zum erforderlichen Fahrstreifen ermittelt werden können.
			<p>
			
			</p>
			
			@param _fahrStreifenIndex der neue Wert von FahrStreifenIndex.
			*/
			public void setFahrStreifenIndex(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIIndex
			 _fahrStreifenIndex) {
				this._fahrStreifenIndex = _fahrStreifenIndex;
			}
		
			/**
			Formatangabe für die zugrundeliegende ASCII Datei.
			<p>
			
			</p>
			
			@return der Wert von DatenFormat.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIFormat
				 getDatenFormat() {
				return _datenFormat;
			}
		
			/**
			Formatangabe für die zugrundeliegende ASCII Datei.
			<p>
			
			</p>
			
			@param _datenFormat der neue Wert von DatenFormat.
			*/
			public void setDatenFormat(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIFormat
			 _datenFormat) {
				this._datenFormat = _datenFormat;
			}
		
			/**
			Grobklassifikation für die Geschwindigkeitsklassen.
			<p>
			Entsprechend Vorgaben wird in M-V mit der Einteilung VK160 auf BAB und VK130 auf anderen Straßen gearbeitet. Die Monatlichen und Jährlichen Auswertungen basieren auf jeweils 10 vordefinierten Klassen.
			</p>
			
			@return der Wert von VKRaster.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIVKRaster
				 getVKRaster() {
				return _vKRaster;
			}
		
			/**
			Grobklassifikation für die Geschwindigkeitsklassen.
			<p>
			Entsprechend Vorgaben wird in M-V mit der Einteilung VK160 auf BAB und VK130 auf anderen Straßen gearbeitet. Die Monatlichen und Jährlichen Auswertungen basieren auf jeweils 10 vordefinierten Klassen.
			</p>
			
			@param _vKRaster der neue Wert von VKRaster.
			*/
			public void setVKRaster(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIVKRaster
			 _vKRaster) {
				this._vKRaster = _vKRaster;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getUrl() != null) {
						datum.getTextValue("Url").setText(getUrl());
					}
					// GanzzahlAttributTyp
					if (getFahrStreifenIndex() != null) {
		                if (getFahrStreifenIndex().isZustand()) {
		                    datum.getUnscaledValue("FahrStreifenIndex").setText(getFahrStreifenIndex().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FahrStreifenIndex").set(getFahrStreifenIndex().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDatenFormat() != null) {
		                if (getDatenFormat().isZustand()) {
		                    datum.getUnscaledValue("DatenFormat").setText(getDatenFormat().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DatenFormat").set(getDatenFormat().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKRaster() != null) {
		                if (getVKRaster().isZustand()) {
		                    datum.getUnscaledValue("VKRaster").setText(getVKRaster().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VKRaster").set(getVKRaster().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setUrl(daten.getTextValue("Url").getText());
					// GanzzahlAttributTyp
							setFahrStreifenIndex(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIIndex
							(daten.
								getUnscaledValue
							("FahrStreifenIndex").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DatenFormat").isState()) {
								setDatenFormat(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIFormat
								.getZustand(daten.getScaledValue("DatenFormat").getText()));
							} else {
							setDatenFormat(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIFormat
							(daten.
								getUnscaledValue
							("DatenFormat").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VKRaster").isState()) {
								setVKRaster(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIVKRaster
								.getZustand(daten.getScaledValue("VKRaster").getText()));
							} else {
							setVKRaster(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttVerkehrsDatenQuelleASCIIVKRaster
							(daten.
								getUnscaledValue
							("VKRaster").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setUrl(getUrl());
							klon.setFahrStreifenIndex(getFahrStreifenIndex());
							klon.setDatenFormat(getDatenFormat());
							klon.setVKRaster(getVKRaster());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenQuelleASCII";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdVerkehrsDatenQuelleASCII(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
