/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Gesamtquerschnitt für Messwerte einer Langzeitzählstelle. Ein Gesamtquerschnitt bezieht seine Daten aus einem oder mehreren Messquerschnitten. Er wird angewendet als Richtungsquerschnitt (alle Messquerschnitte je Fahrtrichtung) bzw. Gesamtquerschnitt (Summe aller Richtungsquerschnitte).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface AuswerteQuerschnitt extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.auswerteQuerschnitt"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Langzeitdaten der Datenart Fahrzeuganzahl in [Fz].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart Fahrzeuganzahl&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten der Datenart Fahrzeuganzahl sind im Erfassungsintervall erfasste Zählwerte bzw. je Aggregationsintervall aufsummierte Zählwerte. Sie werden als absoluter Wert mit der Einheit "Fahrzeuge" angegeben.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenFahrzeugAnzahl.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenFahrzeugAnzahl getOdLangZeitDatenFahrzeugAnzahl();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Geschwindigkeitsklassifizierung entsprechend Geschwindigkeitsraster VK130 (0-50 km&#47;h, 50-60 km&#47;h, ... , 120-130 km&#47;h, 130- km&#47;h).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Fahrzeuganzahl in den Geschwindigkeitsklassen&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten für die Geschwindigkeitsklassen, der Wert gibt die absolute Fahrzeuganzahl im Erfassungsintervall bzw. Aggregationsintervall an. Die Angabe erfolgt mit der Einheit "Fahrzeuge". Folgendes festes Geschwindigkeitsraster mit 10 Klassen wird verwendet: (0-50 km&#47;h, 50-60 km&#47;h, ... , 120-130 km&#47;h, 130- km&#47;h)&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenVK130.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK130 getOdLangZeitDatenVK130();
	
	/**
	Geschwindigkeitsklassifizierung entsprechend Geschwindigkeitsraster VK160 (0-80 km&#47;h, 80-90 km&#47;h, ... , 150-160 km&#47;h, 160- km&#47;h).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Fahrzeuganzahl in den Geschwindigkeitsklassen&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten für die Geschwindigkeitsklassen, der Wert gibt die absolute Fahrzeuganzahl im Erfassungsintervall bzw. Aggregationsintervall an. Die Angabe erfolgt mit der Einheit "Fahrzeuge". Folgendes festes Geschwindigkeitsraster mit 10 Klassen wird verwendet: (0-80 km&#47;h, 80-90 km&#47;h, ... , 150-160 km&#47;h, 160- km&#47;h)&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenVK160.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK160 getOdLangZeitDatenVK160();
	
	/**
	Die Spitzenstunde gibt die Stunde mit der höchsten Verkehsbelastung an.
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Spitzenstunde (Stunde mit der höchsten Verkehsbelastung)&lt;&#47;titel&gt;
							&lt;absatz&gt;Die Spitzenstunde gibt die Stunde mit der höchsten Verkehsbelastung im zugrundeliegenden Intervall an. Die Spitzenstunde wird ab dem Aggregationsintervall Tag bestimmt und als Zeiteinheit angegeben.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenSpitzenStunde.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenStunde getOdLangZeitDatenSpitzenStunde();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Langzeitdaten der Datenart Geschwindigkeit [km&#47;h].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart Fahrzeuggeschwindigkeit&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten der Datenart Fahrzeuggeschwindigkeit sind im Erfassungsintervall bzw. Aggregationsintervall arithmetisch gemittelte Geschwindigkeitsangaben. Sie werden als mit der Einheit "km&#47;h" angegeben und mit der Skalierung 0.1 km&#47;h ausgewiesen.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenGeschwindigkeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenGeschwindigkeit getOdLangZeitDatenGeschwindigkeit();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Langzeitdaten der Datenart V50-Geschwindigkeit [km&#47;h].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart V50-Geschwindigkeit&lt;&#47;titel&gt;
							&lt;absatz&gt;Die Datenart V50-Geschwindigkeit ist die Geschwindigkeit im Erfassungsintervall bzw. Aggregationsintervall, welche von 50% aller Fahrzeuge unterschritten wurde. Die Angabe erfolgt in der Einheit "km&#47;h" und mit der Skalierung 0.1 km&#47;h.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenV50.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV50 getOdLangZeitDatenV50();
	
	/**
	Langzeitdaten der Datenart Durchscnittliche tägliche Verkehrslast (DTV).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart Fahrzeuganzahl&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten der Datenart DTV können ab dem Aggregationsintervall Monat ermittelt werden. Der DTV ist die durchschnittliche Fahrzeuganzahl aller korrekt (d.h. lückenlos und nicht fehlerbehaftet) vorliegenden Tageswerte. Der DTV wird mit der Einheit "Fz&#47;Tag" angegeben.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenDTV.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenDTV getOdLangZeitDatenDTV();
	
	/**
	Langzeitdaten der Datenart V15-Geschwindigkeit [km&#47;h].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart V15-Geschwindigkeit&lt;&#47;titel&gt;
							&lt;absatz&gt;Die Datenart V15-Geschwindigkeit ist die Geschwindigkeit im Erfassungsintervall bzw. Aggregationsintervall, welche von 15% aller Fahrzeuge unterschritten wurde. Die Angabe erfolgt in der Einheit "km&#47;h" und mit der Skalierung 0.1 km&#47;h.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenV15.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV15 getOdLangZeitDatenV15();
	
	/**
	Charakterisierende Daten eines Auswertequerschnitts.
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Auswertequerschnitt&lt;&#47;titel&gt;
							&lt;absatz&gt;Der Auswertequerschnitt dient der Zuordnung von Messquerschnitten für die Erhebung von Langzeitzähldaten. Die Daten werden einersetits von der BAST und andererseits von den Ländern benötigt. Für jede Langzeitzählstelle werden zwei Richtungsquerschnitte definiert und der Gesamtquerschnitt als Zusammenfassung dieser Richtungsquerschnitte.Die an einem Auswertequerschnitt anfallenden Verkehrsdaten liegen normalerweise im Intervall 1 Stunde (normiert) vor.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz AuswerteQuerschnitt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.konfigurationsdaten.KdAuswerteQuerschnitt getKdAuswerteQuerschnitt();
	
	/**
	Der Spitzentag gibt den Tag mit der höchsten Verkehsbelastung an.
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Spitzentag (Tag mit der höchsten Verkehsbelastung)&lt;&#47;titel&gt;
							&lt;absatz&gt;Der Spitzentag gibt den Tag mit der höchsten Verkehsbelastung im zugrundeliegenden Intervall an. Der Spitzentag wird ab dem Aggregationsintervall Monat bestimmt und als Zeiteinheit angegeben.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenSpitzenTag.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenTag getOdLangZeitDatenSpitzenTag();
	
	/**
	Langzeitdaten der Datenart V85-Geschwindigkeit [km&#47;h].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart V85-Geschwindigkeit&lt;&#47;titel&gt;
							&lt;absatz&gt;Die Datenart V85-Geschwindigkeit ist die Geschwindigkeit im Erfassungsintervall bzw. Aggregationsintervall, welche von 85% aller Fahrzeuge unterschritten wurde. Die Angabe erfolgt in der Einheit "km&#47;h" und mit der Skalierung 0.1 km&#47;h.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenV85.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV85 getOdLangZeitDatenV85();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
