/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zählstelle zur Erfassung von Verkehrsdaten allgemein. Bei der konkreten Ausprägung kann es sich sowohl um eine TLS-Streckenstation, Langzeitzählstellen zur Verkehrsdatenerfassung, manuelle Zählstellen o.ä. handeln. Der Typ fasst alle allgemeingültigen Eigenschaften zusammen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface LangZeitZaehlstelle extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.langZeitZählstelle"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
zusätzliche Auswertequerschnitte, die nicht IN oder GEGEN-Richtung darstellen.
<p>

</p>

@return die Menge AuswerteQuerschnitte oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt> getAuswerteQuerschnitte();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Langzeitdaten der Datenart Fahrzeuganzahl in [Fz].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart Fahrzeuganzahl&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten der Datenart Fahrzeuganzahl sind im Erfassungsintervall erfasste Zählwerte bzw. je Aggregationsintervall aufsummierte Zählwerte. Sie werden als absoluter Wert mit der Einheit "Fahrzeuge" angegeben.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenFahrzeugAnzahl.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenFahrzeugAnzahl getOdLangZeitDatenFahrzeugAnzahl();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Geschwindigkeitsklassifizierung entsprechend Geschwindigkeitsraster VK130 (0-50 km&#47;h, 50-60 km&#47;h, ... , 120-130 km&#47;h, 130- km&#47;h).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Fahrzeuganzahl in den Geschwindigkeitsklassen&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten für die Geschwindigkeitsklassen, der Wert gibt die absolute Fahrzeuganzahl im Erfassungsintervall bzw. Aggregationsintervall an. Die Angabe erfolgt mit der Einheit "Fahrzeuge". Folgendes festes Geschwindigkeitsraster mit 10 Klassen wird verwendet: (0-50 km&#47;h, 50-60 km&#47;h, ... , 120-130 km&#47;h, 130- km&#47;h)&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenVK130.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK130 getOdLangZeitDatenVK130();
	
	/**
	Charakterisierende Daten einer Langzeitzählstelle.
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitzählstelle&lt;&#47;titel&gt;
							&lt;absatz&gt;Die Langzeitzählstelle dient zur Erhebung von Langzeitzähldaten. Die Daten werden einerseits von der bast und andererseits von den Ländern benötigt. Jede Langzeitzählstelle besitzt eine Zählstellennummer anhand der sie bundesweit eindeutig identifierbar ist. Dazu können geografische Kenndaten, Verwaltungsinformationen und Herstellerangaben (Gerät) hinterlegt werden. Die an einer Langzeitzählstelle erhobenen Verkehrsdaten liegen normalerweise im Intervall 1 Stunde vor.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitZaehlstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.konfigurationsdaten.KdLangZeitZaehlstelle getKdLangZeitZaehlstelle();
	
	/**
	Geschwindigkeitsklassifizierung entsprechend Geschwindigkeitsraster VK160 (0-80 km&#47;h, 80-90 km&#47;h, ... , 150-160 km&#47;h, 160- km&#47;h).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Fahrzeuganzahl in den Geschwindigkeitsklassen&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten für die Geschwindigkeitsklassen, der Wert gibt die absolute Fahrzeuganzahl im Erfassungsintervall bzw. Aggregationsintervall an. Die Angabe erfolgt mit der Einheit "Fahrzeuge". Folgendes festes Geschwindigkeitsraster mit 10 Klassen wird verwendet: (0-80 km&#47;h, 80-90 km&#47;h, ... , 150-160 km&#47;h, 160- km&#47;h)&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenVK160.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK160 getOdLangZeitDatenVK160();
	
	/**
	Die Spitzenstunde gibt die Stunde mit der höchsten Verkehsbelastung an.
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Spitzenstunde (Stunde mit der höchsten Verkehsbelastung)&lt;&#47;titel&gt;
							&lt;absatz&gt;Die Spitzenstunde gibt die Stunde mit der höchsten Verkehsbelastung im zugrundeliegenden Intervall an. Die Spitzenstunde wird ab dem Aggregationsintervall Tag bestimmt und als Zeiteinheit angegeben.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenSpitzenStunde.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenStunde getOdLangZeitDatenSpitzenStunde();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Langzeitdaten der Datenart Geschwindigkeit [km&#47;h].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart Fahrzeuggeschwindigkeit&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten der Datenart Fahrzeuggeschwindigkeit sind im Erfassungsintervall bzw. Aggregationsintervall arithmetisch gemittelte Geschwindigkeitsangaben. Sie werden als mit der Einheit "km&#47;h" angegeben und mit der Skalierung 0.1 km&#47;h ausgewiesen.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenGeschwindigkeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenGeschwindigkeit getOdLangZeitDatenGeschwindigkeit();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Langzeitdaten der Datenart V50-Geschwindigkeit [km&#47;h].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart V50-Geschwindigkeit&lt;&#47;titel&gt;
							&lt;absatz&gt;Die Datenart V50-Geschwindigkeit ist die Geschwindigkeit im Erfassungsintervall bzw. Aggregationsintervall, welche von 50% aller Fahrzeuge unterschritten wurde. Die Angabe erfolgt in der Einheit "km&#47;h" und mit der Skalierung 0.1 km&#47;h.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenV50.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV50 getOdLangZeitDatenV50();
	
	/**
	Langzeitdaten der Datenart Durchscnittliche tägliche Verkehrslast (DTV).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart Fahrzeuganzahl&lt;&#47;titel&gt;
							&lt;absatz&gt;Langzeitdaten der Datenart DTV können ab dem Aggregationsintervall Monat ermittelt werden. Der DTV ist die durchschnittliche Fahrzeuganzahl aller korrekt (d.h. lückenlos und nicht fehlerbehaftet) vorliegenden Tageswerte. Der DTV wird mit der Einheit "Fz&#47;Tag" angegeben.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenDTV.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenDTV getOdLangZeitDatenDTV();
	
	/**
	Langzeitdaten der Datenart V15-Geschwindigkeit [km&#47;h].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart V15-Geschwindigkeit&lt;&#47;titel&gt;
							&lt;absatz&gt;Die Datenart V15-Geschwindigkeit ist die Geschwindigkeit im Erfassungsintervall bzw. Aggregationsintervall, welche von 15% aller Fahrzeuge unterschritten wurde. Die Angabe erfolgt in der Einheit "km&#47;h" und mit der Skalierung 0.1 km&#47;h.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenV15.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV15 getOdLangZeitDatenV15();
	
	/**
	Der Spitzentag gibt den Tag mit der höchsten Verkehsbelastung an.
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Spitzentag (Tag mit der höchsten Verkehsbelastung)&lt;&#47;titel&gt;
							&lt;absatz&gt;Der Spitzentag gibt den Tag mit der höchsten Verkehsbelastung im zugrundeliegenden Intervall an. Der Spitzentag wird ab dem Aggregationsintervall Monat bestimmt und als Zeiteinheit angegeben.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenSpitzenTag.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenTag getOdLangZeitDatenSpitzenTag();
	
	/**
	Langzeitdaten der Datenart V85-Geschwindigkeit [km&#47;h].
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;Langzeitdaten der Datenart V85-Geschwindigkeit&lt;&#47;titel&gt;
							&lt;absatz&gt;Die Datenart V85-Geschwindigkeit ist die Geschwindigkeit im Erfassungsintervall bzw. Aggregationsintervall, welche von 85% aller Fahrzeuge unterschritten wurde. Die Angabe erfolgt in der Einheit "km&#47;h" und mit der Skalierung 0.1 km&#47;h.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz LangZeitDatenV85.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV85 getOdLangZeitDatenV85();
	
	/**
	DTV Langzeitverkehrsdaten mit Geschwindigkeitsverteilung und berechneten Zusatzwerten)für MQ
						und LZZS (berechnet aus den FS-Werten).
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq getOdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvMq();
	
	/**
	MSV-Wert (Bemessungsverkehrsstärke) für die Gesamt-Kfz für ein Jahr (1., 30. und 50.
						Spitzenstunde QKfzGesamt) .
	<p>
	
	</p>
	@return der Datensatz VerkehrsDatenLangZeitMSV.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitMSV getOdVerkehrsDatenLangZeitMSV();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
