/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fahrstreifen eines Messquerschnitts, der auch als Langzeitmessstelle Verwendung findet.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class FahrStreifenLangZeitImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.FahrStreifenLangZeit { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public FahrStreifenLangZeitImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public FahrStreifenLangZeitImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein FahrStreifenLangZeit.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenDifferenzialKontrolleFs2 getPdVerkehrsDatenDifferenzialKontrolleFs2() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenDifferenzialKontrolleFs2.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitIntervall getOdVerkehrsDatenKurzZeitIntervall() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitIntervall.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenAusfallHaeufigkeitFs getPdVerkehrsDatenAusfallHaeufigkeitFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenAusfallHaeufigkeitFs.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervall getOdVerkehrsDatenLangZeitIntervall() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervall.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren2 getPdVerkehrsLageVerfahren2() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren2.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenDtvFs getOdVerkehrsDatenDtvFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenDtvFs.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdFahrStreifen getKdFahrStreifen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdFahrStreifen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitIntervallMessWertErsetzung getPdVerkehrsDatenKurzZeitIntervallMessWertErsetzung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitIntervallMessWertErsetzung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.parameter.PdVerkehrsDatenLangZeitIntervallPlausibilitaetsPruefungFormal getPdVerkehrsDatenLangZeitIntervallPlausibilitaetsPruefungFormal() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.parameter.PdVerkehrsDatenLangZeitIntervallPlausibilitaetsPruefungFormal.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitGeglaettetFs getOdVerkehrsDatenKurzZeitGeglaettetFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitGeglaettetFs.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs getOdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungFs.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.parameter.PdVerkehrsDatenLangZeitIntervallPlausibilitaetsPruefungLogisch getPdVerkehrsDatenLangZeitIntervallPlausibilitaetsPruefungLogisch() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.parameter.PdVerkehrsDatenLangZeitIntervallPlausibilitaetsPruefungLogisch.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch getPdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenFahrzeugAnzahl getOdLangZeitDatenFahrzeugAnzahl() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenFahrzeugAnzahl.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK130 getOdLangZeitDatenVK130() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK130.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK160 getOdLangZeitDatenVK160() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenVK160.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren1 getPdVerkehrsLageVerfahren1() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsLageVerfahren1.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenStunde getOdLangZeitDatenSpitzenStunde() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenStunde.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenGeschwindigkeit getOdLangZeitDatenGeschwindigkeit() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenGeschwindigkeit.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV50 getOdLangZeitDatenV50() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV50.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitFs getOdVerkehrsDatenKurzZeitFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitFs.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdPassivierungFs getOdPassivierungFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdPassivierungFs.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenDTV getOdLangZeitDatenDTV() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenDTV.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV15 getOdLangZeitDatenV15() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV15.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitTrendExtraPolationFs getOdVerkehrsDatenKurzZeitTrendExtraPolationFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitTrendExtraPolationFs.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenTag getOdLangZeitDatenSpitzenTag() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenSpitzenTag.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV85 getOdLangZeitDatenV85() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.onlinedaten.OdLangZeitDatenV85.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdKfzEinzelDatenFs getOdKfzEinzelDatenFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdKfzEinzelDatenFs.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvFs getOdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenLangZeitIntervallGeschwindigkeitVerteilungDtvFs.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkFs getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseFlinkFs.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalFs getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseNormalFs.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch2 getPdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch2() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitIntervallPlausibilitaetsPruefungLogisch2.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeFs getPdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitTrendExtraPolationPrognoseTraegeFs.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitAnalyseFs getPdVerkehrsDatenKurzZeitAnalyseFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenKurzZeitAnalyseFs.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenVertrauensBereichFs getPdVerkehrsDatenVertrauensBereichFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenVertrauensBereichFs.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitGeschwindigkeitsKlassenIntervall getOdVerkehrsDatenKurzZeitGeschwindigkeitsKlassenIntervall() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitGeschwindigkeitsKlassenIntervall.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenDifferenzialKontrolleFs getPdVerkehrsDatenDifferenzialKontrolleFs() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsDatenDifferenzialKontrolleFs.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
