/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition Attributliste nbaBedingungFundamentalMq.
<p>
&lt;absatz&gt;
						Die Definition umfasst eine Zuordnung von Umfeldbedingungen
						zu Umfelddatensensoren MQ spezifisch.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 16
 */
public class AtlNbaBedingungFundamentalMq implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messQuerschnittReferenz
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaBedingungFundamental
			> _bedingung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaBedingungFundamental
			>(0, true);
	
		/**
		Referenz auf einen Messquerschnitt.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnittReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessQuerschnittReferenz() {
			return _messQuerschnittReferenz;
		}
	
		/**
		Referenz auf einen Messquerschnitt.
		<p>
		
		</p>
		
		@param _messQuerschnittReferenz der neue Wert von MessQuerschnittReferenz.
		*/
		public void setMessQuerschnittReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messQuerschnittReferenz) {
			this._messQuerschnittReferenz = _messQuerschnittReferenz;
		}
	
		/**
		Definition einer Zuordnung Ereignis und Umfeldbedingung.
		<p>
		
		</p>
		
		@return der Wert von Bedingung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaBedingungFundamental
			> getBedingung() {
			return _bedingung;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessQuerschnittReferenz = getMessQuerschnittReferenz();
					final SystemObject tmpMessQuerschnittReferenz;
						if (soMessQuerschnittReferenz instanceof SystemObject) {
							tmpMessQuerschnittReferenz = (SystemObject)soMessQuerschnittReferenz;
						} else if(soMessQuerschnittReferenz instanceof SystemObjekt){
							tmpMessQuerschnittReferenz = ((SystemObjekt)soMessQuerschnittReferenz).getSystemObject();
						} else{
							tmpMessQuerschnittReferenz = null;
						}
					datum.getReferenceValue("MessQuerschnittReferenz").setSystemObject(tmpMessQuerschnittReferenz);
				// AttributListenDefinition
					final Data.Array arrayBedingung = datum.getArray("Bedingung");
					arrayBedingung.setLength(getBedingung().size());
					for (int i = 0; i < arrayBedingung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaBedingungFundamental
						 atl = getBedingung().get(i);
						atl.bean2Atl(arrayBedingung.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessQuerschnittReferenz = daten.getReferenceValue("MessQuerschnittReferenz").getId();
					final SystemObjekt tmpMessQuerschnittReferenz;
					if (idMessQuerschnittReferenz == 0) {
						tmpMessQuerschnittReferenz = null;
					} else {
						final SystemObject soMessQuerschnittReferenz = factory.getDav().getDataModel().getObject(idMessQuerschnittReferenz);
						if (soMessQuerschnittReferenz == null) {
								tmpMessQuerschnittReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessQuerschnittReferenz);
						} else {
							tmpMessQuerschnittReferenz = factory.getModellobjekt(soMessQuerschnittReferenz);
						}
					}
					setMessQuerschnittReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessQuerschnittReferenz);
				// AttributListenDefinition
					final Data.Array arrayBedingung = daten.getArray("Bedingung");
					for (int i = 0; i < arrayBedingung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaBedingungFundamental
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaBedingungFundamental
						 ();
						atl.atl2Bean(arrayBedingung.getItem(i), factory);
						getBedingung().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaBedingungFundamentalMq clone() {
		AtlNbaBedingungFundamentalMq klon = new AtlNbaBedingungFundamentalMq();
		
						klon.setMessQuerschnittReferenz(getMessQuerschnittReferenz());
					klon._bedingung = getBedingung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
