/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Betriebs-Parameter für ein Ziel des Entscheidungspunktes.
<p>
&lt;absatz&gt;
						Betriebs-Parameter für ein Ziel des Entscheidungspunktes.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlNbaEntscheidungspunktBetriebsParameterZiel implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 _zielReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsartZiel
			 _betriebsart
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 _fahrtRichtungManuell
			;
	
		/**
		Ziel für das die Betriebs-Parameter gelten.
		<p>
		
		</p>
		
		@return der Wert von ZielReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 getZielReferenz() {
			return _zielReferenz;
		}
	
		/**
		Ziel für das die Betriebs-Parameter gelten.
		<p>
		
		</p>
		
		@param _zielReferenz der neue Wert von ZielReferenz.
		*/
		public void setZielReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
		 _zielReferenz) {
			this._zielReferenz = _zielReferenz;
		}
	
		/**
		Betriebsart eines Zieles des Entscheidungspunktes.
		<p>
		
		</p>
		
		@return der Wert von Betriebsart.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsartZiel
			 getBetriebsart() {
			return _betriebsart;
		}
	
		/**
		Betriebsart eines Zieles des Entscheidungspunktes.
		<p>
		
		</p>
		
		@param _betriebsart der neue Wert von Betriebsart.
		*/
		public void setBetriebsart(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsartZiel
		 _betriebsart) {
			this._betriebsart = _betriebsart;
		}
	
		/**
		Gibt die FahrtRichtung für den manuellen Betrieb des Ziels am Entscheidungspunkt an.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtungManuell.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 getFahrtRichtungManuell() {
			return _fahrtRichtungManuell;
		}
	
		/**
		Gibt die FahrtRichtung für den manuellen Betrieb des Ziels am Entscheidungspunkt an.
		<p>
		
		</p>
		
		@param _fahrtRichtungManuell der neue Wert von FahrtRichtungManuell.
		*/
		public void setFahrtRichtungManuell(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
		 _fahrtRichtungManuell) {
			this._fahrtRichtungManuell = _fahrtRichtungManuell;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soZielReferenz = getZielReferenz();
					final SystemObject tmpZielReferenz;
						if (soZielReferenz instanceof SystemObject) {
							tmpZielReferenz = (SystemObject)soZielReferenz;
						} else if(soZielReferenz instanceof SystemObjekt){
							tmpZielReferenz = ((SystemObjekt)soZielReferenz).getSystemObject();
						} else{
							tmpZielReferenz = null;
						}
					datum.getReferenceValue("ZielReferenz").setSystemObject(tmpZielReferenz);
				// GanzzahlAttributTyp
				if (getBetriebsart() != null) {
	                if (getBetriebsart().isZustand()) {
	                    datum.getUnscaledValue("Betriebsart").setText(getBetriebsart().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Betriebsart").set(getBetriebsart().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFahrtRichtungManuell() != null) {
	                if (getFahrtRichtungManuell().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtungManuell").setText(getFahrtRichtungManuell().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtungManuell").set(getFahrtRichtungManuell().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idZielReferenz = daten.getReferenceValue("ZielReferenz").getId();
					final SystemObjekt tmpZielReferenz;
					if (idZielReferenz == 0) {
						tmpZielReferenz = null;
					} else {
						final SystemObject soZielReferenz = factory.getDav().getDataModel().getObject(idZielReferenz);
						if (soZielReferenz == null) {
								tmpZielReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaZielUngueltig(idZielReferenz);
						} else {
							tmpZielReferenz = factory.getModellobjekt(soZielReferenz);
						}
					}
					setZielReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
					) tmpZielReferenz);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Betriebsart").isState()) {
							setBetriebsart(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsartZiel
							.getZustand(daten.getScaledValue("Betriebsart").getText()));
						} else {
						setBetriebsart(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaEntscheidungspunktBetriebsartZiel
						(daten.
							getUnscaledValue
						("Betriebsart").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtungManuell").isState()) {
							setFahrtRichtungManuell(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
							.getZustand(daten.getScaledValue("FahrtRichtungManuell").getText()));
						} else {
						setFahrtRichtungManuell(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
						(daten.
							getUnscaledValue
						("FahrtRichtungManuell").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktBetriebsParameterZiel clone() {
		AtlNbaEntscheidungspunktBetriebsParameterZiel klon = new AtlNbaEntscheidungspunktBetriebsParameterZiel();
		
						klon.setZielReferenz(getZielReferenz());
						klon.setBetriebsart(getBetriebsart());
						klon.setFahrtRichtungManuell(getFahrtRichtungManuell());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
