/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelne FahrtRichtungs-NbaRoutenStück-Kombination für die NBA.
<p>
&lt;absatz&gt;
						Für eine FahrtRichtung wird das folgende NbaRoutenStück angegeben.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlNbaEntscheidungspunktFahrtRichtung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 _fahrtRichtung
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck
			 _nbaRoutenStueckReferenz
			;
	
		/**
		Gibt die FahrtRichtung für das angegebene NbaRoutenStück an.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 getFahrtRichtung() {
			return _fahrtRichtung;
		}
	
		/**
		Gibt die FahrtRichtung für das angegebene NbaRoutenStück an.
		<p>
		
		</p>
		
		@param _fahrtRichtung der neue Wert von FahrtRichtung.
		*/
		public void setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
		 _fahrtRichtung) {
			this._fahrtRichtung = _fahrtRichtung;
		}
	
		/**
		Referenz auf das NbaRoutenStück, welches in der angegebenen FahrtRichtung hinter dem Entscheidungspunkt liegt.
		<p>
		
		</p>
		
		@return der Wert von NbaRoutenStueckReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck
			 getNbaRoutenStueckReferenz() {
			return _nbaRoutenStueckReferenz;
		}
	
		/**
		Referenz auf das NbaRoutenStück, welches in der angegebenen FahrtRichtung hinter dem Entscheidungspunkt liegt.
		<p>
		
		</p>
		
		@param _nbaRoutenStueckReferenz der neue Wert von NbaRoutenStueckReferenz.
		*/
		public void setNbaRoutenStueckReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck
		 _nbaRoutenStueckReferenz) {
			this._nbaRoutenStueckReferenz = _nbaRoutenStueckReferenz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFahrtRichtung() != null) {
	                if (getFahrtRichtung().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtung").setText(getFahrtRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtung").set(getFahrtRichtung().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soNbaRoutenStueckReferenz = getNbaRoutenStueckReferenz();
					final SystemObject tmpNbaRoutenStueckReferenz;
						if (soNbaRoutenStueckReferenz instanceof SystemObject) {
							tmpNbaRoutenStueckReferenz = (SystemObject)soNbaRoutenStueckReferenz;
						} else if(soNbaRoutenStueckReferenz instanceof SystemObjekt){
							tmpNbaRoutenStueckReferenz = ((SystemObjekt)soNbaRoutenStueckReferenz).getSystemObject();
						} else{
							tmpNbaRoutenStueckReferenz = null;
						}
					datum.getReferenceValue("NbaRoutenStückReferenz").setSystemObject(tmpNbaRoutenStueckReferenz);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtung").isState()) {
							setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
							.getZustand(daten.getScaledValue("FahrtRichtung").getText()));
						} else {
						setFahrtRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
						(daten.
							getUnscaledValue
						("FahrtRichtung").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idNbaRoutenStueckReferenz = daten.getReferenceValue("NbaRoutenStückReferenz").getId();
					final SystemObjekt tmpNbaRoutenStueckReferenz;
					if (idNbaRoutenStueckReferenz == 0) {
						tmpNbaRoutenStueckReferenz = null;
					} else {
						final SystemObject soNbaRoutenStueckReferenz = factory.getDav().getDataModel().getObject(idNbaRoutenStueckReferenz);
						if (soNbaRoutenStueckReferenz == null) {
								tmpNbaRoutenStueckReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaRoutenStueckUngueltig(idNbaRoutenStueckReferenz);
						} else {
							tmpNbaRoutenStueckReferenz = factory.getModellobjekt(soNbaRoutenStueckReferenz);
						}
					}
					setNbaRoutenStueckReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck
					) tmpNbaRoutenStueckReferenz);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktFahrtRichtung clone() {
		AtlNbaEntscheidungspunktFahrtRichtung klon = new AtlNbaEntscheidungspunktFahrtRichtung();
		
						klon.setFahrtRichtung(getFahrtRichtung());
						klon.setNbaRoutenStueckReferenz(getNbaRoutenStueckReferenz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
