/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelne FahrtRichtungs-NbaRoutenStücke-Kombination für die NBA.
<p>
&lt;absatz&gt;
						Für eine FahrtRichtung werden die folgenden NbaRoutenStücke angegeben.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class AtlNbaEntscheidungspunktFahrtRichtungFuerHinweise implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 _fahrtRichtung
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck
			> _nbaRoutenStueckReferenzen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck
			>(0, true);
	
		/**
		Gibt die FahrtRichtung für die angegebenen NbaRoutenStücke an.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 getFahrtRichtung() {
			return _fahrtRichtung;
		}
	
		/**
		Gibt die FahrtRichtung für die angegebenen NbaRoutenStücke an.
		<p>
		
		</p>
		
		@param _fahrtRichtung der neue Wert von FahrtRichtung.
		*/
		public void setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
		 _fahrtRichtung) {
			this._fahrtRichtung = _fahrtRichtung;
		}
	
		/**
		Referenzen auf die NbaRoutenStücke, welche in der angegebenen FahrtRichtung hinter dem Entscheidungspunkt liegen (in FahrtRichtung aufsteigend).
		<p>
		
		</p>
		
		@return der Wert von NbaRoutenStueckReferenzen.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck
			> getNbaRoutenStueckReferenzen() {
			return _nbaRoutenStueckReferenzen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFahrtRichtung() != null) {
	                if (getFahrtRichtung().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtung").setText(getFahrtRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtung").set(getFahrtRichtung().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayNbaRoutenStueckReferenzen = datum.getReferenceArray("NbaRoutenStückReferenzen");
					arrayNbaRoutenStueckReferenzen.setLength(getNbaRoutenStueckReferenzen().size());
					for (int i = 0; i < arrayNbaRoutenStueckReferenzen.getLength(); ++i) {
						final Object soNbaRoutenStueckReferenzen = getNbaRoutenStueckReferenzen().get(i);
						final SystemObject tmpNbaRoutenStueckReferenzen;
						if (soNbaRoutenStueckReferenzen instanceof SystemObject) {
							tmpNbaRoutenStueckReferenzen = (SystemObject)soNbaRoutenStueckReferenzen;
						} else if(soNbaRoutenStueckReferenzen instanceof SystemObjekt){
							tmpNbaRoutenStueckReferenzen = ((SystemObjekt)soNbaRoutenStueckReferenzen).getSystemObject();
						} else{
							tmpNbaRoutenStueckReferenzen = null;
						}
						arrayNbaRoutenStueckReferenzen.getReferenceValue(i).setSystemObject(tmpNbaRoutenStueckReferenzen);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtung").isState()) {
							setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
							.getZustand(daten.getScaledValue("FahrtRichtung").getText()));
						} else {
						setFahrtRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
						(daten.
							getUnscaledValue
						("FahrtRichtung").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayNbaRoutenStueckReferenzen = daten.getReferenceArray("NbaRoutenStückReferenzen");
					for (int i = 0; i < arrayNbaRoutenStueckReferenzen.getLength(); ++i) {
						final long idNbaRoutenStueckReferenzen = daten.getReferenceArray("NbaRoutenStückReferenzen").getReferenceValue(i).getId();
						final SystemObjekt tmpNbaRoutenStueckReferenzen;
						if (idNbaRoutenStueckReferenzen == 0) {
							tmpNbaRoutenStueckReferenzen = null;
						} else {
							final SystemObject soNbaRoutenStueckReferenzen = factory.getDav().getDataModel().getObject(idNbaRoutenStueckReferenzen);
							if (soNbaRoutenStueckReferenzen == null) {
									tmpNbaRoutenStueckReferenzen = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaRoutenStueckUngueltig(idNbaRoutenStueckReferenzen);
							} else {
								tmpNbaRoutenStueckReferenzen = factory.getModellobjekt(soNbaRoutenStueckReferenzen);
							}
						}
							getNbaRoutenStueckReferenzen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaRoutenStueck
							) tmpNbaRoutenStueckReferenzen);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktFahrtRichtungFuerHinweise clone() {
		AtlNbaEntscheidungspunktFahrtRichtungFuerHinweise klon = new AtlNbaEntscheidungspunktFahrtRichtungFuerHinweise();
		
						klon.setFahrtRichtung(getFahrtRichtung());
					klon._nbaRoutenStueckReferenzen = getNbaRoutenStueckReferenzen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
