/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TemplateEintrag für die Anzeige von Hinweisen.
<p>
&lt;absatz&gt;
						TemplateEintrag für die Anzeige von Hinweisen.
						
						Beispiel für Stauanzeige:
						
						AnzeigenBedeutung | Inhalt
						--------------------------
						Textzeile1        | "[StauanzeigeVerfahren1]"
						Textzeile2        | "hinter"
						Textzeile3        | "[Anschlussstellennummer] [Anschlussstellenname]"
            PiktogrammZusatz1 | "[WvzInhalt:TLS.Stau]"
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlNbaEntscheidungspunktHinweisTemplate implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
			 _anzeigenBedeutung
			;
			private String
			 _inhalt
			= new String
			()
			;
	
		/**
		Gibt die Bedeutung der Anzeige für die Beschaltung mit Hinweisen an.
		<p>
		
		</p>
		
		@return der Wert von AnzeigenBedeutung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
			 getAnzeigenBedeutung() {
			return _anzeigenBedeutung;
		}
	
		/**
		Gibt die Bedeutung der Anzeige für die Beschaltung mit Hinweisen an.
		<p>
		
		</p>
		
		@param _anzeigenBedeutung der neue Wert von AnzeigenBedeutung.
		*/
		public void setAnzeigenBedeutung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
		 _anzeigenBedeutung) {
			this._anzeigenBedeutung = _anzeigenBedeutung;
		}
	
		/**
		Inhalt der Anzeige.
		<p>
		Inhalt der Anzeige mit folgenden definierten Schlüsselwörtern:
								[StauanzeigeVerfahren1] - bis 3 km keine Anzeige, 3 bis 4 km Stau "4 km Stau", 5 bis 6 km Stau "6 km Stau", 7 bis 8 km Stau "8 km Stau", 9 bis 10 km Stau "10 km Stau", &gt; 10 km Stau "Stau"
								[Anschlussstellennummer] - Anschlussstellennummer aus LCL einsetzen
								[Anschlussstellenname] - Anschlussstellenname aus LCL einsetzen (kürzere Alternative Objektbezeichnungen prüfen) 
		            [WvzInhalt:TLS.Gefahrenstelle] - entsprechender WVZ-Inhalt
								[WvzInhalt:TLS.Stau] - entsprechender WVZ-Inhalt
								[WvzInhalt:TLS.Baustelle] - entsprechender WVZ-Inhalt
		</p>
		
		@return der Wert von Inhalt.
		*/
			public String
			 getInhalt() {
			return _inhalt;
		}
	
		/**
		Inhalt der Anzeige.
		<p>
		Inhalt der Anzeige mit folgenden definierten Schlüsselwörtern:
								[StauanzeigeVerfahren1] - bis 3 km keine Anzeige, 3 bis 4 km Stau "4 km Stau", 5 bis 6 km Stau "6 km Stau", 7 bis 8 km Stau "8 km Stau", 9 bis 10 km Stau "10 km Stau", &gt; 10 km Stau "Stau"
								[Anschlussstellennummer] - Anschlussstellennummer aus LCL einsetzen
								[Anschlussstellenname] - Anschlussstellenname aus LCL einsetzen (kürzere Alternative Objektbezeichnungen prüfen) 
		            [WvzInhalt:TLS.Gefahrenstelle] - entsprechender WVZ-Inhalt
								[WvzInhalt:TLS.Stau] - entsprechender WVZ-Inhalt
								[WvzInhalt:TLS.Baustelle] - entsprechender WVZ-Inhalt
		</p>
		
		@param _inhalt der neue Wert von Inhalt.
		*/
		public void setInhalt(String
		 _inhalt) {
			if (_inhalt.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._inhalt = _inhalt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAnzeigenBedeutung() != null) {
	                if (getAnzeigenBedeutung().isZustand()) {
	                    datum.getUnscaledValue("AnzeigenBedeutung").setText(getAnzeigenBedeutung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnzeigenBedeutung").set(getAnzeigenBedeutung().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getInhalt() != null) {
					datum.getTextValue("Inhalt").setText(getInhalt());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AnzeigenBedeutung").isState()) {
							setAnzeigenBedeutung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
							.getZustand(daten.getScaledValue("AnzeigenBedeutung").getText()));
						} else {
						setAnzeigenBedeutung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaAnzeigenBedeutung
						(daten.
							getUnscaledValue
						("AnzeigenBedeutung").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setInhalt(daten.getTextValue("Inhalt").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktHinweisTemplate clone() {
		AtlNbaEntscheidungspunktHinweisTemplate klon = new AtlNbaEntscheidungspunktHinweisTemplate();
		
						klon.setAnzeigenBedeutung(getAnzeigenBedeutung());
						klon.setInhalt(getInhalt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
