/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ReisezeitHysterese für alle FahrtRichtungen des angegebenen Ziels für die NBA.
<p>
&lt;absatz&gt;
						ReisezeitHysterese für alle FahrtRichtungen des angegebenen Ziels für die NBA.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlNbaEntscheidungspunktReisezeitHystereseZiel implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 _zielReferenz
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitHystereseFahrtRichtung
			> _reisezeitHystereseFuerFahrtRichtungen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitHystereseFahrtRichtung
			>(0, true);
	
		/**
		Ziel für die ReisezeitHysterese.
		<p>
		
		</p>
		
		@return der Wert von ZielReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 getZielReferenz() {
			return _zielReferenz;
		}
	
		/**
		Ziel für die ReisezeitHysterese.
		<p>
		
		</p>
		
		@param _zielReferenz der neue Wert von ZielReferenz.
		*/
		public void setZielReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
		 _zielReferenz) {
			this._zielReferenz = _zielReferenz;
		}
	
		/**
		ReisezeitHysteresen für alle FahrtRichtungen des Ziels.
		<p>
		
		</p>
		
		@return der Wert von ReisezeitHystereseFuerFahrtRichtungen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitHystereseFahrtRichtung
			> getReisezeitHystereseFuerFahrtRichtungen() {
			return _reisezeitHystereseFuerFahrtRichtungen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soZielReferenz = getZielReferenz();
					final SystemObject tmpZielReferenz;
						if (soZielReferenz instanceof SystemObject) {
							tmpZielReferenz = (SystemObject)soZielReferenz;
						} else if(soZielReferenz instanceof SystemObjekt){
							tmpZielReferenz = ((SystemObjekt)soZielReferenz).getSystemObject();
						} else{
							tmpZielReferenz = null;
						}
					datum.getReferenceValue("ZielReferenz").setSystemObject(tmpZielReferenz);
				// AttributListenDefinition
					final Data.Array arrayReisezeitHystereseFuerFahrtRichtungen = datum.getArray("ReisezeitHystereseFürFahrtRichtungen");
					arrayReisezeitHystereseFuerFahrtRichtungen.setLength(getReisezeitHystereseFuerFahrtRichtungen().size());
					for (int i = 0; i < arrayReisezeitHystereseFuerFahrtRichtungen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitHystereseFahrtRichtung
						 atl = getReisezeitHystereseFuerFahrtRichtungen().get(i);
						atl.bean2Atl(arrayReisezeitHystereseFuerFahrtRichtungen.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idZielReferenz = daten.getReferenceValue("ZielReferenz").getId();
					final SystemObjekt tmpZielReferenz;
					if (idZielReferenz == 0) {
						tmpZielReferenz = null;
					} else {
						final SystemObject soZielReferenz = factory.getDav().getDataModel().getObject(idZielReferenz);
						if (soZielReferenz == null) {
								tmpZielReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaZielUngueltig(idZielReferenz);
						} else {
							tmpZielReferenz = factory.getModellobjekt(soZielReferenz);
						}
					}
					setZielReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
					) tmpZielReferenz);
				// AttributListenDefinition
					final Data.Array arrayReisezeitHystereseFuerFahrtRichtungen = daten.getArray("ReisezeitHystereseFürFahrtRichtungen");
					for (int i = 0; i < arrayReisezeitHystereseFuerFahrtRichtungen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitHystereseFahrtRichtung
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaEntscheidungspunktReisezeitHystereseFahrtRichtung
						 ();
						atl.atl2Bean(arrayReisezeitHystereseFuerFahrtRichtungen.getItem(i), factory);
						getReisezeitHystereseFuerFahrtRichtungen().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktReisezeitHystereseZiel clone() {
		AtlNbaEntscheidungspunktReisezeitHystereseZiel klon = new AtlNbaEntscheidungspunktReisezeitHystereseZiel();
		
						klon.setZielReferenz(getZielReferenz());
					klon._reisezeitHystereseFuerFahrtRichtungen = getReisezeitHystereseFuerFahrtRichtungen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
