/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kombination aus Ziel und FahrtRichtung für die Abarbeitung am Entscheidungspunkt.
<p>
&lt;absatz&gt;
						Kombination aus Ziel und FahrtRichtung für die Abarbeitung am Entscheidungspunkt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlNbaEntscheidungspunktZielMitFahrtRichtung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 _zielReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 _fahrtRichtung
			;
	
		/**
		Ziel für die Kombination mit der FahrtRichtung.
		<p>
		
		</p>
		
		@return der Wert von ZielReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
			 getZielReferenz() {
			return _zielReferenz;
		}
	
		/**
		Ziel für die Kombination mit der FahrtRichtung.
		<p>
		
		</p>
		
		@param _zielReferenz der neue Wert von ZielReferenz.
		*/
		public void setZielReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
		 _zielReferenz) {
			this._zielReferenz = _zielReferenz;
		}
	
		/**
		FahrtRichtung für die Kombination mit dem Ziel.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 getFahrtRichtung() {
			return _fahrtRichtung;
		}
	
		/**
		FahrtRichtung für die Kombination mit dem Ziel.
		<p>
		
		</p>
		
		@param _fahrtRichtung der neue Wert von FahrtRichtung.
		*/
		public void setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
		 _fahrtRichtung) {
			this._fahrtRichtung = _fahrtRichtung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soZielReferenz = getZielReferenz();
					final SystemObject tmpZielReferenz;
						if (soZielReferenz instanceof SystemObject) {
							tmpZielReferenz = (SystemObject)soZielReferenz;
						} else if(soZielReferenz instanceof SystemObjekt){
							tmpZielReferenz = ((SystemObjekt)soZielReferenz).getSystemObject();
						} else{
							tmpZielReferenz = null;
						}
					datum.getReferenceValue("ZielReferenz").setSystemObject(tmpZielReferenz);
				// GanzzahlAttributTyp
				if (getFahrtRichtung() != null) {
	                if (getFahrtRichtung().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtung").setText(getFahrtRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtung").set(getFahrtRichtung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idZielReferenz = daten.getReferenceValue("ZielReferenz").getId();
					final SystemObjekt tmpZielReferenz;
					if (idZielReferenz == 0) {
						tmpZielReferenz = null;
					} else {
						final SystemObject soZielReferenz = factory.getDav().getDataModel().getObject(idZielReferenz);
						if (soZielReferenz == null) {
								tmpZielReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.impl.NbaZielUngueltig(idZielReferenz);
						} else {
							tmpZielReferenz = factory.getModellobjekt(soZielReferenz);
						}
					}
					setZielReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.objekte.NbaZiel
					) tmpZielReferenz);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtung").isState()) {
							setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
							.getZustand(daten.getScaledValue("FahrtRichtung").getText()));
						} else {
						setFahrtRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
						(daten.
							getUnscaledValue
						("FahrtRichtung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktZielMitFahrtRichtung clone() {
		AtlNbaEntscheidungspunktZielMitFahrtRichtung klon = new AtlNbaEntscheidungspunktZielMitFahrtRichtung();
		
						klon.setZielReferenz(getZielReferenz());
						klon.setFahrtRichtung(getFahrtRichtung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
