/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelne FahrtRichtungs-MessQuerschnitt-Kombination für die NBA.
<p>
&lt;absatz&gt;
						Für eine FahrtRichtung wird der MessQuerschnitt, der den Abfluss misst, angegeben.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 35
 */
public class AtlNbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 _fahrtRichtung
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messQuerschnitt
			;
	
		/**
		Gibt die FahrtRichtung für den angegebenen MessQuerschnitt an.
		<p>
		
		</p>
		
		@return der Wert von FahrtRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
			 getFahrtRichtung() {
			return _fahrtRichtung;
		}
	
		/**
		Gibt die FahrtRichtung für den angegebenen MessQuerschnitt an.
		<p>
		
		</p>
		
		@param _fahrtRichtung der neue Wert von FahrtRichtung.
		*/
		public void setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
		 _fahrtRichtung) {
			this._fahrtRichtung = _fahrtRichtung;
		}
	
		/**
		Referenz auf den MessQuerschnitt, welcher in der angegebenen FahrtRichtung den Abfluss misst.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessQuerschnitt() {
			return _messQuerschnitt;
		}
	
		/**
		Referenz auf den MessQuerschnitt, welcher in der angegebenen FahrtRichtung den Abfluss misst.
		<p>
		
		</p>
		
		@param _messQuerschnitt der neue Wert von MessQuerschnitt.
		*/
		public void setMessQuerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messQuerschnitt) {
			this._messQuerschnitt = _messQuerschnitt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFahrtRichtung() != null) {
	                if (getFahrtRichtung().isZustand()) {
	                    datum.getUnscaledValue("FahrtRichtung").setText(getFahrtRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrtRichtung").set(getFahrtRichtung().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soMessQuerschnitt = getMessQuerschnitt();
					final SystemObject tmpMessQuerschnitt;
						if (soMessQuerschnitt instanceof SystemObject) {
							tmpMessQuerschnitt = (SystemObject)soMessQuerschnitt;
						} else if(soMessQuerschnitt instanceof SystemObjekt){
							tmpMessQuerschnitt = ((SystemObjekt)soMessQuerschnitt).getSystemObject();
						} else{
							tmpMessQuerschnitt = null;
						}
					datum.getReferenceValue("MessQuerschnitt").setSystemObject(tmpMessQuerschnitt);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrtRichtung").isState()) {
							setFahrtRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
							.getZustand(daten.getScaledValue("FahrtRichtung").getText()));
						} else {
						setFahrtRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaFahrtRichtung
						(daten.
							getUnscaledValue
						("FahrtRichtung").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idMessQuerschnitt = daten.getReferenceValue("MessQuerschnitt").getId();
					final SystemObjekt tmpMessQuerschnitt;
					if (idMessQuerschnitt == 0) {
						tmpMessQuerschnitt = null;
					} else {
						final SystemObject soMessQuerschnitt = factory.getDav().getDataModel().getObject(idMessQuerschnitt);
						if (soMessQuerschnitt == null) {
								tmpMessQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessQuerschnitt);
						} else {
							tmpMessQuerschnitt = factory.getModellobjekt(soMessQuerschnitt);
						}
					}
					setMessQuerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessQuerschnitt);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung clone() {
		AtlNbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung klon = new AtlNbaEntscheidungspunktZuordnungMessQuerschnittZuFahrtRichtung();
		
						klon.setFahrtRichtung(getFahrtRichtung());
						klon.setMessQuerschnitt(getMessQuerschnitt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
