/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Diagnosedaten fr die Reisezeitberechnung am MessQuerschnitt für einen Prognosezeitpunkt.
<p>
&lt;absatz&gt;
						Diagnosedaten fr die Reisezeitberechnung am MessQuerschnitt für einen Prognosezeitpunkt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaMessQuerschnittReisezeitPrognoseDiagnose implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeitpunkt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
			 _qB
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _v
			;
			private 	RelativerZeitstempel
			 _reisezeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _verlustzeitBeruecksichtigt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _staulaengeGesamt
			;
			private 	RelativerZeitstempel
			 _verlustzeitGesamt
			;
	
		/**
		Zeitpunkt der Diagnosedaten.
		<p>
		
		</p>
		
		@return der Wert von Zeitpunkt.
		*/
			public 	Zeitstempel
			 getZeitpunkt() {
			return _zeitpunkt;
		}
	
		/**
		Zeitpunkt der Diagnosedaten.
		<p>
		
		</p>
		
		@param _zeitpunkt der neue Wert von Zeitpunkt.
		*/
		public void setZeitpunkt(	Zeitstempel
		 _zeitpunkt) {
			this._zeitpunkt = _zeitpunkt;
		}
	
		/**
		Verkehrsmenge aus der Prognoseganglinie.
		<p>
		
		</p>
		
		@return der Wert von QB.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
			 getQB() {
			return _qB;
		}
	
		/**
		Verkehrsmenge aus der Prognoseganglinie.
		<p>
		
		</p>
		
		@param _qB der neue Wert von QB.
		*/
		public void setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
		 _qB) {
			this._qB = _qB;
		}
	
		/**
		Geschwindigkeitswert aus dem Fundamentaldiagramm.
		<p>
		
		</p>
		
		@return der Wert von V.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getV() {
			return _v;
		}
	
		/**
		Geschwindigkeitswert aus dem Fundamentaldiagramm.
		<p>
		
		</p>
		
		@param _v der neue Wert von V.
		*/
		public void setV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _v) {
			this._v = _v;
		}
	
		/**
		Reisezeit auf der Ausdehnung des MessQuerschnitt.
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Reisezeit auf der Ausdehnung des MessQuerschnitt.
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
		/**
		Information, ob bei der Reisezeit eine Verlustzeit berücksichtigt wurde.
		<p>
		
		</p>
		
		@return der Wert von VerlustzeitBeruecksichtigt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getVerlustzeitBeruecksichtigt() {
			return _verlustzeitBeruecksichtigt;
		}
	
		/**
		Information, ob bei der Reisezeit eine Verlustzeit berücksichtigt wurde.
		<p>
		
		</p>
		
		@param _verlustzeitBeruecksichtigt der neue Wert von VerlustzeitBeruecksichtigt.
		*/
		public void setVerlustzeitBeruecksichtigt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _verlustzeitBeruecksichtigt) {
			this._verlustzeitBeruecksichtigt = _verlustzeitBeruecksichtigt;
		}
	
		/**
		Gesamte Staulänge aller berücksichtigter Stauobjekte.
		<p>
		
		</p>
		
		@return der Wert von StaulaengeGesamt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getStaulaengeGesamt() {
			return _staulaengeGesamt;
		}
	
		/**
		Gesamte Staulänge aller berücksichtigter Stauobjekte.
		<p>
		
		</p>
		
		@param _staulaengeGesamt der neue Wert von StaulaengeGesamt.
		*/
		public void setStaulaengeGesamt(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _staulaengeGesamt) {
			this._staulaengeGesamt = _staulaengeGesamt;
		}
	
		/**
		Gesamte Verlustzeit aller berücksichtigter Stauobjekte.
		<p>
		
		</p>
		
		@return der Wert von VerlustzeitGesamt.
		*/
			public 	RelativerZeitstempel
			 getVerlustzeitGesamt() {
			return _verlustzeitGesamt;
		}
	
		/**
		Gesamte Verlustzeit aller berücksichtigter Stauobjekte.
		<p>
		
		</p>
		
		@param _verlustzeitGesamt der neue Wert von VerlustzeitGesamt.
		*/
		public void setVerlustzeitGesamt(	RelativerZeitstempel
		 _verlustzeitGesamt) {
			this._verlustzeitGesamt = _verlustzeitGesamt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitpunkt").setMillis(getZeitpunkt().getTime());
				// GanzzahlAttributTyp
				if (getQB() != null) {
	                if (getQB().isZustand()) {
	                    datum.getUnscaledValue("QB").setText(getQB().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("QB").set(getQB().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getV() != null) {
	                if (getV().isZustand()) {
	                    datum.getUnscaledValue("V").setText(getV().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("V").set(getV().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
				// GanzzahlAttributTyp
				if (getVerlustzeitBeruecksichtigt() != null) {
	                if (getVerlustzeitBeruecksichtigt().isZustand()) {
	                    datum.getUnscaledValue("VerlustzeitBerücksichtigt").setText(getVerlustzeitBeruecksichtigt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VerlustzeitBerücksichtigt").set(getVerlustzeitBeruecksichtigt().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStaulaengeGesamt() != null) {
	                if (getStaulaengeGesamt().isZustand()) {
	                    datum.getUnscaledValue("StaulängeGesamt").setText(getStaulaengeGesamt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StaulängeGesamt").set(getStaulaengeGesamt().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("VerlustzeitGesamt").setMillis(getVerlustzeitGesamt().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("Zeitpunkt").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("QB").isState()) {
							setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
							.getZustand(daten.getScaledValue("QB").getText()));
						} else {
						setQB(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
						(daten.
							getUnscaledValue
						("QB").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("V").isState()) {
							setV(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("V").getText()));
						} else {
						setV(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("V").
								shortValue
						()));
						}
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VerlustzeitBerücksichtigt").isState()) {
							setVerlustzeitBeruecksichtigt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("VerlustzeitBerücksichtigt").getText()));
						} else {
						setVerlustzeitBeruecksichtigt(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("VerlustzeitBerücksichtigt").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StaulängeGesamt").isState()) {
							setStaulaengeGesamt(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("StaulängeGesamt").getText()));
						} else {
						setStaulaengeGesamt(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("StaulängeGesamt").
								longValue
						()));
						}
				// ZeitstempelAttributTyp
					setVerlustzeitGesamt(new
						RelativerZeitstempel
						(daten.getTimeValue("VerlustzeitGesamt").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaMessQuerschnittReisezeitPrognoseDiagnose clone() {
		AtlNbaMessQuerschnittReisezeitPrognoseDiagnose klon = new AtlNbaMessQuerschnittReisezeitPrognoseDiagnose();
		
						klon.setZeitpunkt(getZeitpunkt());
						klon.setQB(getQB());
						klon.setV(getV());
						klon.setReisezeit(getReisezeit());
						klon.setVerlustzeitBeruecksichtigt(getVerlustzeitBeruecksichtigt());
						klon.setStaulaengeGesamt(getStaulaengeGesamt());
						klon.setVerlustzeitGesamt(getVerlustzeitGesamt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
