/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einstellung Grenzwert in Prozent pro Verkehrsparameter.
<p>
&lt;absatz&gt;
						Einstellung Grenzwert in Prozent pro Verkehrsparameter.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 39
 */
public class AtlNbaParameterUeberwachungPrognoseErgebnisse implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _verkehrsparameter
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _grenzwert
			;
	
		/**
		Art der Prüfung (z.B Reisezeit, Verkehrsstärke usw).
		<p>
		
		</p>
		
		@return der Wert von Verkehrsparameter.
		*/
			public String
			 getVerkehrsparameter() {
			return _verkehrsparameter;
		}
	
		/**
		Art der Prüfung (z.B Reisezeit, Verkehrsstärke usw).
		<p>
		
		</p>
		
		@param _verkehrsparameter der neue Wert von Verkehrsparameter.
		*/
		public void setVerkehrsparameter(String
		 _verkehrsparameter) {
			if (_verkehrsparameter.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._verkehrsparameter = _verkehrsparameter;
		}
	
		/**
		Art der Prüfung (z.B Reisezeit, Verkehrsstärke usw).
		<p>
		
		</p>
		
		@return der Wert von Grenzwert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getGrenzwert() {
			return _grenzwert;
		}
	
		/**
		Art der Prüfung (z.B Reisezeit, Verkehrsstärke usw).
		<p>
		
		</p>
		
		@param _grenzwert der neue Wert von Grenzwert.
		*/
		public void setGrenzwert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _grenzwert) {
			this._grenzwert = _grenzwert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getVerkehrsparameter() != null) {
					datum.getTextValue("Verkehrsparameter").setText(getVerkehrsparameter());
				}
				// GanzzahlAttributTyp
				if (getGrenzwert() != null) {
	                if (getGrenzwert().isZustand()) {
	                    datum.getUnscaledValue("Grenzwert").setText(getGrenzwert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Grenzwert").set(getGrenzwert().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setVerkehrsparameter(daten.getTextValue("Verkehrsparameter").getText());
				// GanzzahlAttributTyp
						setGrenzwert(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("Grenzwert").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaParameterUeberwachungPrognoseErgebnisse clone() {
		AtlNbaParameterUeberwachungPrognoseErgebnisse klon = new AtlNbaParameterUeberwachungPrognoseErgebnisse();
		
						klon.setVerkehrsparameter(getVerkehrsparameter());
						klon.setGrenzwert(getGrenzwert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
