/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Parametrierung der Priorität.
<p>
&lt;absatz&gt;
            Attributgruppe zur Parametrierung der Priorität
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 13
 */
public class AtlNbaPrioritaetAspekt1 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 _defaultPrioritaet
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAspekt
			> _aspekt = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAspekt
			>(0, true);
	
		/**
		Priorität des Anzeigeinhalt.
		<p>
		
		</p>
		
		@return der Wert von DefaultPrioritaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
			 getDefaultPrioritaet() {
			return _defaultPrioritaet;
		}
	
		/**
		Priorität des Anzeigeinhalt.
		<p>
		
		</p>
		
		@param _defaultPrioritaet der neue Wert von DefaultPrioritaet.
		*/
		public void setDefaultPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
		 _defaultPrioritaet) {
			this._defaultPrioritaet = _defaultPrioritaet;
		}
	
		/**
		Priorität Aspekt.
		<p>
		
		</p>
		
		@return der Wert von Aspekt.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAspekt
			> getAspekt() {
			return _aspekt;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getDefaultPrioritaet() != null) {
	                if (getDefaultPrioritaet().isZustand()) {
	                    datum.getUnscaledValue("Default-Priorität").setText(getDefaultPrioritaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Default-Priorität").set(getDefaultPrioritaet().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayAspekt = datum.getArray("Aspekt");
					arrayAspekt.setLength(getAspekt().size());
					for (int i = 0; i < arrayAspekt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAspekt
						 atl = getAspekt().get(i);
						atl.bean2Atl(arrayAspekt.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Default-Priorität").isState()) {
							setDefaultPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
							.getZustand(daten.getScaledValue("Default-Priorität").getText()));
						} else {
						setDefaultPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaPrioritaet
						(daten.
							getUnscaledValue
						("Default-Priorität").
								intValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayAspekt = daten.getArray("Aspekt");
					for (int i = 0; i < arrayAspekt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAspekt
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaPrioritaetAspekt
						 ();
						atl.atl2Bean(arrayAspekt.getItem(i), factory);
						getAspekt().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaPrioritaetAspekt1 clone() {
		AtlNbaPrioritaetAspekt1 klon = new AtlNbaPrioritaetAspekt1();
		
						klon.setDefaultPrioritaet(getDefaultPrioritaet());
					klon._aspekt = getAspekt().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
