/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelner Reisezeit-Prognose-Ereignisse-Datensatz für die NBA.
<p>
&lt;absatz&gt;
						Einzelner Reisezeit-Prognose-Ereignisse-Datensatz für die NBA.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 21
 */
public class AtlNbaReisezeitPrognoseEreignisse implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeitpunkt
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation
			> _ereignisse = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation
			>(0, true);
	
		/**
		Zeitpunkt für die berücksichtigten Ereignisse.
		<p>
		
		</p>
		
		@return der Wert von Zeitpunkt.
		*/
			public 	Zeitstempel
			 getZeitpunkt() {
			return _zeitpunkt;
		}
	
		/**
		Zeitpunkt für die berücksichtigten Ereignisse.
		<p>
		
		</p>
		
		@param _zeitpunkt der neue Wert von Zeitpunkt.
		*/
		public void setZeitpunkt(	Zeitstempel
		 _zeitpunkt) {
			this._zeitpunkt = _zeitpunkt;
		}
	
		/**
		Staus, Baustellen und Unfälle auf den RoutenStück.
		<p>
		
		</p>
		
		@return der Wert von Ereignisse.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation
			> getEreignisse() {
			return _ereignisse;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitpunkt").setMillis(getZeitpunkt().getTime());
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEreignisse = datum.getReferenceArray("Ereignisse");
					arrayEreignisse.setLength(getEreignisse().size());
					for (int i = 0; i < arrayEreignisse.getLength(); ++i) {
						final Object soEreignisse = getEreignisse().get(i);
						final SystemObject tmpEreignisse;
						if (soEreignisse instanceof SystemObject) {
							tmpEreignisse = (SystemObject)soEreignisse;
						} else if(soEreignisse instanceof SystemObjekt){
							tmpEreignisse = ((SystemObjekt)soEreignisse).getSystemObject();
						} else{
							tmpEreignisse = null;
						}
						arrayEreignisse.getReferenceValue(i).setSystemObject(tmpEreignisse);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("Zeitpunkt").getMillis()));
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayEreignisse = daten.getReferenceArray("Ereignisse");
					for (int i = 0; i < arrayEreignisse.getLength(); ++i) {
						final long idEreignisse = daten.getReferenceArray("Ereignisse").getReferenceValue(i).getId();
						final SystemObjekt tmpEreignisse;
						if (idEreignisse == 0) {
							tmpEreignisse = null;
						} else {
							final SystemObject soEreignisse = factory.getDav().getDataModel().getObject(idEreignisse);
							if (soEreignisse == null) {
									tmpEreignisse = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.SituationUngueltig(idEreignisse);
							} else {
								tmpEreignisse = factory.getModellobjekt(soEreignisse);
							}
						}
							getEreignisse().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation
							) tmpEreignisse);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaReisezeitPrognoseEreignisse clone() {
		AtlNbaReisezeitPrognoseEreignisse klon = new AtlNbaReisezeitPrognoseEreignisse();
		
						klon.setZeitpunkt(getZeitpunkt());
					klon._ereignisse = getEreignisse().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
