/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
MessQuerschnitt und Information der nicht Verwendung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 30
 */
public class AtlNbaRoutenStueckMQNichtVerwenden implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messQuerschnitt
			;
			@Defaultwert(wert = "Ja")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _beiReisezeitermittlungNichtVerwenden
			;
	
		/**
		Referenz auf den MessQuerschnitt.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessQuerschnitt() {
			return _messQuerschnitt;
		}
	
		/**
		Referenz auf den MessQuerschnitt.
		<p>
		
		</p>
		
		@param _messQuerschnitt der neue Wert von MessQuerschnitt.
		*/
		public void setMessQuerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messQuerschnitt) {
			this._messQuerschnitt = _messQuerschnitt;
		}
	
		/**
		Festlegung, ob der MessQuerschnitt bei der Reisezeitermittlung nicht verwendet werden soll.
		<p>
		
		</p>
		
		@return der Wert von BeiReisezeitermittlungNichtVerwenden.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getBeiReisezeitermittlungNichtVerwenden() {
			return _beiReisezeitermittlungNichtVerwenden;
		}
	
		/**
		Festlegung, ob der MessQuerschnitt bei der Reisezeitermittlung nicht verwendet werden soll.
		<p>
		
		</p>
		
		@param _beiReisezeitermittlungNichtVerwenden der neue Wert von BeiReisezeitermittlungNichtVerwenden.
		*/
		public void setBeiReisezeitermittlungNichtVerwenden(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _beiReisezeitermittlungNichtVerwenden) {
			this._beiReisezeitermittlungNichtVerwenden = _beiReisezeitermittlungNichtVerwenden;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessQuerschnitt = getMessQuerschnitt();
					final SystemObject tmpMessQuerschnitt;
						if (soMessQuerschnitt instanceof SystemObject) {
							tmpMessQuerschnitt = (SystemObject)soMessQuerschnitt;
						} else if(soMessQuerschnitt instanceof SystemObjekt){
							tmpMessQuerschnitt = ((SystemObjekt)soMessQuerschnitt).getSystemObject();
						} else{
							tmpMessQuerschnitt = null;
						}
					datum.getReferenceValue("MessQuerschnitt").setSystemObject(tmpMessQuerschnitt);
				// GanzzahlAttributTyp
				if (getBeiReisezeitermittlungNichtVerwenden() != null) {
	                if (getBeiReisezeitermittlungNichtVerwenden().isZustand()) {
	                    datum.getUnscaledValue("BeiReisezeitermittlungNichtVerwenden").setText(getBeiReisezeitermittlungNichtVerwenden().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("BeiReisezeitermittlungNichtVerwenden").set(getBeiReisezeitermittlungNichtVerwenden().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessQuerschnitt = daten.getReferenceValue("MessQuerschnitt").getId();
					final SystemObjekt tmpMessQuerschnitt;
					if (idMessQuerschnitt == 0) {
						tmpMessQuerschnitt = null;
					} else {
						final SystemObject soMessQuerschnitt = factory.getDav().getDataModel().getObject(idMessQuerschnitt);
						if (soMessQuerschnitt == null) {
								tmpMessQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessQuerschnitt);
						} else {
							tmpMessQuerschnitt = factory.getModellobjekt(soMessQuerschnitt);
						}
					}
					setMessQuerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessQuerschnitt);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("BeiReisezeitermittlungNichtVerwenden").isState()) {
							setBeiReisezeitermittlungNichtVerwenden(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("BeiReisezeitermittlungNichtVerwenden").getText()));
						} else {
						setBeiReisezeitermittlungNichtVerwenden(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("BeiReisezeitermittlungNichtVerwenden").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaRoutenStueckMQNichtVerwenden clone() {
		AtlNbaRoutenStueckMQNichtVerwenden klon = new AtlNbaRoutenStueckMQNichtVerwenden();
		
						klon.setMessQuerschnitt(getMessQuerschnitt());
						klon.setBeiReisezeitermittlungNichtVerwenden(getBeiReisezeitermittlungNichtVerwenden());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
