/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ReisezeitPrognose für einen Messquerschnitt des NBA-RoutenStück für einen Prognosezeitpunkt.
<p>
&lt;absatz&gt;
						ReisezeitPrognose für einen Messquerschnitt des NBA-RoutenStück für einen Prognosezeitpunkt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 30
 */
public class AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messQuerschnitt
			;
			private 	Zeitstempel
			 _zeitintervall
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laengeAufRoutenstueck
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laengeAufRoutenstueckSumme
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _geschwindigkeit
			;
			private 	RelativerZeitstempel
			 _reisezeit
			;
			private 	RelativerZeitstempel
			 _reisezeitSumme
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _stauLaengeAufRoutenstueck
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _stauLaengeAufRoutenstueckSumme
			;
			private 	RelativerZeitstempel
			 _stauReisezeitSumme
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 _qB
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
			 _stau
			;
	
		/**
		Referenz auf den Messquerschnitt, der für das Teil-RoutenStück verantwortlich ist.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessQuerschnitt() {
			return _messQuerschnitt;
		}
	
		/**
		Referenz auf den Messquerschnitt, der für das Teil-RoutenStück verantwortlich ist.
		<p>
		
		</p>
		
		@param _messQuerschnitt der neue Wert von MessQuerschnitt.
		*/
		public void setMessQuerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messQuerschnitt) {
			this._messQuerschnitt = _messQuerschnitt;
		}
	
		/**
		Zeitpunkt der Prognosewerte des Messquerschnitt.
		<p>
		
		</p>
		
		@return der Wert von Zeitintervall.
		*/
			public 	Zeitstempel
			 getZeitintervall() {
			return _zeitintervall;
		}
	
		/**
		Zeitpunkt der Prognosewerte des Messquerschnitt.
		<p>
		
		</p>
		
		@param _zeitintervall der neue Wert von Zeitintervall.
		*/
		public void setZeitintervall(	Zeitstempel
		 _zeitintervall) {
			this._zeitintervall = _zeitintervall;
		}
	
		/**
		Länge des Teil-RoutenStückes auf dem Routenstück.
		<p>
		
		</p>
		
		@return der Wert von LaengeAufRoutenstueck.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLaengeAufRoutenstueck() {
			return _laengeAufRoutenstueck;
		}
	
		/**
		Länge des Teil-RoutenStückes auf dem Routenstück.
		<p>
		
		</p>
		
		@param _laengeAufRoutenstueck der neue Wert von LaengeAufRoutenstueck.
		*/
		public void setLaengeAufRoutenstueck(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _laengeAufRoutenstueck) {
			this._laengeAufRoutenstueck = _laengeAufRoutenstueck;
		}
	
		/**
		Summe der Längen der Teil-RoutenStücke auf dem Routenstück.
		<p>
		
		</p>
		
		@return der Wert von LaengeAufRoutenstueckSumme.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLaengeAufRoutenstueckSumme() {
			return _laengeAufRoutenstueckSumme;
		}
	
		/**
		Summe der Längen der Teil-RoutenStücke auf dem Routenstück.
		<p>
		
		</p>
		
		@param _laengeAufRoutenstueckSumme der neue Wert von LaengeAufRoutenstueckSumme.
		*/
		public void setLaengeAufRoutenstueckSumme(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _laengeAufRoutenstueckSumme) {
			this._laengeAufRoutenstueckSumme = _laengeAufRoutenstueckSumme;
		}
	
		/**
		Geschwindigkeitswert aus dem Fundamentaldiagramm.
		<p>
		
		</p>
		
		@return der Wert von Geschwindigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getGeschwindigkeit() {
			return _geschwindigkeit;
		}
	
		/**
		Geschwindigkeitswert aus dem Fundamentaldiagramm.
		<p>
		
		</p>
		
		@param _geschwindigkeit der neue Wert von Geschwindigkeit.
		*/
		public void setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _geschwindigkeit) {
			this._geschwindigkeit = _geschwindigkeit;
		}
	
		/**
		Reisezeit auf dem Teil-Routenstück.
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Reisezeit auf dem Teil-Routenstück.
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
		/**
		Summe der Reisezeiten der Teil-Routenstücke.
		<p>
		
		</p>
		
		@return der Wert von ReisezeitSumme.
		*/
			public 	RelativerZeitstempel
			 getReisezeitSumme() {
			return _reisezeitSumme;
		}
	
		/**
		Summe der Reisezeiten der Teil-Routenstücke.
		<p>
		
		</p>
		
		@param _reisezeitSumme der neue Wert von ReisezeitSumme.
		*/
		public void setReisezeitSumme(	RelativerZeitstempel
		 _reisezeitSumme) {
			this._reisezeitSumme = _reisezeitSumme;
		}
	
		/**
		Stau-Länge auf dem Routenstück.
		<p>
		
		</p>
		
		@return der Wert von StauLaengeAufRoutenstueck.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getStauLaengeAufRoutenstueck() {
			return _stauLaengeAufRoutenstueck;
		}
	
		/**
		Stau-Länge auf dem Routenstück.
		<p>
		
		</p>
		
		@param _stauLaengeAufRoutenstueck der neue Wert von StauLaengeAufRoutenstueck.
		*/
		public void setStauLaengeAufRoutenstueck(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _stauLaengeAufRoutenstueck) {
			this._stauLaengeAufRoutenstueck = _stauLaengeAufRoutenstueck;
		}
	
		/**
		Summe der Stau-Längen auf dem Routenstück.
		<p>
		
		</p>
		
		@return der Wert von StauLaengeAufRoutenstueckSumme.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getStauLaengeAufRoutenstueckSumme() {
			return _stauLaengeAufRoutenstueckSumme;
		}
	
		/**
		Summe der Stau-Längen auf dem Routenstück.
		<p>
		
		</p>
		
		@param _stauLaengeAufRoutenstueckSumme der neue Wert von StauLaengeAufRoutenstueckSumme.
		*/
		public void setStauLaengeAufRoutenstueckSumme(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _stauLaengeAufRoutenstueckSumme) {
			this._stauLaengeAufRoutenstueckSumme = _stauLaengeAufRoutenstueckSumme;
		}
	
		/**
		Summe der Stau-Reisezeiten.
		<p>
		
		</p>
		
		@return der Wert von StauReisezeitSumme.
		*/
			public 	RelativerZeitstempel
			 getStauReisezeitSumme() {
			return _stauReisezeitSumme;
		}
	
		/**
		Summe der Stau-Reisezeiten.
		<p>
		
		</p>
		
		@param _stauReisezeitSumme der neue Wert von StauReisezeitSumme.
		*/
		public void setStauReisezeitSumme(	RelativerZeitstempel
		 _stauReisezeitSumme) {
			this._stauReisezeitSumme = _stauReisezeitSumme;
		}
	
		/**
		Bemessungsverkehrsstärke aus der Prognoseganglinie.
		<p>
		
		</p>
		
		@return der Wert von QB.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
			 getQB() {
			return _qB;
		}
	
		/**
		Bemessungsverkehrsstärke aus der Prognoseganglinie.
		<p>
		
		</p>
		
		@param _qB der neue Wert von QB.
		*/
		public void setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
		 _qB) {
			this._qB = _qB;
		}
	
		/**
		Referenz auf den berücksichtigten Stau.
		<p>
		
		</p>
		
		@return der Wert von Stau.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
			 getStau() {
			return _stau;
		}
	
		/**
		Referenz auf den berücksichtigten Stau.
		<p>
		
		</p>
		
		@param _stau der neue Wert von Stau.
		*/
		public void setStau(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
		 _stau) {
			this._stau = _stau;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessQuerschnitt = getMessQuerschnitt();
					final SystemObject tmpMessQuerschnitt;
						if (soMessQuerschnitt instanceof SystemObject) {
							tmpMessQuerschnitt = (SystemObject)soMessQuerschnitt;
						} else if(soMessQuerschnitt instanceof SystemObjekt){
							tmpMessQuerschnitt = ((SystemObjekt)soMessQuerschnitt).getSystemObject();
						} else{
							tmpMessQuerschnitt = null;
						}
					datum.getReferenceValue("MessQuerschnitt").setSystemObject(tmpMessQuerschnitt);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitintervall").setMillis(getZeitintervall().getTime());
				// GanzzahlAttributTyp
				if (getLaengeAufRoutenstueck() != null) {
	                if (getLaengeAufRoutenstueck().isZustand()) {
	                    datum.getUnscaledValue("LängeAufRoutenstück").setText(getLaengeAufRoutenstueck().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LängeAufRoutenstück").set(getLaengeAufRoutenstueck().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLaengeAufRoutenstueckSumme() != null) {
	                if (getLaengeAufRoutenstueckSumme().isZustand()) {
	                    datum.getUnscaledValue("LängeAufRoutenstückSumme").setText(getLaengeAufRoutenstueckSumme().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LängeAufRoutenstückSumme").set(getLaengeAufRoutenstueckSumme().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGeschwindigkeit() != null) {
	                if (getGeschwindigkeit().isZustand()) {
	                    datum.getUnscaledValue("Geschwindigkeit").setText(getGeschwindigkeit().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Geschwindigkeit").set(getGeschwindigkeit().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("ReisezeitSumme").setMillis(getReisezeitSumme().getTime());
				// GanzzahlAttributTyp
				if (getStauLaengeAufRoutenstueck() != null) {
	                if (getStauLaengeAufRoutenstueck().isZustand()) {
	                    datum.getUnscaledValue("StauLängeAufRoutenstück").setText(getStauLaengeAufRoutenstueck().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StauLängeAufRoutenstück").set(getStauLaengeAufRoutenstueck().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStauLaengeAufRoutenstueckSumme() != null) {
	                if (getStauLaengeAufRoutenstueckSumme().isZustand()) {
	                    datum.getUnscaledValue("StauLängeAufRoutenstückSumme").setText(getStauLaengeAufRoutenstueckSumme().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StauLängeAufRoutenstückSumme").set(getStauLaengeAufRoutenstueckSumme().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("StauReisezeitSumme").setMillis(getStauReisezeitSumme().getTime());
				// GanzzahlAttributTyp
				if (getQB() != null) {
	                if (getQB().isZustand()) {
	                    datum.getUnscaledValue("QB").setText(getQB().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("QB").set(getQB().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soStau = getStau();
					final SystemObject tmpStau;
						if (soStau instanceof SystemObject) {
							tmpStau = (SystemObject)soStau;
						} else if(soStau instanceof SystemObjekt){
							tmpStau = ((SystemObjekt)soStau).getSystemObject();
						} else{
							tmpStau = null;
						}
					datum.getReferenceValue("Stau").setSystemObject(tmpStau);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessQuerschnitt = daten.getReferenceValue("MessQuerschnitt").getId();
					final SystemObjekt tmpMessQuerschnitt;
					if (idMessQuerschnitt == 0) {
						tmpMessQuerschnitt = null;
					} else {
						final SystemObject soMessQuerschnitt = factory.getDav().getDataModel().getObject(idMessQuerschnitt);
						if (soMessQuerschnitt == null) {
								tmpMessQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessQuerschnitt);
						} else {
							tmpMessQuerschnitt = factory.getModellobjekt(soMessQuerschnitt);
						}
					}
					setMessQuerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessQuerschnitt);
				// ZeitstempelAttributTyp
					setZeitintervall(new
						Zeitstempel
						(daten.getTimeValue("Zeitintervall").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LängeAufRoutenstück").isState()) {
							setLaengeAufRoutenstueck(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("LängeAufRoutenstück").getText()));
						} else {
						setLaengeAufRoutenstueck(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("LängeAufRoutenstück").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LängeAufRoutenstückSumme").isState()) {
							setLaengeAufRoutenstueckSumme(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("LängeAufRoutenstückSumme").getText()));
						} else {
						setLaengeAufRoutenstueckSumme(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("LängeAufRoutenstückSumme").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Geschwindigkeit").isState()) {
							setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("Geschwindigkeit").getText()));
						} else {
						setGeschwindigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("Geschwindigkeit").
								shortValue
						()));
						}
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
				// ZeitstempelAttributTyp
					setReisezeitSumme(new
						RelativerZeitstempel
						(daten.getTimeValue("ReisezeitSumme").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StauLängeAufRoutenstück").isState()) {
							setStauLaengeAufRoutenstueck(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("StauLängeAufRoutenstück").getText()));
						} else {
						setStauLaengeAufRoutenstueck(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("StauLängeAufRoutenstück").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StauLängeAufRoutenstückSumme").isState()) {
							setStauLaengeAufRoutenstueckSumme(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("StauLängeAufRoutenstückSumme").getText()));
						} else {
						setStauLaengeAufRoutenstueckSumme(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("StauLängeAufRoutenstückSumme").
								longValue
						()));
						}
				// ZeitstempelAttributTyp
					setStauReisezeitSumme(new
						RelativerZeitstempel
						(daten.getTimeValue("StauReisezeitSumme").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("QB").isState()) {
							setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("QB").getText()));
						} else {
						setQB(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("QB").
								intValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idStau = daten.getReferenceValue("Stau").getId();
					final SystemObjekt tmpStau;
					if (idStau == 0) {
						tmpStau = null;
					} else {
						final SystemObject soStau = factory.getDav().getDataModel().getObject(idStau);
						if (soStau == null) {
								tmpStau = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StauUngueltig(idStau);
						} else {
							tmpStau = factory.getModellobjekt(soStau);
						}
					}
					setStau((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
					) tmpStau);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln clone() {
		AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln klon = new AtlNbaRoutenStueckReisezeitPrognoseMQEinzeln();
		
						klon.setMessQuerschnitt(getMessQuerschnitt());
						klon.setZeitintervall(getZeitintervall());
						klon.setLaengeAufRoutenstueck(getLaengeAufRoutenstueck());
						klon.setLaengeAufRoutenstueckSumme(getLaengeAufRoutenstueckSumme());
						klon.setGeschwindigkeit(getGeschwindigkeit());
						klon.setReisezeit(getReisezeit());
						klon.setReisezeitSumme(getReisezeitSumme());
						klon.setStauLaengeAufRoutenstueck(getStauLaengeAufRoutenstueck());
						klon.setStauLaengeAufRoutenstueckSumme(getStauLaengeAufRoutenstueckSumme());
						klon.setStauReisezeitSumme(getStauReisezeitSumme());
						klon.setQB(getQB());
						klon.setStau(getStau());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
