/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Analysedaten der Reisezeitberechnung pro Messquerschnitt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgDatenReisezeitMQ implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messQuerschnitt
			;
			private 	RelativerZeitstempel
			 _reisezeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laenge
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _geschwindigkeit
			;
	
		/**
		Referenz auf ein Messquerschnitt.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessQuerschnitt() {
			return _messQuerschnitt;
		}
	
		/**
		Referenz auf ein Messquerschnitt.
		<p>
		
		</p>
		
		@param _messQuerschnitt der neue Wert von MessQuerschnitt.
		*/
		public void setMessQuerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messQuerschnitt) {
			this._messQuerschnitt = _messQuerschnitt;
		}
	
		/**
		Aktuelle Reisezeit des StraßenSegment.
		<p>
		
		</p>
		
		@return der Wert von Reisezeit.
		*/
			public 	RelativerZeitstempel
			 getReisezeit() {
			return _reisezeit;
		}
	
		/**
		Aktuelle Reisezeit des StraßenSegment.
		<p>
		
		</p>
		
		@param _reisezeit der neue Wert von Reisezeit.
		*/
		public void setReisezeit(	RelativerZeitstempel
		 _reisezeit) {
			this._reisezeit = _reisezeit;
		}
	
		/**
		Länge des StraßenSegment.
		<p>
		
		</p>
		
		@return der Wert von Laenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLaenge() {
			return _laenge;
		}
	
		/**
		Länge des StraßenSegment.
		<p>
		
		</p>
		
		@param _laenge der neue Wert von Laenge.
		*/
		public void setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _laenge) {
			this._laenge = _laenge;
		}
	
		/**
		Geschwindigkeit auf dem Straßenabschnitt.
		<p>
		
		</p>
		
		@return der Wert von Geschwindigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getGeschwindigkeit() {
			return _geschwindigkeit;
		}
	
		/**
		Geschwindigkeit auf dem Straßenabschnitt.
		<p>
		
		</p>
		
		@param _geschwindigkeit der neue Wert von Geschwindigkeit.
		*/
		public void setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _geschwindigkeit) {
			this._geschwindigkeit = _geschwindigkeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessQuerschnitt = getMessQuerschnitt();
					final SystemObject tmpMessQuerschnitt;
						if (soMessQuerschnitt instanceof SystemObject) {
							tmpMessQuerschnitt = (SystemObject)soMessQuerschnitt;
						} else if(soMessQuerschnitt instanceof SystemObjekt){
							tmpMessQuerschnitt = ((SystemObjekt)soMessQuerschnitt).getSystemObject();
						} else{
							tmpMessQuerschnitt = null;
						}
					datum.getReferenceValue("MessQuerschnitt").setSystemObject(tmpMessQuerschnitt);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Reisezeit").setMillis(getReisezeit().getTime());
				// GanzzahlAttributTyp
				if (getLaenge() != null) {
	                if (getLaenge().isZustand()) {
	                    datum.getUnscaledValue("Länge").setText(getLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Länge").set(getLaenge().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGeschwindigkeit() != null) {
	                if (getGeschwindigkeit().isZustand()) {
	                    datum.getUnscaledValue("Geschwindigkeit").setText(getGeschwindigkeit().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Geschwindigkeit").set(getGeschwindigkeit().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessQuerschnitt = daten.getReferenceValue("MessQuerschnitt").getId();
					final SystemObjekt tmpMessQuerschnitt;
					if (idMessQuerschnitt == 0) {
						tmpMessQuerschnitt = null;
					} else {
						final SystemObject soMessQuerschnitt = factory.getDav().getDataModel().getObject(idMessQuerschnitt);
						if (soMessQuerschnitt == null) {
								tmpMessQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessQuerschnitt);
						} else {
							tmpMessQuerschnitt = factory.getModellobjekt(soMessQuerschnitt);
						}
					}
					setMessQuerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessQuerschnitt);
				// ZeitstempelAttributTyp
					setReisezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Reisezeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Länge").isState()) {
							setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Länge").getText()));
						} else {
						setLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Länge").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Geschwindigkeit").isState()) {
							setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("Geschwindigkeit").getText()));
						} else {
						setGeschwindigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("Geschwindigkeit").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgDatenReisezeitMQ clone() {
		AtlNbaStrgDatenReisezeitMQ klon = new AtlNbaStrgDatenReisezeitMQ();
		
						klon.setMessQuerschnitt(getMessQuerschnitt());
						klon.setReisezeit(getReisezeit());
						klon.setLaenge(getLaenge());
						klon.setGeschwindigkeit(getGeschwindigkeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
