/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Aktueller Schaltgrund der Ursacheneinheit.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgDatenSchaltgrundAlgorithmus1Bis4 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _messQuerschnitt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aktiv
			;
	
		/**
		Aktueller Schaltgrund des Messquerschnitt (aktiv&#47;inaktiv).
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 getMessQuerschnitt() {
			return _messQuerschnitt;
		}
	
		/**
		Aktueller Schaltgrund des Messquerschnitt (aktiv&#47;inaktiv).
		<p>
		
		</p>
		
		@param _messQuerschnitt der neue Wert von MessQuerschnitt.
		*/
		public void setMessQuerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
		 _messQuerschnitt) {
			this._messQuerschnitt = _messQuerschnitt;
		}
	
		/**
		Aktueller Zustand der Ursacheneinheit (aktiv&#47;inaktiv).
		<p>
		
		</p>
		
		@return der Wert von Aktiv.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getAktiv() {
			return _aktiv;
		}
	
		/**
		Aktueller Zustand der Ursacheneinheit (aktiv&#47;inaktiv).
		<p>
		
		</p>
		
		@param _aktiv der neue Wert von Aktiv.
		*/
		public void setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _aktiv) {
			this._aktiv = _aktiv;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessQuerschnitt = getMessQuerschnitt();
					final SystemObject tmpMessQuerschnitt;
						if (soMessQuerschnitt instanceof SystemObject) {
							tmpMessQuerschnitt = (SystemObject)soMessQuerschnitt;
						} else if(soMessQuerschnitt instanceof SystemObjekt){
							tmpMessQuerschnitt = ((SystemObjekt)soMessQuerschnitt).getSystemObject();
						} else{
							tmpMessQuerschnitt = null;
						}
					datum.getReferenceValue("MessQuerschnitt").setSystemObject(tmpMessQuerschnitt);
				// GanzzahlAttributTyp
				if (getAktiv() != null) {
	                if (getAktiv().isZustand()) {
	                    datum.getUnscaledValue("Aktiv").setText(getAktiv().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktiv").set(getAktiv().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessQuerschnitt = daten.getReferenceValue("MessQuerschnitt").getId();
					final SystemObjekt tmpMessQuerschnitt;
					if (idMessQuerschnitt == 0) {
						tmpMessQuerschnitt = null;
					} else {
						final SystemObject soMessQuerschnitt = factory.getDav().getDataModel().getObject(idMessQuerschnitt);
						if (soMessQuerschnitt == null) {
								tmpMessQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idMessQuerschnitt);
						} else {
							tmpMessQuerschnitt = factory.getModellobjekt(soMessQuerschnitt);
						}
					}
					setMessQuerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
					) tmpMessQuerschnitt);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Aktiv").isState()) {
							setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Aktiv").getText()));
						} else {
						setAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Aktiv").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgDatenSchaltgrundAlgorithmus1Bis4 clone() {
		AtlNbaStrgDatenSchaltgrundAlgorithmus1Bis4 klon = new AtlNbaStrgDatenSchaltgrundAlgorithmus1Bis4();
		
						klon.setMessQuerschnitt(getMessQuerschnitt());
						klon.setAktiv(getAktiv());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
