/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Analysedaten der Staulängenberechnung pro Stau.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgDatenStaulaenge implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
			 _stau
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laenge
			;
	
		/**
		Referenz auf einen Stau.
		<p>
		
		</p>
		
		@return der Wert von Stau.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
			 getStau() {
			return _stau;
		}
	
		/**
		Referenz auf einen Stau.
		<p>
		
		</p>
		
		@param _stau der neue Wert von Stau.
		*/
		public void setStau(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
		 _stau) {
			this._stau = _stau;
		}
	
		/**
		Länge des Stau.
		<p>
		
		</p>
		
		@return der Wert von Laenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLaenge() {
			return _laenge;
		}
	
		/**
		Länge des Stau.
		<p>
		
		</p>
		
		@param _laenge der neue Wert von Laenge.
		*/
		public void setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _laenge) {
			this._laenge = _laenge;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soStau = getStau();
					final SystemObject tmpStau;
						if (soStau instanceof SystemObject) {
							tmpStau = (SystemObject)soStau;
						} else if(soStau instanceof SystemObjekt){
							tmpStau = ((SystemObjekt)soStau).getSystemObject();
						} else{
							tmpStau = null;
						}
					datum.getReferenceValue("Stau").setSystemObject(tmpStau);
				// GanzzahlAttributTyp
				if (getLaenge() != null) {
	                if (getLaenge().isZustand()) {
	                    datum.getUnscaledValue("Länge").setText(getLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Länge").set(getLaenge().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idStau = daten.getReferenceValue("Stau").getId();
					final SystemObjekt tmpStau;
					if (idStau == 0) {
						tmpStau = null;
					} else {
						final SystemObject soStau = factory.getDav().getDataModel().getObject(idStau);
						if (soStau == null) {
								tmpStau = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StauUngueltig(idStau);
						} else {
							tmpStau = factory.getModellobjekt(soStau);
						}
					}
					setStau((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau
					) tmpStau);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Länge").isState()) {
							setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Länge").getText()));
						} else {
						setLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Länge").
								longValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgDatenStaulaenge clone() {
		AtlNbaStrgDatenStaulaenge klon = new AtlNbaStrgDatenStaulaenge();
		
						klon.setStau(getStau());
						klon.setLaenge(getLaenge());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
