/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Algorithmus7 (Stausituation, abschnittsbezogen).
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung
            Algorithmus7 (Stausituation, abschnittsbezogen) pro Kombination
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgKombinationAlgorithmus7 implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
			 _logik
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
			> _kombinationA = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
			> _kombinationB = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
			>(0, true);
	
		/**
		Logische Verknüpfung der Kombination A und Kombination B.
		<p>
		
		</p>
		
		@return der Wert von Logik.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
			 getLogik() {
			return _logik;
		}
	
		/**
		Logische Verknüpfung der Kombination A und Kombination B.
		<p>
		
		</p>
		
		@param _logik der neue Wert von Logik.
		*/
		public void setLogik(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
		 _logik) {
			this._logik = _logik;
		}
	
		/**
		Definition Kombination A Logik&#47; Streckenabschnitt.
		<p>
		
		</p>
		
		@return der Wert von KombinationA.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
			> getKombinationA() {
			return _kombinationA;
		}
	
	
		/**
		Definition Kombination B Logik&#47; Streckenabschnitt.
		<p>
		
		</p>
		
		@return der Wert von KombinationB.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
			> getKombinationB() {
			return _kombinationB;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getLogik() != null) {
	                if (getLogik().isZustand()) {
	                    datum.getUnscaledValue("Logik").setText(getLogik().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Logik").set(getLogik().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayKombinationA = datum.getArray("KombinationA");
					arrayKombinationA.setLength(getKombinationA().size());
					for (int i = 0; i < arrayKombinationA.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
						 atl = getKombinationA().get(i);
						atl.bean2Atl(arrayKombinationA.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayKombinationB = datum.getArray("KombinationB");
					arrayKombinationB.setLength(getKombinationB().size());
					for (int i = 0; i < arrayKombinationB.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
						 atl = getKombinationB().get(i);
						atl.bean2Atl(arrayKombinationB.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Logik").isState()) {
							setLogik(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
							.getZustand(daten.getScaledValue("Logik").getText()));
						} else {
						setLogik(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
						(daten.
							getUnscaledValue
						("Logik").
								byteValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayKombinationA = daten.getArray("KombinationA");
					for (int i = 0; i < arrayKombinationA.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
						 ();
						atl.atl2Bean(arrayKombinationA.getItem(i), factory);
						getKombinationA().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayKombinationB = daten.getArray("KombinationB");
					for (int i = 0; i < arrayKombinationB.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AtlNbaStrgKombinationStreckenabschnitt
						 ();
						atl.atl2Bean(arrayKombinationB.getItem(i), factory);
						getKombinationB().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgKombinationAlgorithmus7 clone() {
		AtlNbaStrgKombinationAlgorithmus7 klon = new AtlNbaStrgKombinationAlgorithmus7();
		
						klon.setLogik(getLogik());
					klon._kombinationA = getKombinationA().clone();
					klon._kombinationB = getKombinationB().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
