/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Kombination Streckenabschnitt(Stausituation, abschnittsbezogen).
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung
            Algorithmus7 (Stausituation, abschnittsbezogen) pro Streckenabschnitt
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlNbaStrgKombinationStreckenabschnitt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 _strassenTeilSegmentReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _siNr
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
			 _logik
			;
	
		/**
		Referenz auf ein StraßenTeilSegment.
		<p>
		
		</p>
		
		@return der Wert von StrassenTeilSegmentReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
			 getStrassenTeilSegmentReferenz() {
			return _strassenTeilSegmentReferenz;
		}
	
		/**
		Referenz auf ein StraßenTeilSegment.
		<p>
		
		</p>
		
		@param _strassenTeilSegmentReferenz der neue Wert von StrassenTeilSegmentReferenz.
		*/
		public void setStrassenTeilSegmentReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
		 _strassenTeilSegmentReferenz) {
			this._strassenTeilSegmentReferenz = _strassenTeilSegmentReferenz;
		}
	
		/**
		Über diese Nummer wird festgelegt, welcher Stauindikator auf dem StraßenTeilSegment
		            für die Berechnung verwendet werden soll. Nummerierung erfolgt in Fahrtrichtung aufsteigend.
		<p>
		
		</p>
		
		@return der Wert von SiNr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getSiNr() {
			return _siNr;
		}
	
		/**
		Über diese Nummer wird festgelegt, welcher Stauindikator auf dem StraßenTeilSegment
		            für die Berechnung verwendet werden soll. Nummerierung erfolgt in Fahrtrichtung aufsteigend.
		<p>
		
		</p>
		
		@param _siNr der neue Wert von SiNr.
		*/
		public void setSiNr(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _siNr) {
			this._siNr = _siNr;
		}
	
		/**
		Verknüpfungslogik der Kombination.
		<p>
		
		</p>
		
		@return der Wert von Logik.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
			 getLogik() {
			return _logik;
		}
	
		/**
		Verknüpfungslogik der Kombination.
		<p>
		
		</p>
		
		@param _logik der neue Wert von Logik.
		*/
		public void setLogik(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
		 _logik) {
			this._logik = _logik;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soStrassenTeilSegmentReferenz = getStrassenTeilSegmentReferenz();
					final SystemObject tmpStrassenTeilSegmentReferenz;
						if (soStrassenTeilSegmentReferenz instanceof SystemObject) {
							tmpStrassenTeilSegmentReferenz = (SystemObject)soStrassenTeilSegmentReferenz;
						} else if(soStrassenTeilSegmentReferenz instanceof SystemObjekt){
							tmpStrassenTeilSegmentReferenz = ((SystemObjekt)soStrassenTeilSegmentReferenz).getSystemObject();
						} else{
							tmpStrassenTeilSegmentReferenz = null;
						}
					datum.getReferenceValue("StraßenTeilSegmentReferenz").setSystemObject(tmpStrassenTeilSegmentReferenz);
				// GanzzahlAttributTyp
				if (getSiNr() != null) {
	                if (getSiNr().isZustand()) {
	                    datum.getUnscaledValue("SiNr").setText(getSiNr().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SiNr").set(getSiNr().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLogik() != null) {
	                if (getLogik().isZustand()) {
	                    datum.getUnscaledValue("Logik").setText(getLogik().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Logik").set(getLogik().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idStrassenTeilSegmentReferenz = daten.getReferenceValue("StraßenTeilSegmentReferenz").getId();
					final SystemObjekt tmpStrassenTeilSegmentReferenz;
					if (idStrassenTeilSegmentReferenz == 0) {
						tmpStrassenTeilSegmentReferenz = null;
					} else {
						final SystemObject soStrassenTeilSegmentReferenz = factory.getDav().getDataModel().getObject(idStrassenTeilSegmentReferenz);
						if (soStrassenTeilSegmentReferenz == null) {
								tmpStrassenTeilSegmentReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenTeilSegmentUngueltig(idStrassenTeilSegmentReferenz);
						} else {
							tmpStrassenTeilSegmentReferenz = factory.getModellobjekt(soStrassenTeilSegmentReferenz);
						}
					}
					setStrassenTeilSegmentReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment
					) tmpStrassenTeilSegmentReferenz);
				// GanzzahlAttributTyp
						setSiNr(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("SiNr").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Logik").isState()) {
							setLogik(de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
							.getZustand(daten.getScaledValue("Logik").getText()));
						} else {
						setLogik(new de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute.AttNbaOperator
						(daten.
							getUnscaledValue
						("Logik").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgKombinationStreckenabschnitt clone() {
		AtlNbaStrgKombinationStreckenabschnitt klon = new AtlNbaStrgKombinationStreckenabschnitt();
		
						klon.setStrassenTeilSegmentReferenz(getStrassenTeilSegmentReferenz());
						klon.setSiNr(getSiNr());
						klon.setLogik(getLogik());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
