/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmnbaglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste Parameter Steuerung Mindeststandzeit.
<p>
&lt;absatz&gt;
						Attributliste für Definition der Parameter Steuerung für lokale Beeinflussung
            Mindeststandzeit
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNbaStrgMindeststandzeit implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	RelativerZeitstempel
			 _tMinEin
			;
			private 	RelativerZeitstempel
			 _tMinAus
			;
			private 	RelativerZeitstempel
			 _tMinStoer
			;
	
		/**
		Damit eine Schaltbildanforderung wirksam wird, muss sie mindestens tMinEin ununterbrochen angelegen haben.
		<p>
		
		</p>
		
		@return der Wert von TMinEin.
		*/
			public 	RelativerZeitstempel
			 getTMinEin() {
			return _tMinEin;
		}
	
		/**
		Damit eine Schaltbildanforderung wirksam wird, muss sie mindestens tMinEin ununterbrochen angelegen haben.
		<p>
		
		</p>
		
		@param _tMinEin der neue Wert von TMinEin.
		*/
		public void setTMinEin(	RelativerZeitstempel
		 _tMinEin) {
			this._tMinEin = _tMinEin;
		}
	
		/**
		Die Schaltbildanforderung wird, auch wenn sie nicht mehr anliegt, solange weiter angefordert, bis die Ausschaltbedingung mindestens die Zeit tMinAus angelegen haben.
		<p>
		
		</p>
		
		@return der Wert von TMinAus.
		*/
			public 	RelativerZeitstempel
			 getTMinAus() {
			return _tMinAus;
		}
	
		/**
		Die Schaltbildanforderung wird, auch wenn sie nicht mehr anliegt, solange weiter angefordert, bis die Ausschaltbedingung mindestens die Zeit tMinAus angelegen haben.
		<p>
		
		</p>
		
		@param _tMinAus der neue Wert von TMinAus.
		*/
		public void setTMinAus(	RelativerZeitstempel
		 _tMinAus) {
			this._tMinAus = _tMinAus;
		}
	
		/**
		Befindet sich die Ausschaltbedingung für eine Schaltbildanforderung mindestens die Zeit tMinStör im Zustand nicht ermittelbar, so wird die Schaltbildanforderung ebenfalls gelöscht.
		<p>
		
		</p>
		
		@return der Wert von TMinStoer.
		*/
			public 	RelativerZeitstempel
			 getTMinStoer() {
			return _tMinStoer;
		}
	
		/**
		Befindet sich die Ausschaltbedingung für eine Schaltbildanforderung mindestens die Zeit tMinStör im Zustand nicht ermittelbar, so wird die Schaltbildanforderung ebenfalls gelöscht.
		<p>
		
		</p>
		
		@param _tMinStoer der neue Wert von TMinStoer.
		*/
		public void setTMinStoer(	RelativerZeitstempel
		 _tMinStoer) {
			this._tMinStoer = _tMinStoer;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("tMinEin").setMillis(getTMinEin().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("tMinAus").setMillis(getTMinAus().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("tMinStör").setMillis(getTMinStoer().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setTMinEin(new
						RelativerZeitstempel
						(daten.getTimeValue("tMinEin").getMillis()));
				// ZeitstempelAttributTyp
					setTMinAus(new
						RelativerZeitstempel
						(daten.getTimeValue("tMinAus").getMillis()));
				// ZeitstempelAttributTyp
					setTMinStoer(new
						RelativerZeitstempel
						(daten.getTimeValue("tMinStör").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStrgMindeststandzeit clone() {
		AtlNbaStrgMindeststandzeit klon = new AtlNbaStrgMindeststandzeit();
		
						klon.setTMinEin(getTMinEin());
						klon.setTMinAus(getTMinAus());
						klon.setTMinStoer(getTMinStoer());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
